#delimit;
clear;
capture log close;
set more off;
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;

global folder "D:\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "~/";
*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";
*global folder "C:\Users\uctpkp0\Desktop";

         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";

log using `saved'pension.log, replace;  
set memory 1g;




************************************************************************************************;

******************************* PENSION  VARIABLES **************************************;
/* There are 2 types of pension plans - DEFINED BENEFITS (typeA) and DEFINED CONTRIBUTION (typeB).
An individual in the HRS can potentially have a pension from either the CURRENT job, LAST job 
(currently not working, last job), or OTHER jobs (previous jobs). Pension  measures are coded for all 
3 possible jobs. For DB (Defined Benefits Plans), the variables are pentypeDBxcurr, pentypeDBxlast, and 
pentypeDBxprev, where x indicates the appropriate wave (1-5). For DC plans, they are pentypeDCxcurr, 
pentypeDCxlast, and pentypeDCxprev. 

Some people do not have any pension plans, and their corresponding pentypeDB and pentypeDC
values are set to 0. A person does not have a pension plan if they are "NOT WORKING FOR PAY", or answered
"SELF-EMPL. WITHOUT A PENSION PLAN" or DK to "ARE YOU INCLUDED IN PENSION PLAN?". 

Note, in WAVE1 there isn't a DK option for "included in pension plan?" for "last" jobs (this is not the 
case for other waves), and with "other" jobs respondents are not asked about working for 
pay (in all waves), or being included in a plan (only in wave 1, but they are asked this in other waves).

If a person refused to answer "are you included in a pension plan", or "working for pay?", their 
pentype variable is set to be missing. 

If the person was alive in previous wave and died by the following wave, all pentype values for that
wave are set to 0.

The HRS assumes that a job can have up to THREE PLANS. Therefore, there are three separate variables 
corresponding to each plan: pentypeDBx... is equal to 1 if a person reports either a TYPEA (DB) or a 
COMBINATION Plan, 0 if they report a DC plan. Likewise, pentypeDCx... is set to 1 if TYPEB or COMBINATION 
plan is reported, 0 if a DB plan is reported. Note, in WAVE1 "last" and "prev" jobs do NOT have thee plans,
but only one. In WAVE2 and after, there are two PREVIOUS job variables. One asks about the most recent 
previous employer and the other about any other past employer with a pension plan.

People who CHANGED JOBS between Waves t and t+1 are asked about their new DB and/or DC pension plans.

We generate pentypeDBx, which is equal to 1 if either current, previous or last job had a DB plan, 
likewise for pentypeDCx.

Starting in Wave2, a separate variable records the DB and DC pension plans of CURRENTLY SELF EMPLOYED 
respondents (the possibilities are -- worked for a previous employer, became SE in current wave, or
was SE in last wave and still SE in this wave. */ 


************************** ASSUMPTIONS AND IMPUTATIONS **********************************;
/*If a person reported that they are eligible for pension benefits ANYTIME, we assume they have a DB plan.  

In Waves2-5, we IMPUTED the "last" job pension plans for those respondents who QUIT WORKING in wave_t and 
retired in wave_t+1. We assign their pension plan in wave t to their pentypeDBt+1 or pentypeDCt+1.*/


********************************* OTHER VARIABLES ****************************************;
/*PENSION WEALTH is generated for each wave. We only compute wealth for DC plans, because DB plans are too nasty.
For each of the thee plans, respondents are asked "how much money is in you account?", penwDCx... 
is the sum of these, where "..." stands for curr, prev and last jobs. Note, for last and previous jobs,
respondents are asked about the amount of money in their account at the time they left the job, and the amount of
money in the account NOW. We use their "now" account balance to calculate their DC pension wealth. Some people 
were given the option to leave the money in DC plan when they left the last job, others rolled it over to IRA or cashed it
out. If the money was taked out of the plan, we set pension wealth from last job's DC plan to be zero. If it was left 
there to accumulate, we count the value of that DC plan NOW.
We then generate penwDCx, which is the sum of current, previous and last pension wealths for that wave. 

PENSION WEALTH for last and previous jobs looked choppy from wave to wave. This is due to the fact that only new spouses 
are interviewed in waves2-... (those people who reported last jobs wealth in wave1 are left alone in later waves). Therefore,
the number of people who reported positive pension wealth is very small and the variation of mean wealth from wave to wave is 
considerable. Also, in wave4 the AHEAD cohort was added in, as well as some new people. These people are asked about 
their last jobs and prev jobs in wave4.

TENURE. We calculate it as: year last worked - year started working.

pennage equals the normal RETIREMENT AGE in a DB plan, peneage equals the early retirement age   

We also coded up GOVERNMENT WORKERS ("have you ever been employed by state or local govt.?". 
If someone did not report the years they worked for government, we assumed they worked there for
the last 20 years. */;

**************************************************************************************************;



********************************* wave 1 *********************************;
use `wave1d'employer;

**************************** pension type -- DEFINED BENEFITS PLAN (typeA) ************************;
gen pentypeDB1curr=.;
gen pentypeDB1last=.;
gen pentypeDB1prev=.;

************** part 1A: current job *************;

*are you working for pay?;
replace pentypeDB1curr=0 if V2717==5; * not working for pay;
*are you included in any pension plan?;
replace pentypeDB1curr=0  if V2838==5; * self-employed without pension plans other than IRA or Keogh;
replace pentypeDB1curr=0 if V2838==8; * DK;
replace pentypeDB1curr=. if V2838==9; * RF;

************** part 1B: retired, last job *************;

replace pentypeDB1last=0 if V3401==5; * never worked for pay for more than a few months;
replace pentypeDB1last=0  if V3448==5; * self-employed on last job without pension plans other than IRA or Keogh;
***there are no choices 8 (DK) or 9 (REF) for var V3448***; 


************** part 1C: prev job *************;
**this section does not ask whether you ever worked for pay.;
**It also does not ask about IRA/Keogh accounts ==> not coding for pentypeDB1prev;


******************************************************************************;
************* part 2A: CURRENT JOB ************;

replace pentypeDB1curr=0 if V2901==5|V2901==8; * NO and DK for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;
replace pentypeDB1curr=. if pentypeDB1curr~=0 & pentypeDB1curr~=1 & V2901==9; * RF;


*a job can have up to 3 pension plans, either one of them could be DB -- checking all;
* for pension plan 1 -- DB;
replace pentypeDB1curr=1 if V2909==1|V2909==3;
replace pentypeDB1curr=0 if V2909==2;
replace pentypeDB1curr=. if pentypeDB1curr~=1 & pentypeDB1curr~=0 & (V2909==8|V2909==9);


* for pension plan 2 -- DB ;
replace pentypeDB1curr=1 if V3009==1|V3009==3;
replace pentypeDB1curr=0 if pentypeDB1curr~=1 & V3009==2;
replace pentypeDB1curr=. if pentypeDB1curr~=1 & pentypeDB1curr~=0 & (V3009==8|V3009==9);

* for pension plan 3 -- DB;
replace pentypeDB1curr=1 if V3109==1|V3109==3;
replace pentypeDB1curr=0 if pentypeDB1curr~=1 & V3109==2;
replace pentypeDB1curr=. if pentypeDB1curr~=1 & pentypeDB1curr~=0 & (V3109==8|V3109==9);


*earliest age at which eligible to receive benefits -- anytime means they have a DB plan;
* replace pentypeDB1curr=1 if (V2919>0 & V2919<97)|(V3019>0 & V3019<97)|(V3119>0 & V3119<97);
* replace pentypeDB1curr=1 if (V2925>0 & V2925<97)|(V3025>0 & V3025<97)|(V3125>0 & V3125<97);


************* part 2B: RETIRED, LAST JOB***********;

replace pentypeDB1last=0 if V3430==5; * NO for "ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN", DK/RF not available;

**there are no pension plans 1,2 and 3 in this section;
replace pentypeDB1last=1 if V3501==1|V3501==3;
replace pentypeDB1last=0 if V3501==2;
replace pentypeDB1last=. if pentypeDB1last~=1 & pentypeDB1last~=0 & (V3501==8|V3501==9);  *DK/NA;


*only people with defined benefits should answer this;
*only one plan --> no "or" conditioning;

* replace pentypeDB1last=1 if (V3529>0 & V3529<97); *Q:what is earliest age could leave and receive benefits A:any;
* replace pentypeDB1last=1 if (V3519>0 & V3519<97);  *already receiving benefits (but don't know what kind);


************* part 2C: PREVIOUS JOBS ************;
replace pentypeDB1prev=0 if V3620==5; * NO for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;


* V3708 -- any other employer with a pension plan , V3621 -- most recent employer;
replace pentypeDB1prev=1 if V3621==1|V3621==3|V3708==1|V3708==3;
replace pentypeDB1prev=0 if (V3621==2 & V3708==2);
replace pentypeDB1prev=. if pentypeDB1prev~=1 & pentypeDB1prev~=0 & (V3621==8|V3621==9|V3708==8|V3708==9);

/*
gen chk=0;
replace chk=1 if pentypeDB1prev~=1 & (V3649>0 & V3649<97);
sort chk;
by chk: tab V3621;

*/

*replace pentypeDB1prev=1 if (V3649>0 & V3649<97);  **Q:what is earliest age could leave and receive benefits A:any;




************************************************************************************************;
**************** pension type B -- DEFINED CONTRIBUTION plan************************************;
gen pentypeDC1curr=.;    *current job;
gen pentypeDC1last=.;    *retired, last job before retirement;
gen pentypeDC1prev=.;    *previous jobs;

************** part 1 *************;
****current;
replace pentypeDC1curr=0 if V2717==5; * not working for pay;
replace pentypeDC1curr=0  if V2838==5; * self-employed without pension plans other than IRA or Keogh;
replace pentypeDC1curr=0 if V2838==8; * DK;
replace pentypeDC1curr=. if V2838==9; * RF;

****last;
replace pentypeDC1last=0 if V3401==5; * not working for pay;
replace pentypeDC1last=0  if V3448==5; * self-employed without pension plans other than IRA or Keogh;

****nothing for previous;



************* part 2A: CURRENT JOB ************;

replace pentypeDC1curr=0 if V2901==5|V2901==8; * NO and DK for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;
replace pentypeDC1curr=. if pentypeDC1curr~=0 & V2901==9; * RF;

* for pension plan 1;
replace pentypeDC1curr=1 if V2909==2|V2909==3;
replace pentypeDC1curr=0 if V2909==1;
replace pentypeDC1curr=. if pentypeDC1curr~=1 & pentypeDC1curr~=0 & (V2909==8|V2909==9);


* for pension plan 2;
replace pentypeDC1curr=1 if V3009==2|V3009==3;
replace pentypeDC1curr=0 if pentypeDC1curr~=1 & V3009==1;
replace pentypeDC1curr=. if pentypeDC1curr~=1 & pentypeDC1curr~=0 & (V3009==8|V3009==9);

* for pension plan 3
replace pentypeDC1curr=1 if V3109==2|V3109==3;
replace pentypeDC1curr=0 if pentypeDC1curr~=1 & V3109==1;
replace pentypeDC1curr=. if pentypeDC1curr~=1 & pentypeDC1curr~=0 & (V3109==8|V3109==9);

*describing typeB plan -- thrift, 401K, annuity... all less then 11;

replace pentypeDC1curr=1 if (V2932>0 & V2932<11)|(V3032>0 & V3032<11)|(V3132>0 & V3132<11);
replace pentypeDC1curr=1 if (V2932>11 & V2932<98)|(V3032>11 & V3032<98)|(V3132>11 & V3132<98);
replace pentypeDC1curr=1  if (V2933>0 & V2933<98)|(V3033>0 & V3033<98)|(V3133>0 & V3133<98);


************* part 2B: RETIRED, LAST JOB ************;
replace pentypeDC1last=0 if V3430==5; * NO for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;

replace pentypeDC1last=1 if V3501==2|V3501==3;
replace pentypeDC1last=0 if V3501==1;
replace pentypeDC1last=. if pentypeDC1last~=1 & pentypeDC1last~=0 & (V3501==8|V3501==9);

**this module does not ask the respondents to describe their typeB plan;

************* part 2C: PREVIOUS TO LAST JOBS ************;
replace pentypeDC1prev=0 if V3620==5; * NO for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;

* V3708 -- any other employer with a pension plan , V3621 -- most recent employer ;
replace pentypeDC1prev=1 if V3621==2|V3621==3|V3708==2|V3708==3;
replace pentypeDC1prev=0 if (V3621==1 & V3708==1);
replace pentypeDC1prev=. if pentypeDC1prev~=1 & pentypeDC1prev~=0 & (V3621==8|V3621==9|V3708==8|V3708==9);

**this module does not ask the respondents to describe their typeB plan;


*****************************************************************************************;
*****************************************************************************************;
* now get pension wealth;
*gen penwoth1=V2910; * DB pension wealth--too nasty to compute to make things worthwhile;


*How much money is in your account AT PRESENT?;
replace V2940=0 if (V2940==.| V2940>9900000);
replace V3040=0 if (V3040==.| V3040>9900000);
replace V3140=0 if (V3140==.| V3140>9900000);

gen penwDC1curr=V2940+V3040+V3140;
replace penwDC1curr=0 if penwDC1curr==.;

*V3502 -- combo, V3523 -- DC;
replace V3502=0 if (V3502==.| V3502>9900000); * value of COMBINED plan when you left the job;
replace V3523=0 if (V3523==.| V3523>9900000); * value of DC plan when you left the job;
replace V3525=0 if (V3525==.| V3525>9900000); * how much is in your account now?;
replace V3525=0 if V3524~=3; * still in the DC plan=> V3524==3 ("left to accumulate");

gen penwDC1last=V3502+V3525;
replace penwDC1last=0 if penwDC1last==.;

*prev = combo most recent+DC most recent + combo other +DC other;
****most recent job;
replace V3622=0 if (V3622==.| V3622>9900000); *COMBO PLAN -how much money was in your account when you left?;
replace V3643=0 if (V3643==.| V3643>9900000); *DC plan - how much money was in your account when you left?;
replace V3645=0 if (V3645==.| V3645>9900000); *DC paln - how much is in your account NOW?;
replace V3645=0 if V3644~=3;  * still in the DC plan=>V3644==3; 

****what's below is a repeat for other job;
replace V3709=0 if (V3709==.| V3709>9900000);
replace V3730=0 if (V3730==.| V3730>9900000);
replace V3732=0 if (V3732==.| V3732>9900000);
replace V3732=0 if V3731~=3;  * still in the DC plan=>V3731==3; 

gen penwDC1prev=V3622+V3645+V3709+V3732;
replace penwDC1prev=0 if penwDC1prev==.;

gen penwDC1 = penwDC1curr + penwDC1last + penwDC1prev;


* sum over all pension plans;
gen pentypeDB1=.;
replace pentypeDB1=1 if (pentypeDB1curr==1|pentypeDB1last==1|pentypeDB1prev==1); *6018 changes made;
replace pentypeDB1=pentypeDB1curr;
gen pentypeDC1=.;
replace pentypeDC1=1 if (pentypeDC1curr==1|pentypeDC1last==1|pentypeDC1prev==1); 
replace pentypeDC1=pentypeDC1curr;
replace pentypeDB1=1 if (pentypeDB1last==1| pentypeDB1prev==1);
replace pentypeDC1=1 if (pentypeDC1last==1| pentypeDC1prev==1);

***************tenure ******************;
replace V3403=0 if V3403==9998|V3403==9999;  *DK, RF;
replace V3418=0 if V3418==9998|V3418==9999;  *DK, RF;
gen tenurelast1=V3403-V3418 if V3403>V3418 & V3418~=0;  *year last worked - year started working;
replace tenurelast1=0 if tenurelast1<0 & tenurelast1>-100;

replace V3607=. if V3607==0;
replace V3607=. if V3607>1993;
replace V3604=. if V3604==0;
replace V3607=. if V3607>1993;
gen tenureprev1=V3607-V3604;
replace tenureprev1=0 if tenureprev1<0;
*replace tenureprev1=0 if tenureprev1<0 & tenureprev1>-100;



**************earnings on last job****************;
gen earnlast1= V3412 if V3413==6; *how much earning, if salary is per year;
replace earnlast1=V3412*(V3411/4) if V3413==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast1=V3412*(V3411/2) if V3413==3; * salary is bi-weekly;
replace earnlast1=V3412*(V3411) if V3413==2; *salary is weekly;
replace earnlast1=(V3412*V3411*V3408)/100 if V3413==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast1=. if V3412>9999997;
replace earnlast1=. if V3411>96;
replace earnlast1=. if V3408>97;
************* hourly wages******************;
gen wagelast1=earnlast1/(V3408*V3411);


****************earnings on prev job**************;
gen earnprev1= V3610 if V3611==6;
replace earnprev1=V3610*(V3609/4) if V3611==4;
replace earnprev1=V3610*(V3609/2) if V3611==3;
replace earnprev1=V3610*(V3609) if V3611==2;
replace earnprev1=(V3610*V3609*V3608)/100 if V3611==1;


replace earnprev1=. if V3610>9999995;
replace earnprev1=. if V3609>97;
replace earnprev1=. if V3608>97;

************* hourly wages******************;
gen wageprev1=earnprev1/(V3608*V3609); *earn/(hrs a week*weeks worked);



************** age of access to pension benefits *****************;
* for pension plan 1;
gen peneage1=V2925;
replace peneage1=30 if peneage1==96; * access pension benefits any time;
replace peneage1=. if peneage1==0|peneage1>96; * "no job" or "no pension" or "NA" or "DK";

* for pension plan 2;
replace peneage1=V3025 if peneage1~=. & peneage1>V3025 &  V3025~=0; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage1=V3025 if peneage1==.;
replace peneage1=. if peneage1==0|peneage1>96; 
replace peneage1=30 if V3025==96; * access pension benefits anytime;

* for pension plan 3;
replace peneage1=V3125 if peneage1~=. & peneage1>V3125 &  V3125~=0; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace peneage1=V3125 if peneage1==.;
replace peneage1=. if peneage1==0|peneage1>96; 
replace peneage1=30 if V3125==96; * access pension benefits anytime;


******************* age of normal pension benefits************ 
* for pension plan 1;
gen pennage1=V2919;
replace pennage1=30 if pennage1==96;* access pension benefits anytime;
replace pennage1=. if pennage1==0|pennage1>96; * "no job" or "no pension" or "NA" or "DK";

* for pension plan 2;
replace pennage1=V3019 if pennage1~=. & pennage1>V3019 &  V3019~=0; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage1=V3019 if pennage1==.;
replace pennage1=. if pennage1==0|pennage1>96; 
replace pennage1=30 if V3019==96; * access pension benefits anytime;

* for pension plan 3;
replace pennage1=V3119 if pennage1~=. & pennage1>V3119 &  V3119~=0; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace pennage1=V3119 if pennage1==.;
replace pennage1=. if pennage1==0|pennage1>96; 
replace pennage1=30 if V3119==96; * access pension benefits anytime;


******************************************************************;
******GOVT WORKERS************************************************;

replace V3940=. if V3940==0;
replace V3941=. if V3941==0;
replace V3942=. if V3942==0;
replace V3943=. if V3943==0;
replace V3944=. if V3944==0;
replace V3940=. if V3940>1993;
replace V3941=. if V3941>1993;
replace V3942=. if V3942>1993;
replace V3943=. if V3943>1993;
replace V3944=. if V3944>1993;

gen Govt1=0;
replace Govt1=V3940 if (V3940==1|V3940==5);
tab V3940;
tab Govt1;
gen GovtYears1=0;
* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin1=V3941;
replace GovtBegin1=1974 if V3941==. & Govt1==1;
gen GovtEnd1=V3942 ;
replace GovtEnd1=1992 if V3942==. & Govt1==1;
replace GovtYears1=GovtEnd1-GovtBegin1;
gen ExYears1=V3944-V3943; *2nd spell for the govt;
replace GovtYears1=GovtYears1+(ExYears1) if (ExYears1>0 & ExYears1~=.);
replace GovtEnd1=V3944 if V3944~=.;
replace GovtYears1=1 if GovtYears1<1 & GovtYears1~=.;
sort Govt1;
by Govt1: sum Govt* Ex*;


sum pentypeDC1 peneage1 pennage1 pentypeDB1 penwDC1* HHID PN; 

keep pentypeDC1* peneage1 pennage1 pentypeDB1* penwDC1* tenurelast1 tenureprev1 HHID PN Govt* earn* wage*; 
sort HHID PN;
sleep 1000;  save `saved'pension, replace;
summ;
drop _all; 


*** all the qualifiers confirmed correct in wave 1;




*********************************************   WAVE 2 **********************************
******************************************************************************************;
*merging "current" "last" and "previous" datasets together...;
clear;
**set mem 200m;
use `wave1d'employer;  ***to know whether or not a person worked in wave1***;
sort HHID PN; 
sleep 1000;  save `wave2d'temp, replace;
clear;

**set mem 200m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave1;
sort HHID PN; 
merge HHID PN using `wave2d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave2d'temp, replace;
clear;



**set mem 200m;
use `wave2d'w2fa;
sort HHID PN; 
merge HHID PN using `wave2d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave2d'temp, replace;
clear;

**set mem 200m;
use `wave2d'w2fb;
sort HHID PN; 
merge HHID PN using `wave2d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave2d'temp, replace;

clear;
**set mem 200m;
use `wave2d'w2fc;
sort HHID PN; 
merge HHID PN using `wave2d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave2d'temp, replace;

clear;
*set mem 200m;
use `wave2d'w2g;
sort HHID PN; 
merge HHID PN using `wave2d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave2d'temp, replace;

clear;
*set mem 200m;
use `wave2d'w2h;
sort HHID PN; 
merge HHID PN using `wave2d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave2d'temp, replace;



********* people whose pension didn't change since wave 1**********;
**those currently working;
gen same_pen2=0;
*"retired, last job" section does not ask this question, only currently employed answer;
replace same_pen2=1 if W3710==5; * Have the rules that govern your pension benefits or;
                             * the age you can receive them changed since WAVE1--No;
replace same_pen2=1 if W4376==5; * ditto for self-employed;
tabulate same_pen2;





********************************* wave 2  *********************************;


**************************** pension type -- defined benefits plan (typeA) ************************;
****************for now, ignoring the unemployed reporting their pensions from previous jobs;
gen pentypeDB2curr=.;
gen pentypeDB2last=.;
gen pentypeDB2prev=.;

************** part 1A: current job *************;


replace pentypeDB2curr=0 if W3316==0; *Wave1 respondent died and this is a proxy interview;
replace pentypeDB2curr=0 if W3316==5|W3316==8; * NO and DK for WORKING FOR PAY;


************** part 1B: retired, last job *************;

replace pentypeDB2last=0 if W7000==5; * never worked for pay for more than a few months;
replace pentypeDB2last=0  if W7000==8;  *DK;


************** part 1C: prev job (job history) *************;
replace pentypeDB2prev=0 if W7100==5; * never worked for pay for more than a few months;
replace pentypeDB2prev=0  if W7100==8;  *DK;




***********************************************;
************* part 2A: CURRENT JOB, NOT self-employed ************;
* W3421 => Pension plan for people who were self-employed wave 1, still self employed (as a 2nd job);
replace pentypeDB2curr=0 if W3421==5|W3421==8; * NO and DK for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & (W3748==5|W3748==8);  *NO and DK for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN, main job;

replace pentypeDB2curr=0 if W3710==7; *deny being covered by any pension plan;


**DB --same job/pension plan as in wave1 interview;

* for pension plan 1 -- DB;
replace pentypeDB2curr=1 if W3712==1|W3712==3;
replace pentypeDB2curr=0 if W3712==2;

* for pension plan 2 -- DB;
replace pentypeDB2curr=1 if W3724==1|W3724==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W3724==2;

* for pension plan 3 -- DB;
replace pentypeDB2curr=1 if W3736==1|W3736==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W3736==2;

**DB--switched jobs between wave 1 and wave2;

* for pension plan 1 -- DB;
replace pentypeDB2curr=1 if W3756==1|W3756==3;
replace pentypeDB2curr=0 if W3756==2;

* for pension plan 2 -- DB;
replace pentypeDB2curr=1 if W3808==1|W3808==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W3808==2;

* for pension plan 3 -- DB;
replace pentypeDB2curr=1 if W3860==1|W3860==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W3860==2;

**DB -- not working and self-employed --- report only one plan, not three;
replace pentypeDB2curr=1 if W3422==1|W3422==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W3422==2;

replace pentypeDB2curr=1 if W3572==1|W3572==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W3572==2;


**12/20/05 -- decided agains using proxi questions to determine benefits type;
*what is the earliest age at which you could have stopped working and receive benefits ==> any;
*not working and self-employed;
*replace pentypeDB2curr=1 if W3457>0 & W3457<93;
*replace pentypeDB2curr=1 if W3457==95; 
*replace pentypeDB2curr=1 if W3607>0 & W3607<93;
*replace pentypeDB2curr=1 if W3607==95; 
*same job as in wave1 interview;
*replace pentypeDB2curr=1 if W3770>0 & W3770<93;
*replace pentypeDB2curr=1 if W3770==95; 
*replace pentypeDB2curr=1 if W3822>0 & W3822<93;
*replace pentypeDB2curr=1 if W3822==95;
*replace pentypeDB2curr=1 if W3874>0 & W3874<93;
*replace pentypeDB2curr=1 if W3874==95;
*switched jobs between wave 1 and wave2;
*replace pentypeDB2curr=1 if W3778>0 & W3778<94;
*replace pentypeDB2curr=1 if W3778==95; 
*replace pentypeDB2curr=1 if W3830>0 & W3830<94;
*replace pentypeDB2curr=1 if W3830==95;
*replace pentypeDB2curr=1 if W3882>0 & W3882<94;
*replace pentypeDB2curr=1 if W3882==95;


************* part 2A: CURRENT JOB, those who are self-employed ************;

******** part 1 *****************;
*previous employer before becoming self-employed;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & (W4272==5|W4272==8); *Were you included in a pension or retirement plan;
*current self-employment;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & (W4375==5|W4375==8); *are you included in emp. pension plan;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4376==7; * deny being covered by a pension plan;

*those who worked for a previous employer before becoming self-employed;
replace pentypeDB2curr=1 if W4273==1|W4273==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4273==2;

*self-empl, same job/plan--asked about up to three plans;
* for pension plan 1;
replace pentypeDB2curr=1 if W4378==1|W4378==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4378==2;

* for pension plan 2;
replace pentypeDB2curr=1 if W4390==1|W4390==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4390==2;

* for pension plan 3;
replace pentypeDB2curr=1 if W4402==1|W4402==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4402==2;

*switched empl. since wave1;
* for pension plan 1;
replace pentypeDB2curr=1 if W4415==1|W4415==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4415==2;

* for pension plan 2;
replace pentypeDB2curr=1 if W4467==1|W4467==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4467==2;

* for pension plan 3;
replace pentypeDB2curr=1 if W4519==1|W4519==3;
replace pentypeDB2curr=0 if pentypeDB2curr~=1 & W4519==2;

**12/20/05 -- decided agains using proxi questions to determine benefits type;
*what is the earliest age at which you would be able to receive pension benefits?;
*replace pentypeDB2curr=1 if (W4312>0 & W4312<93); *for the job held prev. to self-empl;
*replace pentypeDB2curr=1 if (W4429>0 & W4429<98)|(W4481>0 & W4481<98)|(W4533>0 & W4533<98);
*replace pentypeDB2curr=1 if (W4437>0 & W4437<98)|(W4489>0 & W4489<98)|(W4541>0 & W4541<98);
*How much would these full or unreduced benefits be as a percentage of your pay?;
*replace pentypeDB2curr=1 if (W4430>0 & W4429<8)|(W4482>0 & W4482<8)|(W4534>0 & W4534<8);


************* part 2B: RETIRED, LAST JOB***********;

replace pentypeDB2last=0 if W7032==5|W7032==8; * NO and DK for "ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN";

**there are no pension plans 1,2 and 3 in this section;
replace pentypeDB2last=1 if W7033==1|W7033==3;
replace pentypeDB2last=0 if W7033==2;

******imputed last job pension plans, V2701 - working in wave1, W3300-3302 - retired in wave2***********;
replace pentypeDB2last=1 if V2701==1 & (W3300==5|W3301==5|W3302==5) & pentypeDB1curr==1;





************* part 2C: PREVIOUS JOBS ************;
replace pentypeDB2prev=0 if W7123==5|W7123==8; * NO for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;
replace pentypeDB2prev=0 if W7160==5|W7160==8; * jobs before last --NO for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;
*W7124 -- most recent employer;
replace pentypeDB2prev=1 if W7124==1|W7124==3;
replace pentypeDB2prev=0 if W7124==2;
* W7166,W7200 -- any other employer (up to two) with a pension plan;
replace pentypeDB2prev=1 if (W7166==1|W7166==3)|(W7200==1|W7200==3);
replace pentypeDB2prev=0 if (W7166==2 & W7200==2);





************************************************************************************************;
**************** pension type B -- DEFINED CONTRIBUTION plan (Type B)***************************;
gen pentypeDC2curr=.;    *current job;
gen pentypeDC2last=.;    *retired, last job before retirement;
gen pentypeDC2prev=.;    *previous jobs;

************** part 1***********************; 
****CURRENT JOB - DC;
replace pentypeDC2curr=0 if W3316==0; *Wave1 respondent dies and this is a proxy interview;
replace pentypeDC2curr=0 if W3316==5|W3316==8; *not working for pay adn DK;

****last - DC;
replace pentypeDC2last=0 if W7000==5|W7000==8; *not working for pay, DK;

****previous - DC;
replace pentypeDC2prev=0 if W7100==5|W7100==8; *never worked for pay;


************* part 2A: CURRENT JOB, NOT self-employed for Defined Contribution ************;

replace pentypeDC2curr=0 if W3421==5|W3421==8; * NO and DK for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;
replace pentypeDC2curr=0 if (W3748==5|W3748==8); * NO and DK for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;
replace pentypeDC2curr=0 if W3710==7; *deny being covered by any pension plan;

** DC -- same job/pension plan as in wave 1 interview;
* for pension plan 1 - DC;
replace pentypeDC2curr=1 if W3712==2|W3712==3;  *DC or combo;
replace pentypeDC2curr=0 if W3712==1;  *DB;

* for pension plan 2 -DC;
replace pentypeDC2curr=1 if W3724==2|W3724==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W3724==1;

* for pension plan 3 -DC;
replace pentypeDC2curr=1 if W3736==2|W3736==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W3736==1;

** DC -- switched between wave1 and wave2;

* for pension plan 1 - DC;
replace pentypeDC2curr=1 if W3756==2|W3756==3;  *DC or combo;
replace pentypeDC2curr=0 if W3756==1;  *DB;

* for pension plan 2 -DC;
replace pentypeDC2curr=1 if W3808==2|W3808==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W3808==1;

* for pension plan 3 -DC;
replace pentypeDC2curr=1 if W3860==2|W3860==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W3860==1;

** DC -- not working and self-employed -- report only one plan, not three;

replace pentypeDC2curr=1 if W3422==2|W3422==3;  *DC or combo;
replace pentypeDC2curr=0 if W3422==1;  *DB;

replace pentypeDC2curr=1 if W3572==2|W3572==3;  *DC or combo;
replace pentypeDC2curr=0 if W3572==1;  *DB;

*not using proxy questions anymore;
*describing typeB plan -- thrift, 401K, annuity... and combinations of these imply DC plan;
*replace pentypeDC2curr=1 if (W3787>0 & W3787<11)|(W3839>0 & W3839<11)|(W3891>0 & W3891<11);
*replace pentypeDC2curr=1 if (W3787>11 & W3787<98)|(W3839>11 & W3839<98)|(W3891>11 & W3891<98);
*included in this plan for more than one year;
*replace pentypeDC2curr=1  if (W3788>0 & W3788<98)|(W3840>0 & W3840<98)|(W3892>0 & W3892<98);



************* part 2A: CURRENT JOB for DC, those who are self-employed ************;

******** part 1 *****************;
*previous employer before becoming self-employed;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & (W4272==5|W4272==8); *Were you included in a pension or retirement plan;

*current self-employment;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & (W4375==5|W4375==8); *are you included in emp. pension plan;

replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4376==7; * deny being covered by a pension plan;

*those who worked for a previous employer before becoming self-employed;
replace pentypeDC2curr=1 if W4273==2|W4273==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4273==1;

*self-empl, same job/plan--asked about up to three plans;
* for pension plan 1;
replace pentypeDC2curr=1 if W4378==2|W4378==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4378==1;

* for pension plan 2;
replace pentypeDC2curr=1 if W4390==2|W4390==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4390==1;

* for pension plan 3;
replace pentypeDC2curr=1 if W4402==2|W4402==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4402==1;

*switched empl. since wave1;
* for pension plan 1;
replace pentypeDC2curr=1 if W4415==2|W4415==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4415==1;

* for pension plan 2;
replace pentypeDC2curr=1 if W4467==2|W4467==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4467==1;

* for pension plan 3;
replace pentypeDC2curr=1 if W4519==2|W4519==3;
replace pentypeDC2curr=0 if pentypeDC2curr~=1 & W4519==1;

*describing typeB plan -- thrift, 401K, annuity... and combinations of these imply DC plan;
*replace pentypeDC2curr=1 if (W4446>0 & W4446<11)|(W4498>0 & W4498<11)|(W4550>0 & W4550<11);
*replace pentypeDC2curr=1 if (W4446>11 & W4446<98)|(W4498>11 & W4498<98)|(W4550>11 & W4550<98);
*included in this plan for more than one year;
*replace pentypeDC2curr=1  if (W4447>0 & W4447<98)|(W4499>0 & W4499<98)|(W4551>0 & W4551<98);


************* part 2B: RETIRED, LAST JOB ************;
replace pentypeDC2last=0 if W7032==5|W7032==8; * NO for ARE YOU INCLUDED IN ANY EMPLOYER PENSION PLAN;

replace pentypeDC2last=1 if W7033==2|W7033==3;
replace pentypeDC2last=0 if W7033==1;

******imputed last job pension plans, V2701 - working in wave1, W3300-3302 - retired in wave2***********;
replace pentypeDC2last=1 if V2701==1 & (W3300==5|W3301==5|W3302==5) & pentypeDC1curr==1;



************* part 2C: PREVIOUS TO LAST JOBS ************;
replace pentypeDC2prev=0 if (W7123==5 & W7160==5); * NO for are you included in any pen.plan for prev 2+jobs;

* W7160, W7200 -- any other employer with a pension plan , W7124 -- most recent employer ;
replace pentypeDC2prev=1 if W7160==2|W7160==3|W7200==2|W7200==3|W7124==2|W7124==3;
replace pentypeDC2prev=0 if (W7160==1 & W7200==1 & W7124==1);



*****************************************************************************************;
*****************************************************************************************;
* now get pension wealth;
* DB pension wealth--too nasty to compute to make things worthwhile, DC only;

***current job section, some vars are combo, some are DC plans;
replace W3451=0 if (W3451==.|W3451>9900000);  
replace W3572=0 if (W3572==.|W3572>9900000);
replace W3601=0 if (W3601==.|W3601>9900000);

replace W3723=0 if (W3723==.|W3723>9900000);  *current job -- 3 plans;
replace W3735=0 if (W3735==.|W3735>9900000);
replace W3747=0 if (W3747==.|W3747>9900000);

replace W3797=0 if (W3797==.|W3797>9900000);  *current job -- 3 plans;
replace W3849=0 if (W3849==.|W3849>9900000);
replace W3901=0 if (W3901==.|W3901>9900000);

***self-employed;
replace W4274=0 if (W4274==.|W4274>9900000);
replace W4306=0 if (W4306==.|W4306>9900000);
replace W4389=0 if (W4389==.|W4389>9900000);
replace W4456=0 if (W4456==.|W4456>9900000);

gen penwDC2curr=W3451+W3572+W3601+W3723+W3735+W3747+W3797+W3849+W3901+W4274+W4306+W4389+W4456;
replace penwDC2curr=0 if penwDC2curr==.;
replace penwDC2curr=0 if penwDC2curr==999998 | penwDC2curr==999999;
replace penwDC2curr=0 if penwDC2curr>1000000;

*last job, currently not working;

replace W7034=0 if (W7034==.|W7034>9900000); *COMBO PLAN - how much money was in acct when you left?;
replace W7062=0 if (W7062==.|W7062>9900000); *DC PLAN - how much money was in acct when you left?;
replace W7064=0 if (W7064==.|W7064>9900000); *DC PLAN - how much is in your acct NOW?;
replace W7064=0 if (W7063~=3); *still in DC plan => W7063==3, "left to accumulate";


gen penwDC2last=W7034+W7064;
replace penwDC2last=0 if penwDC2last==.;
* IMPORTANT: if the respondent reported last job's pen.wealth in wave1 only, we carry over their;
* wave1 wealth to waves2-...;
replace penwDC2last=penwDC1last if (penwDC2last==0 & penwDC1last~=.);

*******prev = combo most recent+DC most recent + combo other +DC other;

****most recent job;
replace W7125=0 if (W7125==.|W7125>9900000); *COMBO;
replace W7153=0 if (W7153==.|W7153>9900000); *DC;
replace W7155=0 if (W7155==.|W7155>9900000); *DC, how much in acct NOW;
replace W7155=0 if (W7154~=3); *still in DC plan => W7154==3, "left to accumulate";
****other job;
replace W7167=0 if (W7167==.|W7167>9900000); *COMBO;
replace W7190=0 if (W7190==.|W7190>9900000); *DC;
replace W7192=0 if (W7192==.|W7192>9900000); *DC, how much in acct NOW;
replace W7192=0 if (W7191~=3); *still in DC plan => W7191==3, "left to accumulate";

gen penwDC2prev=W7125+W7155+W7167+W7192;
replace penwDC2prev=0 if penwDC2prev==.;
replace penwDC2prev=penwDC1prev if (penwDC2prev==0 & penwDC1prev~=.);


gen penwDC2 = penwDC2curr + penwDC2last + penwDC2prev;


***************tenure******************;
replace W7002=0 if W7002==9998|W7002==9999;
replace W7018=0 if W7018==9998|W7018==9999;
gen tenurelast2=W7002-W7018 if W7002>W7018 & W7018~=0 ;  *year last worked - year started working;

replace W7108=0 if W7108==9998|W7108==9999;
replace W7103=0 if W7103==9998|W7103==9999;
gen tenureprev2= W7108-W7103 if W7108>W7103 & W7103~=0 ;



**************yearly earnings on last job****************;
gen earnlast2= W7012 if W7013==6; *how much earning, if salary is per year;
replace earnlast2=W7012*(W7011/4) if W7013==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast2=W7012*(W7011/2) if W7013==3; * salary is bi-weekly;
replace earnlast2=W7012*(W7011) if W7013==2; *salary is weekly;
replace earnlast2=(W7012*W7011*W7008) if W7013==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast2=. if W7012>9999996;
replace earnlast2=. if W7011>96;
replace earnlast2=. if W7008>96;

************* hourly wages******************;
gen wagelast2=earnlast2/(W7008*W7011); *earn/(hrs a week*weeks worked);



****************yearly earnings on prev job**************;
gen earnprev2= W7113 if W7114==6;
replace earnprev2=W7113*(W7112/4) if W7114==4;
replace earnprev2=W7113*(W7112/2) if W7114==3|W7114==5;
replace earnprev2=W7113*(W7112) if W7114==2;
replace earnprev2=(W7113*W7112*W7111) if W7114==1;


replace earnprev2=. if W7113>9999996;
replace earnprev2=. if W7112>96;
replace earnprev2=. if W7111>96;
************* hourly wages******************;
gen wageprev2=earnprev2/(W7111*W7112); *earn/(hrs a week*weeks worked);




********* What is the earliest age at which you could leave this employer and start to receive pension benefits? ******************************************;
*****************************************************************************;
*peneage - Age Pension Begins (APB);

****************** for those not self-employed ******;

* for pension plan 1;


gen peneage2=.;
replace peneage2=W3778 if W3778>0 & W3778<92;
replace peneage2=35 if W3778==95; * access pension benefits anytime;
replace peneage2=80 if W3778==93; * CAN'T LEAVE AT ALL. I re-coded it as age 80;
replace peneage2=35 if W3778==92; * CAN BEGIN PENSION BENEFITS AT CURRENT AGE;
replace peneage2=. if W3778==94; * FORMULA GIVEN case. We don't have formula, so I re-coded it as missing;
replace peneage2=. if W3778>95;


***** de-activate the following section *******************;

* replace peneage2=
* replace peneage2=35 if peneage2==95; * access pension benefits any time;
* replace peneage2=80 if peneage2==93; * only one such observation, "can't leave the employer at all", I re-coded it as age 80;
* replace peneage2=35 if peneage2==92; * only 3 such observations, "can begin pension benefits at current age". I re-coded it as age 35, same as "anytime the pension benefits can begin";
* replace peneage2=. if peneage2==94; * "formula given" for W3778. We have no information about the formula, so I re-coded it as missing;
* replace peneage2=. if peneage2==0|peneage2>95; * "no job" or "no pension" or "NA" or "DK";
*****************************************************************;


* for pension plan 2;
replace peneage2=W3830 if peneage2~=. & W3830>0 & W3830<92 & peneage2>W3830; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage2=W3830 if peneage2==. & W3830>0 & W3830<92;
replace peneage2=35 if W3830==92; * can access pension benefits at current age;
replace peneage2=80 if peneage2==. & W3830==93; * "can't leave the employer at all". I re-coded it as age 80, the highest age in this wave;
replace peneage2=. if peneage2==. & W3830==94;  * formula given;
replace peneage2=35 if W3830==95; * can access pension benefits anytime;
replace peneage2=. if peneage2==. & W3830>95;




* for pension plan 3;
replace peneage2=W3882 if peneage2~=. & W3882>0 & W3882<92 & peneage2>W3882; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace peneage2=W3882 if peneage2==. & W3882>0 & W3882<92;
replace peneage2=35 if W3882==92; * can access pension benefits at current age;
replace peneage2=80 if peneage2==. & W3882==93; * "can't leave the employer at all". I re-coded it as age 80, the highest age in this wave;
replace peneage2=. if peneage2==. & W3882==94;  * formula given;
replace peneage2=35 if W3882==95; * can access pension benefits anytime;
replace peneage2=. if peneage2==. & W3882>95;


*********** deactivate the following section of re-coding *********;

* for pension plan 3;
* replace peneage2=W3882 if peneage2~=. & peneage2>W3882 &  W3882~=0; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
* replace peneage2=80 if peneage2==. & W3882==93; * "can't leave the employer at all". I re-coded it as age 80, the highest age in this wave;
* replace peneage2=W3882 if peneage2==. & W3882~=93 & W3882~=94 & W3882~=0; * W3882==94, which means that "formula given", is excluded, since we don't have the formula; 
* replace peneage2=. if peneage2==. & peneage2>95;  * "DK", or "INAP", or "RF";  
* replace peneage2=35 if W3882==95; * access pension benefits anytime;
* replace peneage2=35 if W3882==92; * access pension benefits at current age. I re-code it as age 35;
**********************************************************************;


**************************** for those self-employed ************;
* for pension plan 1;
replace peneage2=W4437 if W4437>0 & W4437<92;
replace peneage2=35 if W4437==95; * access pension benefits anytime;
replace peneage2=80 if W4437==93; * CAN'T LEAVE AT ALL. I re-coded it as age 80;
replace peneage2=35 if W4437==92; * CAN BEGIN PENSION BENEFITS AT CURRENT AGE;
replace peneage2=. if W4437==94; * FORMULA GIVEN case. We don't have formula, so I re-coded it as missing;
replace peneage2=. if W4437>95;


* for pension plan 2;
replace peneage2=W4489 if peneage2~=. & W4489>0 & W4489<92 & peneage2>W4489; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage2=W4489 if peneage2==. & W4489>0 & W4489<92;
replace peneage2=35 if W4489==92; * can access pension benefits at current age;
replace peneage2=80 if peneage2==. & W4489==93; * "can't leave the employer at all". I re-coded it as age 80, the highest age in this wave;
replace peneage2=. if peneage2==. & W4489==94;  * formula given;
replace peneage2=35 if W4489==95; * can access pension benefits anytime;
replace peneage2=. if peneage2==. & W4489>95;



* for pension plan 3;
replace peneage2=W4541 if peneage2~=. & W4541>0 & W4541<92 & peneage2>W4541; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage2=W4541 if peneage2==. & W4541>0 & W4541<92;
replace peneage2=35 if W4541==92; * can access pension benefits at current age;
replace peneage2=80 if peneage2==. & W4541==93; * "can't leave the employer at all". I re-coded it as age 80, the highest age in this wave;
replace peneage2=. if peneage2==. & W4541==94;  * formula given;
replace peneage2=35 if W4541==95; * can access pension benefits anytime;
replace peneage2=. if peneage2==. & W4541>95;




**** the following re-coding is not logically thorough enough;
* gen peneage2=.;
* replace peneage2=W3778;
* replace peneage2=35 if W3778==92|W3778==95;
* replace peneage2=. if W3778==0|W3778==93|W3778==94|W3778>95;


********* the earliest age eligible for receiving full pension benefits *******************************************************************************; 
*******************************************************************************;

***************** for those not self-employed *********;

gen pennage2=.;


* for pension plan 1;
replace pennage2=W3770 if W3770>0 & W3770<92;
replace pennage2=35 if W3770==92; * can access pension benefits now;
replace pennage2=. if W3770==93; 
replace pennage2=. if W3770==94; 
replace pennage2=35 if W3770==95; * can access pension benefits anytime;
replace pennage2=. if W3770>95;


* for pension plan 2;
replace pennage2=W3822 if pennage2~=. & W3822>0 & W3822<92 & pennage2>W3822; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage2=W3822 if pennage2==. & W3830>0 & W3830<92;
replace pennage2=35 if W3822==92; * can access pension benefits at current age;
replace pennage2=. if pennage2==. & W3822==93; 
replace pennage2=. if pennage2==. & W3822==94;  * formula given;
replace pennage2=35 if W3822==95; * can access pension benefits anytime;
replace pennage2=. if pennage2==. & W3822>95;


* for pension plan 3;
replace pennage2=W3874 if pennage2~=. & W3874>0 & W3874<92 & pennage2>W3874; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace pennage2=W3874 if pennage2==. & W3874>0 & W3874<92;
replace pennage2=35 if W3874==92; * can access pension benefits at current age;
replace pennage2=. if pennage2==. & W3874==93; 
replace pennage2=. if pennage2==. & W3874==94;  * formula given;
replace pennage2=35 if W3874==95; * can access pension benefits anytime;
replace pennage2=. if pennage2==. & W3874>95;



************************* for those self-employed **********;

* for pension plan 1;
replace pennage2=W4429 if W4429>0 & W4429<92;
replace pennage2=35 if W4429==95; * access pension benefits anytime;
replace pennage2=80 if W4429==93; * CAN'T LEAVE AT ALL. I re-coded it as age 80;
replace pennage2=35 if W4429==92; * CAN BEGIN PENSION BENEFITS AT CURRENT AGE;
replace pennage2=. if W4429==94; * FORMULA GIVEN case. We don't have formula, so I re-coded it as missing;
replace pennage2=. if W4429>95;


* for pension plan 2;
replace pennage2=W4481 if pennage2~=. & W4481>0 & W4481<92 & pennage2>W4481; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage2=W4481 if pennage2==. & W4481>0 & W4481<92;
replace pennage2=35 if W4481==92; * can access pension benefits at current age;
replace pennage2=80 if pennage2==. & W4481==93; * "can't leave the employer at all". I re-coded it as age 80, the highest age in this wave;
replace pennage2=. if pennage2==. & W4481==94;  * formula given;
replace pennage2=35 if W4481==95; * can access pension benefits anytime;
replace pennage2=. if pennage2==. & W4481>95;



* for pension plan 3;
replace pennage2=W4533 if pennage2~=. & W4533>0 & W4533<92 & pennage2>W4533; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage2=W4533 if pennage2==. & W4533>0 & W4533<92;
replace pennage2=35 if W4533==92; * can access pension benefits at current age;
replace pennage2=80 if pennage2==. & W4533==93; * "can't leave the employer at all". I re-coded it as age 80, the highest age in this wave;
replace pennage2=. if pennage2==. & W4533==94;  * formula given;
replace pennage2=35 if W4533==95; * can access pension benefits anytime;
replace pennage2=. if pennage2==. & W4533>95;




****** de-activate the following section of re-coding;
* gen pennage2=W3770;
* replace pennage2=35 if pennage2==95;* access pension benefits anytime;
* replace pennage2=35 if pennage2==92; * access pension benefits at current age;
* replace pennage2=80 if pennage2==93; * can't leave the employer and begin pension benefits at all. I re-coded it as age 80, the highest age; 
* replace pennage2=. if pennage2==94; * "formula given". We don't have the formula, so I re-coded it as missing;
* replace pennage2=. if pennage2==0|pennage2>95; * "no job" or "no pension" or "NA" or "DK";

* for pension plan 2;
* replace pennage2=W3822 if pennage2~=. & pennage2>W3822 &  W3822~=0; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
* replace pennage2=80 if pennage2==. & W3822==93; * "can't leave the employer and begin pension benefits at all". I re-coded it as age 80, the highest age;
* replace pennage2=W3822 if pennage2==. & W3822~=93 & W3822~=94 & W3822~=0; * W3822==94, which means "formula given", is excluded, since we don't have information about the formula;
* replace pennage2=. if pennage2==. & pennage2>95; 
* replace pennage2=35 if W3822==95; * access pension benefits anytime;
* replace pennage2=35 if W3822==92; * access pension benefits at current age. I re-coded it as 35;

* for pension plan 3;
* replace pennage2=W3874 if pennage2~=. & pennage2>W3874 &  W3874~=0; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
* replace pennage2=80 if pennage2==. & W3874==93; * "can't leave the employer and begin pension benefits at all". I re-coded it as age 80, the highest age;
* replace pennage2=W3874 if pennage2==. & W3874~=93 & W3874~=94 & W3874~=0; * W3822==94, which means "formula given", is excluded, since we don't have information about the formula;
* replace pennage2=. if pennage2==. & pennage2>95; 
* replace pennage2=35 if W3874==95; * access pension benefits anytime;
* replace pennage2=35 if W3874==92; * access pension benefits at current age. I re-coded it as 35;
*****************************************************************;


* the following re-coding is not logically thorough enough;
* gen pennage2=.;
* replace pennage2=W3770;
* replace pennage2=35 if W3770==92|W3770==95;
* replace pennage2=. if W3770==0|W3770==93|W3770==94|W3770>95;
*******WHY WE DO NOT CONSIDER W3822 & W38574?????;


keep pen* peneage2 same_pen2 ten* HHID PN earn* wage*;
sort HHID PN; 
merge HHID PN using `saved'pension; 
drop _merge; 
replace pentypeDB2curr=pentypeDB1curr if same_pen2==1 & pentypeDB1curr~=.;
replace pentypeDC2curr=pentypeDC1curr if same_pen2==1 & pentypeDC1curr~=.;
replace peneage2=peneage1 if same_pen2==1 & peneage1~=.;
replace pennage2=pennage1 if same_pen2==1 & pennage1~=.;

gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN;
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 










*************** WAVE 3 ********************************************************;
*******************************************************************************;

clear;
*set mem 200m;
use `wave2d'w2fa;  ***to know whether or not a person worked in wave2***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave3d'temp, replace;
clear;

*set mem 200m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave2;
sort HHID PN; 
merge HHID PN using `wave3d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave3d'temp, replace;
clear;

*set mem 200m;
use `wave3d'H96G_R;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
merge HHID PN using `wave3d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave3d'temp, replace;


********* variable same3 *******************;

gen same_pen3=0;
replace same_pen3=1 if E2835==5|E2835==8; * No change from wave 2 or "DK" about the change. "DK" is interpreted as " No change";
tabulate same_pen3;



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB3curr=.;
gen pentypeDB3last=.;
gen pentypeDB3prev=.;

******************* 1A: current job--DB*************;
replace pentypeDB3curr=0  if E2627==5|E2627==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1B: retired, last job--DB*******;
replace pentypeDB3last=0  if E3125==5|E3125==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB3prev=0  if E3325==5|E3325==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DB plans on current job******;
replace pentypeDB3curr=0 if (E2680==5|E2680==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB3curr=0 if (E2861==5|E2861==8) &  pentypeDB3curr~=1 & pentypeDB3curr~=0; *those who change jobs from previous wave; 


*****has a wage sector job, but also self-employed;
replace pentypeDB3curr=1 if E2681==1|E2681==3; 
replace pentypeDB3curr=0 if E2681==2;



*****current job that's same as prev wave;
*  for plan 1;
replace pentypeDB3curr=1 if E2840_1==1|E2840_1==3;
replace pentypeDB3curr=0 if E2840_1==2; 

*  for plan 2;
replace pentypeDB3curr=1 if E2840_2==1|E2840_2==3;
replace pentypeDB3curr=0 if E2840_2==2; 

*  for plan 3;
replace pentypeDB3curr=1 if E2840_3==1|E2840_3==3;
replace pentypeDB3curr=0 if E2840_3==2; 



*****I think this is for people who changed employers b/w last two waves;
* for plan 1;
replace pentypeDB3curr=1 if E2875_1==1|E2875_1==3; 
replace pentypeDB3curr=0 if E2875_1==2 ;

* for plan 2;
replace pentypeDB3curr=1 if E2875_2==1|E2875_2==3; 
replace pentypeDB3curr=0 if E2875_2==2 ;

* for plan 3;
replace pentypeDB3curr=1 if E2875_3==1|E2875_3==3; 
replace pentypeDB3curr=0 if E2875_3==2 ;




*12/21/05 -- decided to omit proxy questions that help determine type of benefits;
*replace pentypeDB3=1 if (E2882_1~=. & E2882_1~=98 & E2882_1~=99)|(E2882_2~=. & E2882_2~=98 & E2882_2~=99)|(E2882_3~=. & E2882_3~=98 & E2882_3~=99);
*replace  pentypeDB3=1 if (E2883_1~=. & E2883_1<98)|(E2883_2~=. & E2883_2<98)|(E2883_3~=. & E2883_3<98);
*replace pentypeDB3=1 if (E2891_1~=. & E2891_1<8)|(E2891_2~=. & E2891_2<8)|(E2891_3~=. & E2891_3<8);
*replace pentypeDB3=1 if (E2897_1~=. & E2897_1~=7 & E2897_1<98)|(E2897_2~=. & E2897_2<98)|(E2897_3~=. & E2897_3<98); 
*replace pentypeDB3=1 if E2897_1==97; * OTHER, Li's suggestion: we can also re-code this case as 0 or missing;
***************  The following section of re-coding may not be good enough ****;
*********** part 3:
*  gen pentypeDB3=.;
* replace pentypeDB3=1 if E2875_1==1|E2875_1==3; * pension plan 1 is type A or both;
* replace pentypeDB3=1 if E2875_2==1|E2875_2==3; * pension plan 2 is type A or both;
* replace pentypeDB3=1 if E2875_3==1|E2875_3==3; * pension plan 3 is type A or both;
* for pension plan 1;
* replace pentypeDB3=0 if (E2875_1==2|E2875_1==0|E2875_1==.) & pentypeDB3~=1; * type B;
* replace pentypeDB3=0 if E2875_1==7 & pentypeDB3~=1; *  "other" types; * this may be invalid types, since there is no other legitimate type than A and B.;  
* for pension plan 2;
* replace pentypeDB3=0 if E2875_2==2 & pentypeDB3~=1; * type B;
* replace pentypeDB3=0 if E2875_2==7 & pentypeDB3~=1; *  "other" types; * this may be invalid types, since there is no legitimate type other than A and B;
* for pension plan 3;
* replace pentypeDB3=0 if E2875_3==2 & pentypeDB3~=1; * type B;
* replace pentypeDB3=0 if E2875_3==7 & pentypeDB3~=1; *  "other" types; * this may be invalid types, since there is no other legitimate type than A and B.;  
***************  The above section of re-coding may not be good enough ****;



******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB3last=0 if (E3154==5|E3154==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

* for plan 1;
replace pentypeDB3last=1 if E3155==1|E3155==3; 
replace pentypeDB3last=0 if E3155==2;

***imputed last job pension plans: W3300-3302 - wave2 working, E2611M1/M2/M3 - Wave 3 retired;
replace pentypeDB3last=1 if (W3300==1|W3301==1|W3302==1) & (E2611M1==5|E2611M2==5|E2611M3==5) & pentypeDB2curr==1;




******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB3prev=0 if (E3349==5|E3349==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

****plans for most recent and one other employer;
replace pentypeDB3prev=1 if E3350==1|E3350==3; 
replace pentypeDB3prev=0 if E3350==2;

replace pentypeDB3prev=1 if E3403==1|E3403==3; 
replace pentypeDB3prev=0 if E3403==2;





*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC3curr=.;
gen pentypeDC3last=.;
gen pentypeDC3prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC3curr=0  if E2627==5|E2627==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1B: retired, last job--DC*******;
replace pentypeDC3last=0  if E3125==5|E3125==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC3prev=0  if E3325==5|E3325==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
replace pentypeDC3curr=0 if (E2680==5|E2680==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC3curr=0 if (E2861==5|E2861==8) &  pentypeDC3curr~=1 & pentypeDC3curr~=0; *those who change jobs from previous wave; 


*****has a wage sector job, but also self-employed;
replace pentypeDC3curr=1 if E2681==2|E2681==3; 
replace pentypeDC3curr=0 if E2681==1;


*****current job that's same as prev wave;
*  for plan 1;
replace pentypeDC3curr=1 if E2840_1==2|E2840_1==3;
replace pentypeDC3curr=0 if E2840_1==1; 

*  for plan 2;
replace pentypeDC3curr=1 if E2840_2==2|E2840_2==3;
replace pentypeDC3curr=0 if E2840_2==1; 

*  for plan 3;
replace pentypeDC3curr=1 if E2840_3==2|E2840_3==3;
replace pentypeDC3curr=0 if E2840_3==1; 



*****I think this is for people who changed employers b/w last two waves;
* for plan 1;
replace pentypeDC3curr=1 if E2875_1==2|E2875_1==3; 
replace pentypeDC3curr=0 if E2875_1==1 ;

* for plan 2;
replace pentypeDC3curr=1 if E2875_2==2|E2875_2==3; 
replace pentypeDC3curr=0 if E2875_2==1 ;

* for plan 3;
replace pentypeDC3curr=1 if E2875_3==2|E2875_3==3; 
replace pentypeDC3curr=0 if E2875_3==1 ;



******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC3last=0 if (E3154==5|E3154==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

replace pentypeDC3last=1 if E3155==2|E3155==3; 
replace pentypeDC3last=0 if E3155==1;

***imputed last job pension plans: W3300-3302 - wave2 working, E2611M1/M2/M3 - Wave 3 retired;
replace pentypeDC3last=1 if (W3300==1|W3301==1|W3302==1) & (E2611M1==5|E2611M2==5|E2611M3==5) & pentypeDC2curr==1;



******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC3prev=0 if (E3349==5|E3349==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;
* for plan 1;
replace pentypeDC3prev=1 if E3350==2|E3350==3; 
replace pentypeDC3prev=0 if E3350==1;

* for plan 1;
replace pentypeDC3prev=1 if E3403==2|E3403==3; 
replace pentypeDC3prev=0 if E3403==1;


************************************************************************************;
****************************now calculate pension wealth;

*current;
replace E2682=0 if (E2682==.|E2682>9900000); *amount in acct when left;
replace E2714=0 if (E2714==.|E2714>9900000); 
replace E2856_1=0 if (E2856_1==.| E2856_1>9900000); *amount in accout presently;
replace E2856_2=0 if (E2856_2==.| E2856_2>9900000); 
replace E2856_3=0 if (E2856_3==.| E2856_3>9900000); 
replace E2942_1=0 if (E2942_1==.| E2942_1>9900000); 
replace E2942_2=0 if (E2942_2==.| E2942_2>9900000); 
replace E2942_3=0 if (E2942_3==.| E2942_3>9900000); 

gen penwDC3curr=E2682+E2714+E2856_1+E2856_2+E2856_3+E2942_1+E2942_2+E2942_3;
replace penwDC3curr=0 if penwDC3curr==.;
replace penwDC3curr=0 if penwDC3curr>2000000;

*last;
replace E3156=0 if (E3156==.| E3156 >9900000); *COMBO -amt in acct when left;
replace E3183=0 if (E3183==.| E3183>9900000); *DC - amnt in acct when left;
replace E3185=0 if (E3185==.| E3185>9900000); *DC, amount in acct NOW;
replace E3185=0 if E3184~=3; *still in the DC plan => E3184==3 (left to accumulate);
gen penwDC3last=E3156+E3185;
replace penwDC3last=0 if penwDC3last==.;
replace penwDC3last=penwDC2last if (penwDC3last==0 & penwDC2last~=.);

*prev;
*most recent job;
replace E3351=0 if (E3351==.| E3351>9900000); *COMBO - amnt in acct when left;
replace E3378=0 if (E3378==.| E3378>9900000); *DC - amnt in acct when left;
replace E3380=0 if (E3380==.| E3380>9900000); *DC, amount in acct NOW;
replace E3380=0 if E3379~=3; *still in the DC plan => E3379==3 (left to accumulate);
*other jobs;
replace E3404_1=0 if (E3404_1==.| E3404_1>9900000); *COMBO - amount in acct when left;
replace E3431_1=0 if (E3431_1==.| E3431_1>9900000); *DC - amount in acct when left;
replace E3433_1=0 if (E3433_1==.| E3433_1>9900000); *DC - amount in acct NOW;
replace E3433_1=0 if E3432_1~=3; *still in the DC plan => E3432_1==3 (left to accumulate);


gen penwDC3prev=E3351+E3380+E3404_1+E3433_1;
replace penwDC3prev=0 if penwDC3prev==.;
replace penwDC3prev=penwDC2prev if (penwDC3prev==0 & penwDC2prev~=.);

gen penwDC3=penwDC3curr+penwDC3last+penwDC3prev;



***************tenure******************;
replace E3128=0 if E3128==9998|E3128==9999;  *DK, RF;
replace E3146=0 if E3146==9998|E3146==9999;  *DK, RF;
gen tenurelast3=E3127-E3146 if E3127>E3146 & E3146~=0;  *year last worked - year started working;


replace E3337=0 if E3337==9998|E3337==9999;  *DK, RF;
replace E3329=0 if E3329==9998|E3329==9999;  *DK, RF;
gen tenureprev3= E3337-E3329 if E3337>E3329 & E3329~=0;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast3= E3139 if E3140==6; *how much earning, if salary is per year;
replace earnlast3=E3139*(E3138/4) if E3140==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast3=E3139*(E3138/2) if E3140==3|E3140==5; * salary is bi-weekly;
replace earnlast3=E3139*(E3138) if E3140==2; *salary is weekly;
replace earnlast3=(E3139*E3138*E3135) if E3140==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast3=. if E3139>9999996;
replace earnlast3=. if E3135>96;
replace earnlast3=. if E3138>96;


************* hourly wages******************;
gen wagelast3=earnlast3/(E3135*E3138); *earn/(hrs a week*weeks worked);


****************yearly earnings on prev job**************;
gen earnprev3= E3344 if E3345==6;
replace earnprev3=E3344*(E3343/4) if E3345==4;
replace earnprev3=E3344*(E3343/2) if E3345==3;
replace earnprev3=E3344*(E3343) if E3345==2;
replace earnprev3=(E3344*E3343*E3342) if E3345==1;


replace earnprev3=. if E3344>9999996;
replace earnprev3=. if E3343>96;
replace earnprev3=. if E3342>96;

************* hourly wages******************;
gen wageprev3=earnprev3/(E3342*E3343); *earn/(hrs a week*weeks worked);


******* What is the earliest age at which you could leave this employer and start to receive pension benefits? ******;

* for pension plan 1;
gen peneage3=E2913_1;
replace peneage3=35 if peneage3==95; * access pension benefits any time;
replace peneage3=. if peneage3>95; * "no job" or "no pension" or "NA" or "DK", or "other";
* replace peneage5=0 if E2913_1==97; * OTHER, Li's suggestion: which way to re-code this case is up to you;

* for pension plan 2;
replace peneage3=E2913_2 if peneage3~=. & peneage3>E2913_2 &  E2913_2~=.; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage3=E2913_2 if peneage3==.;
replace peneage3=. if peneage3>95; 
replace peneage3=35 if E2913_2==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage3=E2913_3 if peneage3~=. & peneage3>E2913_3 &  E2913_3~=.; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace peneage3=E2913_3 if peneage3==.;
replace peneage3=. if peneage3>95; 
replace peneage3=35 if E2913_3==95; * access pension benefits anytime;


**** the following re-coding may not be logically thorough enough;
* replace E2913_1=96 if E2913_1==.|E2913_1==0;
* replace E2913_2=96 if E2913_2==.|E2913_2==0;
* replace E2913_3=96 if E2913_3==.|E2913_3==0;
* gen peneage3=min(E2913_1,E2913_2,E2913_3);
* replace peneage3=30 if peneage3==95;
* replace peneage3=. if peneage3==0|peneage3>95;


************** age of normal pension benefits *********;


* for pension plan 1;
gen pennage3=E2897_1;
replace pennage3=35 if pennage3==95;* access pension benefits anytime;
replace pennage3=35 if pennage3==96; * "already eligible". I re-coded it is age 35, the same as access pension benefits anytime;
replace pennage3=. if pennage3>96; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage3=E2897_2 if pennage3~=. & pennage3>E2897_2 &  E2897_2~=.; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage3=E2897_2 if pennage3==.;
replace pennage3=. if pennage3>96; 
replace pennage3=35 if E2897_2==95; * access pension benefits anytime;
replace pennage3=35 if E2897_2==96; * "already eligible". I re-coded it is age 35, the same as access pension benefits anytime;

* for pension plan 3;
replace pennage3=E2897_3 if pennage3~=. & pennage3>E2897_3 &  E2897_3~=.; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace pennage3=E2897_3 if pennage3==.;
replace pennage3=. if pennage3>96; 
replace pennage3=35 if E2897_3==95; * access pension benefits anytime;
replace pennage3=35 if E2897_3==96; * "already eligible". I re-coded it is age 35, the same as access pension benefits anytime;

***** the following re-coding may not be logically thorough enough;
* replace E2897_1=96 if E2897_1==.| E2897_1==0;
* replace E2897_2=96 if E2897_2==.| E2897_2==0;
* replace E2897_3=96 if E2897_3==.| E2897_3==0;
* gen pennage3=min(E2897_1, E2897_2, E2897_3);
* replace pennage3=30 if pennage3==95;
* replace pennage3=. if pennage3==0|pennage3>95;


* Amount in this pension account now; 
*gen curpen3=Q2841A1;
*replace curpen3=0 if curpen3==.|curpen3==0;
*replace curpen3=. if curpen3>99999996; 

*Amount of Expected Pension; 
*gen exppen3=Q2846A1;
*replace exppen3=0 if Q2846A1==.|Q2846A1==0; 
*replace exppen3=. if Q2846A1>99999996;
*replace exppen3=exppen3*52 if Q2848A1==2;
*replace exppen3=exppen3*26 if Q2848A1==3;
*replace exppen3=exppen3*12 if Q2848A1==4;
*replace exppen3=exppen3*24 if Q2848A1==5;
*replace exppen3=exppen3*1 if Q2848A1==6;
*replace exppen3=. if Q2848A1==(98|99);

*lsamt3 - lump sum pension benefits/retirement settlement amount; 
*gen lsamt3=Q2850A2; 
*replace lsamt3=0 if Q2850A2==.|Q2850A2==0;
*replace lsamt3=. if Q2850A2>99999996; 




******************************************************************;
****** WORKERS WHO HAVE NOT ALWAYS BEEN COVERED BY SS*************;
gen SScov3=0;
replace SScov3=E3102 if (E3102==1|E3102==5); 
replace E3103=. if E3103>1998;
replace E3104=. if E3104>1998;
replace E3105=. if E3105>90; 

* years in job not covered by SS;


gen SSYears3=0;
replace SSYears3=. if SScov3==1; * worked in a job not covered by SS;
replace SSYears3=E3105 if E3105~=.;
replace E3091=. if (E3091<1920|E3091>1996); * first year of work;
sum SSYears3;
replace SSYears3=1996-E3091 if (E3091~=. & E3106==2);
sum SSYears3;
sum E3103 E3104 if SSYears3==.;
gen time3 = E3104-E3103;
replace SSYears3=time3 if SSYears3==. |time3~=.;
sum SSYears3;

gen SSEnd3=E3104;
replace SSEnd3=1996 if E3106==2;



keep peneage3 pen* pennage3 same_pen3 ten* SS* HHID PN earn* wage*; 
sort HHID PN; 
merge HHID PN using `saved'pension; 
drop _merge; 


***************************************************;
* use local govt as a proxy for lack of SS coverage;
tab SScov3 Govt1; * 1 = > yes, anything else =>no;


replace SScov3=1 if (SScov3==0|SScov3==.) & Govt1==1;
sort SScov3;
by SScov3: sum SSYears3 SScov3;
replace SSYears3=GovtYears1 if SScov3==1 & (SSYears3==.|SSYears3==0) & GovtYears1~=.; 
sort SScov3;
by SScov3: sum SSYears3 SScov3;
replace SSEnd3=GovtEnd1 if SScov3==1 & Govt1==1 & SSEnd3==.;


summ pentypeDB3* pentypeDC3* peneage3 pennage3;

sort pentypeDB3curr;
by pentypeDB3curr: summ pennage3 peneage3 pentypeDB3curr;

replace pentypeDB3curr=pentypeDB2curr if same_pen3==1 & pentypeDB2curr~=.;
replace pentypeDC3curr=pentypeDC2curr if same_pen3==1 & pentypeDC2curr~=.;
*replace peneage3=peneage2 if same_pen3==1 & peneage2~=.;
*replace pennage3=pennage2 if same_pen3==1 & pennage2~=.;
summ pentypeDB3* pentypeDC3* peneage3* pennage3*;

sort pentypeDB3curr;
by pentypeDB3curr: summ pennage3 peneage3 pentypeDB3curr;

sort HHID PN;
summ;
sleep 1000;  save `saved'pension, replace;
drop _all;   





# delimit ;
***************************************************************************************************************;
************************************************* WAVE 4 ******************************************************;
clear;
*set mem 200m;
use `wave3d'H96G_R;***to know whether or not a person worked in wave3***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave4d'temp, replace;
clear;

*set mem 200m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave3;
sort HHID PN; 
merge HHID PN using `wave4d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave4d'temp, replace;
clear;

use `wave4d'H98g_r;
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave4d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave4d'temp, replace;


gen same_pen4=0;
replace same_pen4=1 if F3359==5|F3359==8; * no change. F3359==8 is "DK", which is interpreted as "no change" noticed ;
tabulate same_pen4;


*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB4curr=.;
gen pentypeDB4last=.;
gen pentypeDB4prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB4curr=0  if F3131==5|F3131==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDB4curr=0 if F3359==7; * deny being covered by a pension;

******************* 1B: retired, last job--DB*******;
replace pentypeDB4last=0  if F3643==5|F3643==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB4prev=0  if F3830==5|F3830==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
replace pentypeDB4curr=0 if (F3202==5|F3202==8);  *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB4curr=0 if (F3389==5|F3389==8) &  pentypeDB4curr~=1 & pentypeDB4curr~=0; *those who change jobs from previous wave; 

****can't figure out who these people are, this var was not in original code;
***looks like it's people who stopped working for prev.wave employer, should they be in Last/Prev?;
replace pentypeDB4curr=1 if F3203==1|F3203==3; 
replace pentypeDB4curr=0 if F3203==2;



*****current job that's same as prev wave;
*  for plan 1;
replace pentypeDB4curr=1 if F3364_1==1|F3364_1==3;
replace pentypeDB4curr=0 if F3364_1==2; 

*  for plan 2;
replace pentypeDB4curr=1 if F3364_2==1|F3364_2==3;
replace pentypeDB4curr=0 if F3364_2==2; 

*  for plan 3;
replace pentypeDB4curr=1 if F3364_3==1|F3364_3==3;
replace pentypeDB4curr=0 if F3364_3==2; 



*****I think this is for people who changed employers b/w last two waves;
* for plan 1;
replace pentypeDB4curr=1 if F3403_1==1|F3403_1==3; 
replace pentypeDB4curr=0 if F3403_1==2 ;

* for plan 2;
replace pentypeDB4curr=1 if F3403_2==1|F3403_2==3; 
replace pentypeDB4curr=0 if F3403_2==2 ;

* for plan 3;
replace pentypeDB4curr=1 if F3403_3==1|F3403_3==3; 
replace pentypeDB4curr=0 if F3403_3==2 ;


******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB4last=0 if (F3672==5|F3672==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

* for plan 1;
replace pentypeDB4last=1 if F3674==1|F3674==3; 
replace pentypeDB4last=0 if F3674==2;

***imputed last job pension plans: E2611M1/2/3- wave3 working, F3115M1/2/3 - Wave 4 retired;
replace pentypeDB4last=1 if (E2611M1==1|E2611M2==1|E2611M3==1) & (F3115M1==5|F3115M2==5|F3115M3==5) & pentypeDB3curr==1;


******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB4prev=0 if (F3854==5|F3854==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB4prev=0 if (F3899==5|F3899==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

replace pentypeDB4prev=1 if F3855==1|F3855==3; 
replace pentypeDB4prev=0 if F3855==2;

*plan1;
replace pentypeDB4prev=1 if F3908_1==1|F3908_1==3; 
replace pentypeDB4prev=0 if F3908_1==2;
*plan2;
replace pentypeDB4prev=1 if F3908_2==1|F3908_2==3; 
replace pentypeDB4prev=0 if F3908_2==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC4curr=.;
gen pentypeDC4last=.;
gen pentypeDC4prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC4curr=0  if F3131==5|F3131==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDC4curr=0 if F3359==7; * deny being covered by a pension;

******************* 1B: retired, last job--DC*******;
replace pentypeDC4last=0  if F3643==5|F3643==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC4prev=0  if F3830==5|F3830==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
replace pentypeDC4curr=0 if (F3202==5|F3202==8);  *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC4curr=0 if (F3389==5|F3389==8) &  pentypeDB4curr~=1 & pentypeDB4curr~=0; *those who change jobs from previous wave; 

****can't figure out who these people are, this var was not in original code;
***looks like it's people who stopped working for prev.wave employer;
replace pentypeDC4curr=1 if F3203==2|F3203==3; 
replace pentypeDC4curr=0 if F3203==1;


*****current job that's same as prev wave;
*  for plan 1;
replace pentypeDC4curr=1 if F3364_1==2|F3364_1==3;
replace pentypeDC4curr=0 if F3364_1==1; 

*  for plan 2;
replace pentypeDC4curr=1 if F3364_2==2|F3364_2==3;
replace pentypeDC4curr=0 if F3364_2==1; 

*  for plan 3;
replace pentypeDC4curr=1 if F3364_3==2|F3364_3==3;
replace pentypeDC4curr=0 if F3364_3==1; 


*****I think this is for people who changed employers b/w last two waves;
* for plan 1;
replace pentypeDC4curr=1 if F3403_1==2|F3403_1==3; 
replace pentypeDC4curr=0 if F3403_1==1 ;

* for plan 2;
replace pentypeDC4curr=1 if F3403_2==2|F3403_2==3; 
replace pentypeDC4curr=0 if F3403_2==1 ;

* for plan 3;
replace pentypeDC4curr=1 if F3403_3==2|F3403_3==3; 
replace pentypeDC4curr=0 if F3403_3==1 ;


******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC4last=0 if (F3672==5|F3672==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

replace pentypeDC4last=1 if F3674==2|F3674==3; 
replace pentypeDC4last=0 if F3674==1;


***imputed last job pension plans: E2611M1/2/3- wave3 working, F3115M1/2/3 - Wave 4 retired;
replace pentypeDC4last=1 if (E2611M1==1|E2611M2==1|E2611M3==1) & (F3115M1==5|F3115M2==5|F3115M3==5) & pentypeDC3curr==1;



******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC4prev=0 if (F3854==5|F3854==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC4prev=0 if (F3899==5|F3899==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

replace pentypeDC4prev=1 if F3855==2|F3855==3; 
replace pentypeDC4prev=0 if F3855==1;

*plan1;
replace pentypeDC4prev=1 if F3908_1==2|F3908_1==3; 
replace pentypeDC4prev=0 if F3908_1==1;
*plan2;
replace pentypeDC4prev=1 if F3908_2==2|F3908_2==3; 
replace pentypeDC4prev=0 if F3908_2==1;




************************************************************************************;
****************************now calculate pension wealth;

*current;
replace F3236=0 if (F3236==.|F3236>9900000); *amnt in acct when left employer;

replace F3365_1=0 if (F3365_1==.|F3365_1>9900000); *amount in accout presently;
replace F3365_2=0 if (F3365_2==.|F3365_2>9900000); 
replace F3365_3=0 if (F3365_3==.|F3365_3>9900000); 

replace F3383_1=0 if (F3383_1==.| F3383_1>9900000); *amount in account presently;
replace F3383_2=0 if (F3383_2==.| F3383_2>9900000); 
replace F3383_3=0 if (F3383_3==.| F3383_3>9900000); 

replace F3404_1=0 if (F3404_1==.| F3404_1>9900000); *amount in account presently;
replace F3404_2=0 if (F3404_2==.| F3404_2>9900000); 
replace F3404_3=0 if (F3404_3==.| F3404_3>9900000); 

replace F3470_1=0 if (F3470_1==.| F3470_1>9900000); *amount in account presently;
replace F3470_2=0 if (F3470_2==.| F3470_2>9900000); 
replace F3470_3=0 if (F3470_3==.| F3470_3>9900000); 

gen penwDC4curr=F3236+F3365_1+F3365_2+F3365_3+F3383_1+F3383_2+F3383_3+F3404_1+F3404_2+F3404_3+F3470_1+F3470_2+F3470_3;
replace penwDC4curr=0 if penwDC4curr==.;



/************Note, in wave 4, in addition to existing questions about disposition of DC plans, 
************ HRS also began reporting the amount in acct NOW and disposition of COMBO plans*******/

****************last;
replace F3677=0 if (F3677==.| F3677>9900000); *COMBO - amt in acct NOW;
replace F3677=0 if F3676~=3; * still in COMBO plan ==> F3676==3;

replace F3703=0 if (F3703==.| F3703>9900000); *DC - amt in acct NOW;
replace F3703=0 if F3702~=3; *DC - still in DC plan ==> F3702~=3;

gen penwDC4last=F3677+F3703;
replace penwDC4last=0 if penwDC4last==.;


replace penwDC4last=penwDC3last if (penwDC4last==0 & penwDC3last~=.);



***************prev job;

***most recent job;
replace F3858=0 if (F3858==.| F3858>9900000); *COMBO - amount in plan NOW;
replace F3858=0 if F3857~=3; * still in COMBO plan ==> F3857==3;
replace F3885=0 if (F3885==.| F3885>9900000); *DC - amt in plan NOW;
replace F3885=0 if F3884~=3; * still in COMBO plan ==> F3884==3;

***other jobs;
* COMBO -- up to two responses were allowed to this question;
replace F3911_1=0 if (F3911_1==.| F3911_1>9900000); *amount in accout NOW;
replace F3911_1=0 if F3910_1~=3; 
replace F3911_2=0 if (F3911_2==.| F3911_2>9900000); *amount in accout NOW;
replace F3911_2=0 if F3910_2~=3; 

* DC -- up to two responses were allowed to this question;
replace F3938_1=0 if (F3938_1==.| F3938_1>9900000); *amount in accout NOW;
replace F3938_1=0 if F3937_1~=3; 
replace F3938_2=0 if (F3938_2==.| F3938_2>9900000); *amount in accout NOW;
replace F3938_2=0 if F3937_2~=3; 

gen penwDC4prev=F3858+F3885+F3911_1+F3911_2+F3938_1+F3938_2;
replace penwDC4prev=0 if penwDC4prev==.;
replace penwDC4prev=penwDC3prev if (penwDC4prev==0 & penwDC3prev~=.);


gen penwDC4=penwDC4curr+penwDC4last+penwDC4prev;



***************tenure******************;
replace F3644=0 if F3644==9998|F3644==9999;  *DK, RF;
replace F3664=0 if F3664==9998|F3664==9999;  *DK, RF;
gen tenurelast4=F3644-F3664 if F3644>F3664 & F3664~=0;  *year last worked - year started working;


replace F3834=0 if F3834==9998|F3834==9999;  *DK, RF;
replace F3842=0 if F3842==9998|F3842==9999;  *DK, RF;
gen tenureprev4=F3842-F3834 if F3842>F3834 & F3834~=0;  *year last worked - year started working;




**************yearly earnings on last job****************;
gen earnlast4= F3657 if F3658==6; *how much earning, if salary is per year;
replace earnlast4=F3657*(F3656/4) if F3658==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast4=F3657*(F3656/2) if F3658==3|F3658==5; * salary is bi-weekly;
replace earnlast4=F3657*(F3656) if F3658==2; *salary is weekly;
replace earnlast4=F3657*7 if F3658==11;
replace earnlast4=(F3657*F3656*F3653) if F3658==1; *earn*weeks worked*hrs a week if hourly;

replace earnlast4=. if F3653>997;
replace earnlast4=. if F3656>97;
replace earnlast4=. if F3657>9999997;
************* hourly wages******************;
gen wagelast4=earnlast4/(F3653*F3656); *earn/(hrs a week*weeks worked);


****************yearly earnings on prev job**************;
gen earnprev4= F3849 if F3850==6;
replace earnprev4=F3849*(F3848/4) if F3850==4;
replace earnprev4=F3849*(F3848/2) if F3850==3;
replace earnprev4=F3849*(F3848) if F3850==2;
replace earnprev4=F3849*7 if F3850==11;
replace earnprev4=(F3849*F3848*F3847) if F3850==1;

replace earnprev4=. if F3849>9999997;
replace earnprev4=. if F3848>97;
replace earnprev4=. if F3847>997;
************* hourly wages******************;
gen wageprev4=earnprev4/(F3847*F3848); *earn/(hrs a week*weeks worked);



***************** earliest age to still receive benefits *****************;

* for pension plan 1;
gen peneage4=F3441_1;
replace peneage4=35 if peneage4==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
replace peneage4=. if peneage4>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage4=F3441_2 if peneage4~=. & peneage4>F3441_2 &  F3441_2~=.; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage4=F3441_2 if peneage4==.;
replace peneage4=. if peneage4>95; 
replace peneage4=35 if F3441_2==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage4=F3441_3 if peneage4~=. & peneage4>F3441_3 &  F3441_3~=.; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace peneage4=F3441_3 if peneage4==.;
replace peneage4=. if peneage4>95; 
replace peneage4=35 if F3441_3==95; * access pension benefits anytime;

***** the following re-coding may not be logically thorough enough;
* replace Q3441_1=96 if Q3441_1==.| Q3441_1==0;
* replace Q3441_2=96 if Q3441_2==.| Q3441_2==0;
* replace Q3441_3=96 if Q3441_3==.| Q3441_3==0;

* gen peneage4=min(Q3441_1, Q3441_2, Q3441_3);
* replace peneage4=30 if peneage4==95;
* replace peneage4=. if peneage4==0|peneage4>95;

************************** age to receive full benefits ****************;

* for pension plan 1;
gen pennage4=F3425_1;
replace pennage4=35 if pennage4==95;* access pension benefits anytime;
replace pennage4=. if pennage4>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage4=F3425_2 if pennage4~=. & pennage4>F3425_2 &  F3425_2~=.; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage4=F3425_2 if pennage4==.;
replace pennage4=. if pennage4>95; 
replace pennage4=35 if F3425_2==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage4=F3425_3 if pennage4~=. & pennage4>F3425_3 &  F3425_3~=.; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace pennage4=F3425_3 if pennage4==.;
replace pennage4=. if pennage4>95; 
replace pennage4=35 if F3425_3==95; * access pension benefits anytime;

**** the following re-coding may not be logically thorough enough;
* replace Q3425_1=96 if Q3425_1==.| Q3425_1==0;
* replace Q3425_2=96 if Q3425_2==.| Q3425_2==0;
* replace Q3425_3=96 if Q3425_3==.| Q3425_3==0;
* gen pennage4=min(Q3425_1, Q3425_2, Q3425_3);
* replace pennage4=30 if pennage4==95;
* replace pennage4=. if pennage4==0|pennage4>95;

******************************************************************;
******GOVT WORKERS************************************************;

replace F3988=. if F3988>2000;
replace F3989=. if F3989>2000;
replace F3990=. if F3990>2000;
replace F3991=. if F3991>2000;

gen Govt4=0;
replace Govt4=F3987 if (F3987==1|F3987==5);
tab F3987;
tab Govt4;
gen GovtYears4=0;
* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin4=F3988;
replace GovtBegin4=1978 if F3988==. & Govt4==1;
gen GovtEnd4=F3989 ;
replace GovtEnd4=1998 if F3989==. & Govt4==1;
replace GovtYears4=GovtEnd4-GovtBegin4;
gen ExYears4=F3991-F3990; *2nd spell for the govt;
replace GovtYears4=GovtYears4+(ExYears4) if (ExYears4>0 & ExYears4~=.);
replace GovtEnd4=F3991 if F3991~=.;
replace GovtYears4=1 if GovtYears4<1 & GovtYears4~=.;
sort Govt4;
by Govt4: sum Govt* Ex*;

*Jobs covered by SS?;

gen SScov4=0;
replace SScov4=F3997 if (F3997==1|F3997==5); 
replace F3998=. if F3998>2000;
replace F3999=. if F3999>2000;
replace F4000=. if F4000>2000;
replace F4001=. if F4001>2000;

* years in job not covered by SS;

gen SSYears4=0;
gen SSBegin4=F3998;
replace SSBegin4=1978 if F3998==. & SScov4==1;
gen SSEnd4=F3999 ;
replace SSEnd4=1998 if F3999==. & SScov4==1;
replace SSYears4=SSEnd4-SSBegin4;
gen ExSSYears4=F4001-F4000; 
replace SSYears4=SSYears4+(ExSSYears4) if (ExSSYears4>0 & ExSSYears4~=.);
replace SSEnd4=F4001 if F4001~=.;
replace SSYears4=1 if SSYears4<1 & SSYears4~=.;
sort SScov4;
by SScov4: sum SS* Ex*;

*proxy w/ GovtYears

replace SScov4=1 if (SScov4==0|SScov4==.) & Govt4==1;
sort SScov4;
by SScov4: sum SSYears4 SScov4;
replace SSYears4=GovtYears4 if SScov4==1 & (SSYears4==.|SSYears4==0) & GovtYears4~=.; 
sort SScov4;
by SScov4: sum SSYears4 SScov4;
replace SSEnd4=GovtEnd4 if SScov4==1 & Govt4==1 & SSEnd4==.;


keep pen* peneage4 pennage4 same_pen4 ten* HHID PN earn* wage* SS* Govt*;
sort HHID PN;
merge HHID PN using `saved'pension; 
drop _merge; 

summ pentypeDB4* pentypeDC4* peneage4 pennage4;
sort pentypeDB4curr;
by pentypeDB4curr: summ pennage4 peneage4 pentypeDB4curr;


replace pentypeDB4curr=pentypeDB3curr if same_pen4==1 & pentypeDB3curr~=.;
replace pentypeDC4curr=pentypeDC3curr if same_pen4==1 & pentypeDC3curr~=.;
replace peneage4=peneage3 if same_pen4==1 & peneage3~=.;
replace pennage4=pennage3 if same_pen4==1 & pennage3~=.;
summ pentypeDB4curr pentypeDC4curr peneage4 pennage4;
sort pentypeDB4curr;
by pentypeDB4curr: summ pennage4 peneage4 pentypeDB4curr;

sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 








*************************************************************************************;
************************************************************* WAVE 5   **************;


*************** NOTE, THE VARIABLES HAVE ALL BEEN CHANGED TO G..., BUT WE ARE USING THE OLD VERSION WITH Q...;




clear;
*set mem 200m;
use `wave4d'H98g_r;***to know whether or not a person worked in wave4***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  sleep 1000;  save `wave5d'temp, replace;
clear;

*set mem 200m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave4;
sort HHID PN; 
merge HHID PN using `wave5d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  sleep 1000;  save `wave5d'temp, replace;
clear;


*set mem 200m;
use `wave5d'H00G_R; *This used to be H00_g; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave5d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  sleep 1000;  save `wave5d'temp, replace;

*Jon: The following sections are commented out because H00_g, H00_gg and H00_gh were all combined into one dataset in the updated HRS data. ;
*clear;
**set mem 200m;
*use `wave5d'H00_gg;
*gen temp=real(HHID); 
*drop HHID;
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
*sort HHID PN;
*merge HHID PN using `wave5d'temp;
*drop _merge;
*sort HHID PN; 
*sleep 1000;  sleep 1000;  save `wave5d'temp, replace;

*clear;
**set mem 200m;
*use `wave5d'H00_gh;
*gen temp=real(HHID); 
*drop HHID;
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
*sort HHID PN;
*merge HHID PN using `wave5d'temp;
*drop _merge;
*sort HHID PN; 
*sleep 1000;  sleep 1000;  save `wave5d'temp, replace;


*********** variable same5 ***********;

*Jon: I change the variable prefix from G to Q for efficiency;
renpfix G Q;
gen same_pen5=0;
replace same_pen5=1 if Q3619==5|Q3619==8; * No changes from the last way. * Q3619==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen5;



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB5curr=.;
gen pentypeDB5last=.;
gen pentypeDB5prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB5curr=0  if Q3381==5|Q3381==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDB5curr=0 if Q3619==7; * deny being covered by a pension;

******************* 1B: retired, last job--DB*******;
replace pentypeDB5last=0  if Q3953==5|Q3953==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB5prev=0  if Q4092==5|Q4092==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB5curr=0 if (Q3654==5|Q3654==8);  *those who change jobs from previous wave,;
replace pentypeDB5curr=0 if (Q3452==5|Q3452==8); *same job as last wave;



*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDB5curr=1 if Q3455_1==1|Q3455_1==3;
replace pentypeDB5curr=0 if Q3455_1==2; 

*  for plan 2;
replace pentypeDB5curr=1 if Q3455_2==1|Q3455_2==3;
replace pentypeDB5curr=0 if Q3455_2==2; 

*  for plan 3;
replace pentypeDB5curr=1 if Q3455_3==1|Q3455_3==3;
replace pentypeDB5curr=0 if Q3455_3==2;

*  for plan 4;
replace pentypeDB5curr=1 if Q3455_4==1|Q3455_4==3;
replace pentypeDB5curr=0 if Q3455_4==2;


****those who did not change jobs from prev. wave;
*  for plan 1;
replace pentypeDB5curr=1 if Q3624_1==1|Q3624_1==3;
replace pentypeDB5curr=0 if Q3624_1==2; 

*  for plan 2;
replace pentypeDB5curr=1 if Q3624_2==1|Q3624_2==3;
replace pentypeDB5curr=0 if Q3624_2==2; 

*  for plan 3;
replace pentypeDB5curr=1 if Q3624_3==1|Q3624_3==3;
replace pentypeDB5curr=0 if Q3624_3==2; 

*  for plan 4;
replace pentypeDB5curr=1 if Q3624_4==1|Q3624_4==3;
replace pentypeDB5curr=0 if Q3624_4==2;



*****this is for people who changed employers b/w last two waves;
replace pentypeDB5curr=1 if Q3670==1|Q3670==3; 
replace pentypeDB5curr=0 if Q3670==2;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDB5curr=1 if Q3683_1==1|Q3683_1==3;
replace pentypeDB5curr=0 if Q3683_1==2; 

*  for plan 2;
replace pentypeDB5curr=1 if Q3683_2==1|Q3683_2==3;
replace pentypeDB5curr=0 if Q3683_2==2; 

*  for plan 3;
replace pentypeDB5curr=1 if Q3683_3==1|Q3683_3==3;
replace pentypeDB5curr=0 if Q3683_3==2; 

*  for plan 4;
replace pentypeDB5curr=1 if Q3683_4==1|Q3683_4==3;
replace pentypeDB5curr=0 if Q3683_4==2;




******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB5last=0 if (Q3990==5|Q3990==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB5last=1 if Q3994_1==1|Q3994_1==3; 
replace pentypeDB5last=0 if Q3994_1==2;

*  for plan 2;
replace pentypeDB5last=1 if Q3994_2==1|Q3994_2==3; 
replace pentypeDB5last=0 if Q3994_2==2;

*  for plan 3;
replace pentypeDB5last=1 if Q3994_3==1|Q3994_3==3; 
replace pentypeDB5last=0 if Q3994_3==2;


***imputed last job pension plans: F3115M1/2/3- wave4 working, Q3365M1/2/3 - Wave 5 retired;
replace pentypeDB5last=1 if (F3115M1==1|F3115M2==1|F3115M3==1) & (Q3365M1==5|Q3365M2==5|Q3365M3==5) & pentypeDB4curr==1;



******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB5prev=0 if (Q4116==5|Q4116==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB5prev=0 if (Q4172==5|Q4172==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB5prev=1 if Q4120_1==1|Q4120_1==3; 
replace pentypeDB5prev=0 if Q4120_1==2;

* plan 2;
replace pentypeDB5prev=1 if Q4120_2==1|Q4120_2==3; 
replace pentypeDB5prev=0 if Q4120_2==2;



*plan1;
replace pentypeDB5prev=1 if Q4181_1==1|Q4181_1==3; 
replace pentypeDB5prev=0 if Q4181_1==2;

*plan2;
replace pentypeDB5prev=1 if Q4181_2==1|Q4181_2==3; 
replace pentypeDB5prev=0 if Q4181_2==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC5curr=.;
gen pentypeDC5last=.;
gen pentypeDC5prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC5curr=0  if Q3381==5|Q3381==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDC5curr=0 if Q3619==7; * deny being covered by a pension;

******************* 1B: retired, last job--DC*******;
replace pentypeDC5last=0  if Q3953==5|Q3953==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC5prev=0  if Q4092==5|Q4092==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC5curr=0 if (Q3654==5|Q3654==8);  *those who change jobs from previous wave; 
replace pentypeDC5curr=0 if (Q3452==5|Q3452==8); 


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDC5curr=1 if Q3455_1==2|Q3455_1==3;
replace pentypeDC5curr=0 if Q3455_1==1; 

*  for plan 2;
replace pentypeDC5curr=1 if Q3455_2==2|Q3455_2==3;
replace pentypeDC5curr=0 if Q3455_2==1; 

*  for plan 3;
replace pentypeDC5curr=1 if Q3455_3==2|Q3455_3==3;
replace pentypeDC5curr=0 if Q3455_3==1;

*  for plan 4;
replace pentypeDC5curr=1 if Q3455_4==2|Q3455_4==3;
replace pentypeDC5curr=0 if Q3455_4==1;


****those who did not change jobs from prev. wave;
*  for plan 1;
replace pentypeDC5curr=1 if Q3624_1==2|Q3624_1==3;
replace pentypeDC5curr=0 if Q3624_1==1; 

*  for plan 2;
replace pentypeDC5curr=1 if Q3624_2==2|Q3624_2==3;
replace pentypeDC5curr=0 if Q3624_2==1; 

*  for plan 3;
replace pentypeDC5curr=1 if Q3624_3==2|Q3624_3==3;
replace pentypeDC5curr=0 if Q3624_3==1; 

*  for plan 4;
replace pentypeDC5curr=1 if Q3624_4==2|Q3624_4==3;
replace pentypeDC5curr=0 if Q3624_4==1;



*****this is for people who changed employers b/w last two waves;
replace pentypeDC5curr=1 if Q3670==2|Q3670==3; 
replace pentypeDC5curr=0 if Q3670==1;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDC5curr=1 if Q3683_1==2|Q3683_1==3;
replace pentypeDC5curr=0 if Q3683_1==1; 

*  for plan 2;
replace pentypeDC5curr=1 if Q3683_2==2|Q3683_2==3;
replace pentypeDC5curr=0 if Q3683_2==1; 

*  for plan 3;
replace pentypeDC5curr=1 if Q3683_3==2|Q3683_3==3;
replace pentypeDC5curr=0 if Q3683_3==1; 

*  for plan 4;
replace pentypeDC5curr=1 if Q3683_4==2|Q3683_4==3;
replace pentypeDC5curr=0 if Q3683_4==1;




******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC5last=0 if (Q3990==5|Q3990==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC5last=1 if Q3994_1==2|Q3994_1==3; 
replace pentypeDC5last=0 if Q3994_1==1;

*  for plan 2;
replace pentypeDC5last=1 if Q3994_2==2|Q3994_2==3; 
replace pentypeDC5last=0 if Q3994_2==1;

*  for plan 3;
replace pentypeDC5last=1 if Q3994_3==2|Q3994_3==3; 
replace pentypeDC5last=0 if Q3994_3==1;



***imputed last job pension plans: F3115M1/2/3- wave4 working, Q3365M1/2/3 - Wave 5 retired;
replace pentypeDC5last=1 if (F3115M1==1|F3115M2==1|F3115M3==1) & (Q3365M1==5|Q3365M2==5|Q3365M3==5) & pentypeDC4curr==1;





******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC5prev=0 if (Q4116==5|Q4116==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC5prev=0 if (Q4172==5|Q4172==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC5prev=1 if Q4120_1==2|Q4120_1==3; 
replace pentypeDC5prev=0 if Q4120_1==1;

* plan 2;
replace pentypeDC5prev=1 if Q4120_2==2|Q4120_2==3; 
replace pentypeDC5prev=0 if Q4120_2==1;



*plan1;
replace pentypeDC5prev=1 if Q4181_1==2|Q4181_1==3; 
replace pentypeDC5prev=0 if Q4181_1==1;

*plan2;
replace pentypeDC5prev=1 if Q4181_2==2|Q4181_2==3; 
replace pentypeDC5prev=0 if Q4181_2==1;



************************************************************************************;
****************************now calculate pension wealth;

*current;

replace Q3482_1=0 if (Q3482_1==.|Q3482_1>9900000); *amount in accout presently;
replace Q3482_2=0 if (Q3482_2==.|Q3482_2>9900000); 
replace Q3482_3=0 if (Q3482_3==.|Q3482_3>9900000); 
replace Q3482_4=0 if (Q3482_4==.|Q3482_4>9900000); 

replace Q3625_1=0 if (Q3625_1==.| Q3625_1>9900000); *amount in accout presently;
replace Q3625_2=0 if (Q3625_2==.| Q3625_2>9900000); 
replace Q3625_3=0 if (Q3625_3==.| Q3625_3>9900000); 
replace Q3625_4=0 if (Q3625_4==.|Q3625_4>9900000); 

replace Q3643_1=0 if (Q3643_1==.| Q3643_1>9900000); *amount in accout presently;
replace Q3643_2=0 if (Q3643_2==.| Q3643_2>9900000); 
replace Q3643_3=0 if (Q3643_3==.| Q3643_3>9900000); 
replace Q3643_4=0 if (Q3643_4==.|Q3643_4>9900000); 

replace Q3684_1=0 if (Q3684_1==.| Q3684_1>9900000); *amount in accout presently;
replace Q3684_2=0 if (Q3684_2==.| Q3684_2>9900000); 
replace Q3684_3=0 if (Q3684_3==.| Q3684_3>9900000); 
replace Q3684_4=0 if (Q3684_4==.|Q3684_4>9900000); 

replace Q3755_1=0 if (Q3755_1==.| Q3755_1>9900000); *amount in accout presently;
replace Q3755_2=0 if (Q3755_2==.| Q3755_2>9900000); 
replace Q3755_3=0 if (Q3755_3==.| Q3755_3>9900000); 
replace Q3755_4=0 if (Q3755_4==.|Q3755_4>9900000); 



gen penwDC5curr=Q3482_1+Q3482_2+Q3482_3+Q3482_4+Q3625_1+Q3625_2+Q3625_3+Q3625_4+Q3643_1+Q3643_2+Q3643_3+Q3643_4+Q3684_1+Q3684_2+Q3684_3+Q3684_4+Q3755_1+Q3755_2+Q3755_3+Q3755_4;
replace penwDC5curr=0 if penwDC5curr==.;

***********last;
*User's note from Codebook: "up to three responses allowed";
replace Q3997_1=0 if (Q3997_1==.| Q3997_1>9900000); *COMBO amount in accout NOW;
replace Q3997_2=0 if (Q3997_2==.| Q3997_2>9900000); 
replace Q3997_3=0 if (Q3997_3==.| Q3997_3>9900000);

replace Q3997_1=0 if Q3996_1~=3; 
replace Q3997_2=0 if Q3996_2~=3;
replace Q3997_3=0 if Q3996_3~=3;




gen penwDC5last=Q3997_1+Q3997_2+Q3997_3;
replace penwDC5last=0 if penwDC5last==.;
replace penwDC5last=penwDC4last if (penwDC5last==0 & penwDC4last~=.);



**********prev;

replace Q4123_1=0 if (Q4123_1==.| Q4123_1>9900000); *COMBO - amount in accout NOW;
replace Q4123_2=0 if (Q4123_2==.| Q4123_2>9900000); 
replace Q4123_1=0 if Q4122_1~=3;
replace Q4123_2=0 if Q4122_2~=3;

replace Q4158_1=0 if (Q4158_1==.| Q4158_1>9900000); *DC - amount in accout NOW;
replace Q4158_2=0 if (Q4158_2==.| Q4158_2>9900000); 
replace Q4158_1=0 if Q4157_1~=3;
replace Q4158_2=0 if Q4157_2~=3;

replace Q4184_1=0 if (Q4184_1==.| Q4184_1>9900000); *COMBO - amount in accout NOW;
replace Q4184_2=0 if (Q4184_2==.| Q4184_2>9900000); 
replace Q4184_1=0 if Q4183_1~=3;
replace Q4184_2=0 if Q4183_2~=3;

replace Q4215_1=0 if (Q4215_1==.| Q4215_1>9900000); *DC - amount in accout NOW;
replace Q4215_2=0 if (Q4215_2==.| Q4215_2>9900000); 
replace Q4215_1=0 if Q4214_1~=3;
replace Q4215_2=0 if Q4214_2~=3;

gen penwDC5prev=Q4123_1+Q4123_2+Q4158_1+Q4158_2+Q4184_1+Q4184_2+Q4215_1+Q4215_2;
replace penwDC5prev=0 if penwDC5prev==.;
replace penwDC5prev=penwDC4prev if (penwDC5prev==0 & penwDC4prev~=.);


gen penwDC5=penwDC5curr+penwDC5last+penwDC5prev;



***************tenure******************;
replace Q3954=0 if Q3954==9998|Q3954==9999;  *DK, RF;
replace Q3974=0 if Q3974==9998|Q3974==9999;  *DK, RF;
gen tenurelast5=Q3954-Q3974 if Q3954>Q3974 & Q3974~=0 ;  *year last worked - year started working;

replace Q4104=0 if Q4104==9998|Q4104==9999;  *DK, RF;
replace Q4096=0 if Q4096==9998|Q4096==9999;  *DK, RF;
gen tenureprev5=Q4104-Q4096 if Q4104>Q4096 & Q4096~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast5= Q3967 if Q3968==6; *how much earning, if salary is per year;
replace earnlast5=Q3967*(Q3966/4) if Q3968==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast5=Q3967*(Q3966/2) if Q3968==3|Q3968==5; * salary is bi-weekly;
replace earnlast5=Q3967*(Q3966) if Q3968==2; *salary is weekly;
replace earnlast5=(Q3967*Q3966*Q3963) if Q3968==1; *earn*weeks worked*hrs a week if hourly;

replace earnlast5=. if Q3963>997;
replace earnlast5=. if Q3966>97;
replace earnlast5=. if Q3967>99999000;
************* hourly wages******************;
gen wagelast5=earnlast5/(Q3963*Q3966); *earn/(hrs a week*weeks worked);



****************yearly earnings on prev job**************;
gen earnprev5= Q4111 if Q4112==6;
replace earnprev5=Q4111*(Q4110/4) if Q4112==4;
replace earnprev5=Q4111*(Q4110/2) if Q4112==3;
replace earnprev5=Q4111*(Q4110) if Q4112==2;
replace earnprev5=(Q4111*Q4110*Q4109) if Q4112==1;

replace earnprev5=. if Q4109>997;
replace earnprev5=. if Q4110>97;
replace earnprev5=. if Q4111>99999000;
************* hourly wages******************;
gen wageprev5=earnprev5/(Q4109*Q4110); *earn/(hrs a week*weeks worked);


*************** earliest age to still receive benefits ************;

* for pension plan 1;
gen peneage5=Q3721_1;
replace peneage5=35 if Q3721_1==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
replace peneage5=. if peneage5>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage5=Q3721_2 if peneage5~=. & Q3721_2~=. & peneage5>Q3721_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage5=Q3721_2 if peneage5==.;
replace peneage5=. if peneage5>95; 
replace peneage5=35 if Q3721_2==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage5=Q3721_3 if peneage5~=. & Q3721_3~=. & peneage5>Q3721_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace peneage5=Q3721_3 if peneage5==.;
replace peneage5=. if peneage5>95; 
replace peneage5=35 if Q3721_3==95; * access pension benefits anytime;

* for pension plan 4;
replace peneage5=Q3721_4 if peneage5~=. & Q3721_4~=. & peneage5>Q3721_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace peneage5=Q3721_4 if peneage5==.;
replace peneage5=. if peneage5>95; 
replace peneage5=35 if Q3721_4==95; * access pension benefits anytime;


**** the following re-coding may not be logically thorough enough;
* replace Q3493_1=96 if Q3493_1==.| Q3493_1==0;
* replace Q3493_2=96 if Q3493_2==.| Q3493_2==0;
* replace Q3493_3=96 if Q3493_3==.| Q3493_3==0;
* gen peneage5=min(Q3493_1, Q3493_2, Q3493_3);
* replace peneage5=30 if peneage5==95;
* replace peneage5=. if peneage5==0|peneage5>95;
*Q3493 - G38;

************************************ age to receive full benefits *****************************;


* for pension plan 1;
gen pennage5=Q3705_1;
replace pennage5=35 if pennage5==95;* access pension benefits anytime;
replace pennage5=. if pennage5>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage5=Q3705_2 if pennage5~=. & Q3705_2~=. & pennage5>Q3705_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage5=Q3705_2 if pennage5==.;
replace pennage5=. if pennage5>95; 
replace pennage5=35 if Q3705_2==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage5=Q3705_3 if pennage5~=. & Q3705_3~=. & pennage5>Q3705_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace pennage5=Q3705_3 if pennage5==.;
replace pennage5=. if pennage5>95; 
replace pennage5=35 if Q3705_3==95; * access pension benefits anytime;

* for pension plan 4;
replace pennage5=Q3705_4 if pennage5~=. & Q3705_4~=. & pennage5>Q3705_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace pennage5=Q3705_4 if pennage5==.;
replace pennage5=. if pennage5>95; 
replace pennage5=35 if Q3705_4==95; * access pension benefits anytime;


**** the following re-coding may not be logically thorough enough;
* replace Q3705_1=96 if Q3705_1==.| Q3705_1==0;
* replace Q3705_2=96 if Q3705_2==.| Q3705_2==0;
* replace Q3705_3=96 if Q3705_3==.| Q3705_3==0;
* gen pennage5=min(Q3705_1, Q3705_2, Q3705_3);
* replace pennage5=30 if pennage5==95;
* replace pennage5=. if pennage5==0|pennage5>95;
*Q3705 - G83;

keep pen* ten* peneage5 pennage5 HHID PN same_pen5 earn* wage*; 
sort HHID PN;
merge HHID PN using `saved'pension; 
* drop Q* V*;
drop _merge; 
summ pentypeDB5* pentypeDC5* peneage5 pennage5;
sort pentypeDB5curr;
by pentypeDB5curr: summ pennage5 peneage5 pentypeDB5curr;

replace pentypeDB5curr=pentypeDB4curr if same_pen5==1 & pentypeDB4curr~=. & pentypeDB5curr==0;
replace pentypeDC5curr=pentypeDC4curr if same_pen5==1 & pentypeDC4curr~=. & pentypeDC5curr==0 ;
replace peneage5=peneage4 if same_pen5==1 & peneage4~=. & peneage5==.;
replace pennage5=pennage4 if same_pen5==1 & pennage4~=. & pennage5==.;

summ pentypeDB5curr pentypeDC5curr peneage5 pennage5;
sort pentypeDB5curr;
by pentypeDB5curr: summ pennage5 peneage5 pentypeDB5curr;

sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 

*************************************************************************************;
************************************************************* WAVE 6   **************;

clear;
*set mem 200m;
use `wave5d'H00G_R;***to know whether or not a person worked in wave5***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave6d'temp, replace;
clear;

*set mem 200m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave5;
sort HHID PN; 
merge HHID PN using `wave6d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave6d'temp, replace;
clear;


*set mem 200m;
use `wave6d'H02J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave6d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave6d'temp, replace;
clear;

*set mem 200m;
use `wave6d'H02K_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave6d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave6d'temp, replace;
clear;

*set mem 200m;
use `wave6d'H02L_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave6d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave6d'temp, replace;



*********** variable same6 ***********;

gen same_pen6=0;
replace same_pen6=1 if HJ268==5|HJ268==8; * No changes from the last way. * HJ268==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen6;



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB6curr=.;
gen pentypeDB6last=.;
gen pentypeDB6prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB6curr=0  if HJ020==5|HJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDB6curr=0 if HJ268==7; * deny being covered by a pension;

******************* 1B: retired, last job--DB*******;
replace pentypeDB6last=0  if HK001==5|HK001==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB6prev=0  if HL005==5|HL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB6curr=0 if (HJ324==5|HJ324==8);  *those who change jobs from previous wave,;
replace pentypeDB6curr=0 if (HJ084==5|HJ084==8); *same job as last wave;



*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDB6curr=1 if HJ090_1==1|HJ090_1==3;
replace pentypeDB6curr=0 if HJ090_1==2; 

*  for plan 2;
replace pentypeDB6curr=1 if HJ090_2==1|HJ090_2==3;
replace pentypeDB6curr=0 if HJ090_2==2; 

*  for plan 3;
replace pentypeDB6curr=1 if HJ090_3==1|HJ090_3==3;
replace pentypeDB6curr=0 if HJ090_3==2;

*  for plan 4;
replace pentypeDB6curr=1 if HJ090_4==1|HJ090_4==3;
replace pentypeDB6curr=0 if HJ090_4==2;


****those who did not change jobs from prev. wave;
*  for plan 1;
replace pentypeDB6curr=1 if HJ272_1==1|HJ272_1==3;
replace pentypeDB6curr=0 if HJ272_1==2; 

*  for plan 2;
replace pentypeDB6curr=1 if HJ272_2==1|HJ272_2==3;
replace pentypeDB6curr=0 if HJ272_2==2; 

*  for plan 3;
replace pentypeDB6curr=1 if HJ272_3==1|HJ272_3==3;
replace pentypeDB6curr=0 if HJ272_3==2; 

*  for plan 4;
replace pentypeDB6curr=1 if HJ272_4==1|HJ272_4==3;
replace pentypeDB6curr=0 if HJ272_4==2;



*****this is for people who changed employers b/w last two waves;
replace pentypeDB6curr=1 if HJ327==1|HJ327==3; 
replace pentypeDB6curr=0 if HJ327==2;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDB6curr=1 if HJ338_1==1|HJ338_1==3;
replace pentypeDB6curr=0 if HJ338_1==2; 

*  for plan 2;
replace pentypeDB6curr=1 if HJ338_2==1|HJ338_2==3;
replace pentypeDB6curr=0 if HJ338_2==2; 

*  for plan 3;
replace pentypeDB6curr=1 if HJ338_3==1|HJ338_3==3;
replace pentypeDB6curr=0 if HJ338_3==2; 

*  for plan 4;
replace pentypeDB6curr=1 if HJ338_4==1|HJ338_4==3;
replace pentypeDB6curr=0 if HJ338_4==2;




******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB6last=0 if (HK026==5|HK026==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB6last=1 if HK029_1==1|HK029_1==3; 
replace pentypeDB6last=0 if HK029_1==2;

*  for plan 2;
replace pentypeDB6last=1 if HK029_2==1|HK029_2==3; 
replace pentypeDB6last=0 if HK029_2==2;

*  for plan 3;
replace pentypeDB6last=1 if HK029_3==1|HK029_3==3; 
replace pentypeDB6last=0 if HK029_3==2;


***imputed last job pension plans: G3365M1/2/3- wave5 working, HJ005M1/2/3 - Wave 6 retired;
replace pentypeDB6last=1 if (G3365M1==1|G3365M2==1|G3365M3==1) & (HJ005M1==5|HJ005M2==5|HJ005M3==5) & pentypeDB5curr==1;



******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB6prev=0 if (HL027==5|HL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB6prev=0 if (HL075==5|HL075==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB6prev=1 if HL031_1==1|HL031_1==3; 
replace pentypeDB6prev=0 if HL031_1==2;

* plan 2;
replace pentypeDB6prev=1 if HL031_2==1|HL031_2==3; 
replace pentypeDB6prev=0 if HL031_2==2;



*plan1;
replace pentypeDB6prev=1 if HL082_1==1|HL082_1==3; 
replace pentypeDB6prev=0 if HL082_1==2;

*plan2;
replace pentypeDB6prev=1 if HL082_2==1|HL082_2==3; 
replace pentypeDB6prev=0 if HL082_2==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC6curr=.;
gen pentypeDC6last=.;
gen pentypeDC6prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC6curr=0  if HJ020==5|HJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDC6curr=0 if HJ268==7; * deny being covered by a pension;

******************* 1B: retired, last job--DC*******;
replace pentypeDC6last=0  if HK001==5|HK001==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC6prev=0  if HL005==5|HL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC6curr=0 if (HJ324==5|HJ324==8);  *those who change jobs from previous wave; 
replace pentypeDC6curr=0 if (HJ084==5|HJ084==8); 


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDC6curr=1 if HJ090_1==2|HJ090_1==3;
replace pentypeDC6curr=0 if HJ090_1==1; 

*  for plan 2;
replace pentypeDC6curr=1 if HJ090_2==2|HJ090_2==3;
replace pentypeDC6curr=0 if HJ090_2==1; 

*  for plan 3;
replace pentypeDC6curr=1 if HJ090_3==2|HJ090_3==3;
replace pentypeDC6curr=0 if HJ090_3==1;

*  for plan 4;
replace pentypeDC6curr=1 if HJ090_4==2|HJ090_4==3;
replace pentypeDC6curr=0 if HJ090_4==1;


****those who did not change jobs from prev. wave;
*  for plan 1;
replace pentypeDC6curr=1 if HJ272_1==2|HJ272_1==3;
replace pentypeDC6curr=0 if HJ272_1==1; 

*  for plan 2;
replace pentypeDC6curr=1 if HJ272_2==2|HJ272_2==3;
replace pentypeDC6curr=0 if HJ272_2==1; 

*  for plan 3;
replace pentypeDC6curr=1 if HJ272_3==2|HJ272_3==3;
replace pentypeDC6curr=0 if HJ272_3==1; 

*  for plan 4;
replace pentypeDC6curr=1 if HJ272_4==2|HJ272_4==3;
replace pentypeDC6curr=0 if HJ272_4==1;



*****this is for people who changed employers b/w last two waves;
replace pentypeDC6curr=1 if HJ327==2|HJ327==3; 
replace pentypeDC6curr=0 if HJ327==1;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDC6curr=1 if HJ338_1==2|HJ338_1==3;
replace pentypeDC6curr=0 if HJ338_1==1; 

*  for plan 2;
replace pentypeDC6curr=1 if HJ338_2==2|HJ338_2==3;
replace pentypeDC6curr=0 if HJ338_2==1; 

*  for plan 3;
replace pentypeDC6curr=1 if HJ338_3==2|HJ338_3==3;
replace pentypeDC6curr=0 if HJ338_3==1; 

*  for plan 4;
replace pentypeDC6curr=1 if HJ338_4==2|HJ338_4==3;
replace pentypeDC6curr=0 if HJ338_4==1;




******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC6last=0 if (HK026==5|HK026==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC6last=1 if HK029_1==2|HK029_1==3; 
replace pentypeDC6last=0 if HK029_1==1;

*  for plan 2;
replace pentypeDC6last=1 if HK029_2==2|HK029_2==3; 
replace pentypeDC6last=0 if HK029_2==1;

*  for plan 3;
replace pentypeDC6last=1 if HK029_3==2|HK029_3==3; 
replace pentypeDC6last=0 if HK029_3==1;



***imputed last job pension plans: G3365M1/2/3- wave5 working, HJ005M1/2/3 - Wave 6 retired;
replace pentypeDC6last=1 if (G3365M1==1|G3365M2==1|G3365M3==1) & (HJ005M1==5|HJ005M2==5|HJ005M3==5) & pentypeDC5curr==1;





******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC6prev=0 if (HL027==5|HL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC6prev=0 if (HL075==5|HL075==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC6prev=1 if HL031_1==2|HL031_1==3; 
replace pentypeDC6prev=0 if HL031_1==1;

* plan 2;
replace pentypeDC6prev=1 if HL031_2==2|HL031_2==3; 
replace pentypeDC6prev=0 if HL031_2==1;



*plan1;
replace pentypeDC6prev=1 if HL082_1==2|HL082_1==3; 
replace pentypeDC6prev=0 if HL082_1==1;

*plan2;
replace pentypeDC6prev=1 if HL082_2==2|HL082_2==3; 
replace pentypeDC6prev=0 if HL082_2==1;



************************************************************************************;
****************************now calculate pension wealth;

*current;

replace HJ091_1=0 if (HJ091_1==.|HJ091_1>9900000); *amount in accout presently;
replace HJ091_2=0 if (HJ091_2==.|HJ091_2>990000); 
replace HJ091_3=0 if (HJ091_3==.|HJ091_3>990000); 
replace HJ091_4=0 if (HJ091_4==.|HJ091_4>990000); 

replace HJ273_1=0 if (HJ273_1==.| HJ273_1>990000); *amount in accout presently;
replace HJ273_2=0 if (HJ273_2==.| HJ273_2>990000); 
replace HJ273_3=0 if (HJ273_3==.| HJ273_3>990000); 
replace HJ273_4=0 if (HJ273_4==.| HJ273_4>990000); 

replace HJ307_1=0 if (HJ307_1==.| HJ307_1>9900000); *amount in accout presently;
replace HJ307_2=0 if (HJ307_2==.| HJ307_2>9900000); 
replace HJ307_3=0 if (HJ307_3==.| HJ307_3>990000); 
replace HJ307_4=0 if (HJ307_4==.| HJ307_4>990000); 

replace HJ339_1=0 if (HJ339_1==.| HJ339_1>990000); *amount in accout presently;
replace HJ339_2=0 if (HJ339_2==.| HJ339_2>990000); 
replace HJ339_3=0 if (HJ339_3==.| HJ339_3>990000); 
replace HJ339_4=0 if (HJ339_4==.| HJ339_4>990000); 

replace HJ413_1=0 if (HJ413_1==.| HJ413_1>9900000); *amount in accout presently;
replace HJ413_2=0 if (HJ413_2==.| HJ413_2>990000); 
replace HJ413_3=0 if (HJ413_3==.| HJ413_3>99000); 
replace HJ413_4=0 if (HJ413_4==.| HJ413_4>990000); 


gen penwDC6curr=HJ091_1+HJ091_2+HJ091_3+HJ091_4+HJ273_1+HJ273_2+HJ273_3+HJ273_4+HJ307_1+HJ307_2+HJ307_3+HJ307_4+HJ339_1+HJ339_2+HJ339_3+HJ339_4+HJ413_1+HJ413_2+HJ413_3+HJ413_4;

replace penwDC6curr=0 if penwDC6curr==.;


***********last;
*User's note from Codebook: "up to three responses allowed";
replace HK036_1=0 if (HK036_1==.| HK036_1>99000); *COMBO amount in accout NOW;
replace HK036_2=0 if (HK036_2==.| HK036_2>99000); 
replace HK036_3=0 if (HK036_3==.| HK036_3>99000);

replace HK036_1=0 if HK034_1A~=3; 
replace HK036_2=0 if HK034_2A~=3;
replace HK036_3=0 if HK034_3A~=3;



gen penwDC6last=HK036_1+HK036_2+HK036_3;

replace penwDC6last=0 if penwDC6last==.;
replace penwDC6last=penwDC5last if (penwDC6last==0 & penwDC5last~=.);




**********prev;

replace HL038_1=0 if (HL038_1==.| HL038_1>990000); *COMBO - amount in accout NOW;
replace HL038_2=0 if (HL038_2==.| HL038_2>990000); 
replace HL038_1=0 if HL036_1A~=3;
replace HL038_2=0 if HL036_2A~=3;


replace HL089_1=0 if (HL089_1==.| HL089_1>9900000); *COMBO - amount in accout NOW;
replace HL089_2=0 if (HL089_2==.| HL089_2>9900000); 
replace HL089_1=0 if HL087_1A~=3;
replace HL089_2=0 if HL087_2A~=3;


gen penwDC6prev=HL038_1+HL038_2+HL089_1+HL089_2;
replace penwDC6prev=0 if penwDC6prev==.;
replace penwDC6prev=penwDC5prev if (penwDC6prev==0 & penwDC5prev~=.);


gen penwDC6=penwDC6curr+penwDC6last+penwDC6prev;



***************tenure******************;
replace HK002=0 if HK002==9998|HK002==9999;  *DK, RF;
replace HK018=0 if HK018==9998|HK018==9999;  *DK, RF;
gen tenurelast6=HK002-HK018 if HK002>HK018 & HK018~=0 ;  *year last worked - year started working;

replace HL016=0 if HL016==9998|HL016==9999;  *DK, RF;
replace HL009=0 if HL009==9998|HL009==9999;  *DK, RF;
gen tenureprev6=HL016-HL009 if HL016>HL009 & HL009~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast6= HK012 if HK013==6; *how much earning, if salary is per year;
replace earnlast6=HK012*(HK011/4) if HK013==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast6=HK012*(HK011/2) if HK013==3|HK013==5; * salary is bi-weekly;
replace earnlast6=HK012*(HK011) if HK013==2; *salary is weekly;
replace earnlast6=(HK012*HK011*HK008) if HK013==1; *earn*weeks worked*hrs a week if hourly;

replace earnlast6=. if HK008>997;
replace earnlast6=. if HK011>97;
replace earnlast6=. if HK012>999999990;
************* hourly wages******************;
gen wagelast6=earnlast6/(HK008*HK011); *earn/(hrs a week*weeks worked);



****************yearly earnings on prev job**************;
gen earnprev6= HL022 if HL023==6;
replace earnprev6=HL022*(HL021/4) if HL023==4;
replace earnprev6=HL022*(HL021/2) if HL023==3|HL023==5;
replace earnprev6=HL022*(HL021) if HL023==2;
replace earnprev6=(HL022*HL021*HL020) if HL023==1;


replace earnprev6=. if HL020>997;
replace earnprev6=. if HL021>97;
replace earnprev6=. if HL022>999999000;
************* hourly wages******************;
gen wageprev6=earnprev6/(HL020*HL021); *earn/(hrs a week*weeks worked);


*************** earliest age to still receive benefits ************;

* for pension plan 1;
gen peneage6=HJ383_1;
replace peneage6=35 if HJ383_1==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
replace peneage6=. if peneage6>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage6=HJ383_2 if peneage6~=. & HJ383_2~=. & peneage6>HJ383_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage6=HJ383_2 if peneage6==.;
replace peneage6=. if peneage6>95; 
replace peneage6=35 if HJ383_2==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage6=HJ383_3 if peneage6~=. & HJ383_3~=. & peneage6>HJ383_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace peneage6=HJ383_3 if peneage6==.;
replace peneage6=. if peneage6>95; 
replace peneage6=35 if HJ383_3==95; * access pension benefits anytime;

* for pension plan 4;
replace peneage6=HJ383_4 if peneage6~=. & HJ383_4~=. & peneage6>HJ383_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace peneage6=HJ383_4 if peneage6==.;
replace peneage6=. if peneage6>95; 
replace peneage6=35 if HJ383_4==95; * access pension benefits anytime;


************************************ age to receive full benefits *****************************;


* for pension plan 1;
gen pennage6=HJ367_1;
replace pennage6=35 if pennage6==95;* access pension benefits anytime;
replace pennage6=. if pennage6>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage6=HJ367_2 if pennage6~=. & HJ367_2~=. & pennage6>HJ367_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage6=HJ367_2 if pennage6==.;
replace pennage6=. if pennage6>95; 
replace pennage6=35 if HJ367_2==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage6=HJ367_3 if pennage6~=. & HJ367_3~=. & pennage6>HJ367_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace pennage6=HJ367_3 if pennage6==.;
replace pennage6=. if pennage6>95; 
replace pennage6=35 if HJ367_3==95; * access pension benefits anytime;

* for pension plan 4;
replace pennage6=HJ367_4 if pennage6~=. & HJ367_4~=. & pennage6>HJ367_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace pennage6=HJ367_4 if pennage6==.;
replace pennage6=. if pennage6>95; 
replace pennage6=35 if HJ367_4==95; * access pension benefits anytime;


keep pen* ten* peneage6 pennage6 HHID PN same_pen6 earn* wage*; 
sort HHID PN;
merge HHID PN using `saved'pension; 

drop _merge; 
summ pentypeDB6* pentypeDC6* peneage6 pennage6;
sort pentypeDB6curr;
by pentypeDB6curr: summ pennage6 peneage6 pentypeDB6curr;

replace pentypeDB6curr=pentypeDB5curr if same_pen6==1 & pentypeDB5curr~=. & pentypeDB6curr==0;
replace pentypeDC6curr=pentypeDC5curr if same_pen6==1 & pentypeDC5curr~=. & pentypeDC6curr==0 ;
replace peneage6=peneage5 if same_pen6==1 & peneage5~=. & peneage6==.;
replace pennage6=pennage5 if same_pen6==1 & pennage5~=. & pennage6==.;

summ pentypeDB6curr pentypeDC6curr peneage6 pennage6;
sort pentypeDB6curr;
by pentypeDB6curr: summ pennage6 peneage6 pentypeDB6curr;

sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 


*************************************************************************************;
************************************************************* WAVE 7   **************;

clear;
*set mem 200m;
use `wave6d'H02J_R;***to know whether or not a person worked in wave6***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave7d'temp, replace;
clear;

*set mem 200m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave6;
sort HHID PN; 
merge HHID PN using `wave7d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave7d'temp, replace;
clear;


*set mem 200m;
use `wave7d'H04J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave7d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave7d'temp, replace;
clear;

*set mem 200m;
use `wave7d'H04K_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave7d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave7d'temp, replace;
clear;

*set mem 200m;
use `wave7d'H04L_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave7d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave7d'temp, replace;



*********** variable same7 ***********;

gen same_pen7=0;
replace same_pen7=1 if JJ268==5|JJ268==8; * No changes from the last way. * JJ268==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen7;



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB7curr=.;
gen pentypeDB7last=.;
gen pentypeDB7prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB7curr=0  if JJ020==5|JJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDB7curr=0 if JJ268==7; * deny being covered by a pension;

******************* 1B: retired, last job--DB*******;
replace pentypeDB7last=0  if JK003==5|JK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB7prev=0  if JL005==5|JL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB7curr=0 if (JJ324==5|JJ324==8);  *those who change jobs from previous wave,;
replace pentypeDB7curr=0 if (JJ084==5|JJ084==8); *same job as last wave;



*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDB7curr=1 if JJW001a==1|JJW001a==3;
replace pentypeDB7curr=0 if JJW001a==2; 

*  for plan 2;
replace pentypeDB7curr=1 if JJW001b==1|JJW001b==3;
replace pentypeDB7curr=0 if JJW001b==2; 

*  for plan 3;
replace pentypeDB7curr=1 if JJW001c==1|JJW001c==3;
replace pentypeDB7curr=0 if JJW001c==2;

*  for plan 4;
replace pentypeDB7curr=1 if JJW001d==1|JJW001d==3;
replace pentypeDB7curr=0 if JJW001d==2;





*****this is for people who changed employers b/w last two waves;
replace pentypeDB7curr=1 if JJ327==1|JJ327==3; 
replace pentypeDB7curr=0 if JJ327==2;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDB7curr=1 if JJ338a==1|JJ338a==3;
replace pentypeDB7curr=0 if JJ338a==2; 

*  for plan 2;
replace pentypeDB7curr=1 if JJ338b==1|JJ338b==3;
replace pentypeDB7curr=0 if JJ338b==2; 

*  for plan 3;
replace pentypeDB7curr=1 if JJ338c==1|JJ338c==3;
replace pentypeDB7curr=0 if JJ338c==2; 

*  for plan 4;
replace pentypeDB7curr=1 if JJ338d==1|JJ338d==3;
replace pentypeDB7curr=0 if JJ338d==2;




******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB7last=0 if (JK031==5|JK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB7last=1 if JKW001a==1|JKW001a==3; 
replace pentypeDB7last=0 if JKW001a==2;

*  for plan 2;
replace pentypeDB7last=1 if JKW001b==1|JKW001b==3; 
replace pentypeDB7last=0 if JKW001b==2;

*  for plan 3;
replace pentypeDB7last=1 if JKW001c==1|JKW001c==3; 
replace pentypeDB7last=0 if JKW001c==2;


***imputed last job pension plans: HJ005M1/2/3- wave6 working, JJ005M1/2/3 - Wave 7 retired;
replace pentypeDB7last=1 if (HJ005M1==1|HJ005M2==1|HJ005M3==1) & (JJ005M1==5|JJ005M2==5|JJ005M3==5) & pentypeDB6curr==1;



******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB7prev=0 if (JL027==5|JL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB7prev=0 if (JL031==5|JL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB7prev=1 if JLW001a==1|JLW001a==3; 
replace pentypeDB7prev=0 if JLW001a==2;

* plan 2;
replace pentypeDB7prev=1 if JLW001b==1|JLW001b==3; 
replace pentypeDB7prev=0 if JLW001b==2;

* plan 3;
replace pentypeDB7prev=1 if JLW001c==1|JLW001c==3; 
replace pentypeDB7prev=0 if JLW001c==2;

* plan 4;
replace pentypeDB7prev=1 if JLW001d==1|JLW001d==3; 
replace pentypeDB7prev=0 if JLW001d==2;

* plan 5;
replace pentypeDB7prev=1 if JLW001e==1|JLW001e==3; 
replace pentypeDB7prev=0 if JLW001e==2;

* plan 6;
replace pentypeDB7prev=1 if JLW001f==1|JLW001f==3; 
replace pentypeDB7prev=0 if JLW001f==2;


*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC7curr=.;
gen pentypeDC7last=.;
gen pentypeDC7prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC7curr=0  if JJ020==5|JJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDC7curr=0 if JJ268==7; * deny being covered by a pension;

******************* 1B: retired, last job--DC*******;
replace pentypeDC7last=0  if JK003==5|JK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC7prev=0  if JL005==5|JL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC7curr=0 if (JJ324==5|JJ324==8);  *those who change jobs from previous wave; 
replace pentypeDC7curr=0 if (JJ084==5|JJ084==8); 


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDC7curr=1 if JJW001a==2|JJW001a==3;
replace pentypeDC7curr=0 if JJW001a==1; 

*  for plan 2;
replace pentypeDC7curr=1 if JJW001b==2|JJW001b==3;
replace pentypeDC7curr=0 if JJW001b==1; 

*  for plan 3;
replace pentypeDC7curr=1 if JJW001c==2|JJW001c==3;
replace pentypeDC7curr=0 if JJW001c==1;

*  for plan 4;
replace pentypeDC7curr=1 if JJW001d==2|JJW001d==3;
replace pentypeDC7curr=0 if JJW001d==1;


****those who did not change jobs from prev. wave;
*  for plan 1;
replace pentypeDC7curr=1 if HJ272_1==2|HJ272_1==3;
replace pentypeDC7curr=0 if HJ272_1==1; 

*  for plan 2;
replace pentypeDC7curr=1 if HJ272_2==2|HJ272_2==3;
replace pentypeDC7curr=0 if HJ272_2==1; 

*  for plan 3;
replace pentypeDC7curr=1 if HJ272_3==2|HJ272_3==3;
replace pentypeDC7curr=0 if HJ272_3==1; 

*  for plan 4;
replace pentypeDC7curr=1 if HJ272_4==2|HJ272_4==3;
replace pentypeDC7curr=0 if HJ272_4==1;



*****this is for people who changed employers b/w last two waves;
replace pentypeDC7curr=1 if JJ327==2|JJ327==3; 
replace pentypeDC7curr=0 if JJ327==1;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDC7curr=1 if JJ338a==2|JJ338a==3;
replace pentypeDC7curr=0 if JJ338a==1; 

*  for plan 2;
replace pentypeDC7curr=1 if JJ338b==2|JJ338b==3;
replace pentypeDC7curr=0 if JJ338b==1; 

*  for plan 3;
replace pentypeDC7curr=1 if JJ338c==2|JJ338c==3;
replace pentypeDC7curr=0 if JJ338c==1; 

*  for plan 4;
replace pentypeDC7curr=1 if JJ338d==2|JJ338d==3;
replace pentypeDC7curr=0 if JJ338d==1;




******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC7last=0 if (JK031==5|JK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC7last=1 if JKW001a==2|JKW001a==3; 
replace pentypeDC7last=0 if JKW001a==1;

*  for plan 2;
replace pentypeDC7last=1 if JKW001b==2|JKW001b==3; 
replace pentypeDC7last=0 if JKW001b==1;

*  for plan 3;
replace pentypeDC7last=1 if JKW001c==2|JKW001c==3; 
replace pentypeDC7last=0 if JKW001c==1;



***imputed last job pension plans: HJ005M1/2/3- wave5 working, JJ005M1/2/3 - Wave 7 retired;
replace pentypeDC7last=1 if (HJ005M1==1|HJ005M2==1|HJ005M3==1) & (JJ005M1==5|JJ005M2==5|JJ005M3==5) & pentypeDC6curr==1;





******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC7prev=0 if (JL027==5|JL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC7prev=0 if (JL031==5|JL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC7prev=1 if JLW001a==2|JLW001a==3; 
replace pentypeDC7prev=0 if JLW001a==1;

* plan 2;
replace pentypeDC7prev=1 if JLW001b==2|JLW001b==3; 
replace pentypeDC7prev=0 if JLW001b==1;

* plan 3;
replace pentypeDC7prev=1 if JLW001c==2|JLW001c==3; 
replace pentypeDC7prev=0 if JLW001c==1;

* plan 4;
replace pentypeDC7prev=1 if JLW001d==2|JLW001d==3; 
replace pentypeDC7prev=0 if JLW001d==1;

* plan 5;
replace pentypeDC7prev=1 if JLW001e==2|JLW001e==3; 
replace pentypeDC7prev=0 if JLW001e==1;

* plan 6;
replace pentypeDC7prev=1 if JLW001f==2|JLW001f==3; 
replace pentypeDC7prev=0 if JLW001f==1;





************************************************************************************;
****************************now calculate pension wealth;

*current;

replace JJW002a=0 if (JJW002a==.|JJW002a>9900000); *amount in accout presently;
replace JJW002b=0 if (JJW002b==.|JJW002b>9900000); 
replace JJW002c=0 if (JJW002c==.|JJW002c>9900000); 
replace JJW002d=0 if (JJW002d==.|JJW002d>9900000); 

replace JJ339a=0 if (JJ339a==.| JJ339a>9900000); *amount in accout presently;
replace JJ339b=0 if (JJ339b==.| JJ339b>9900000); 
replace JJ339c=0 if (JJ339c==.| JJ339c>9900000); 
replace JJ339d=0 if (JJ339d==.|JJ339d>9900000); 

replace JJ413a=0 if (JJ413a==.| JJ413a>9900000); *amount in accout presently;
replace JJ413b=0 if (JJ413b==.| JJ413b>9900000); 
replace JJ413c=0 if (JJ413c==.| JJ413c>9900000); 
replace JJ413d=0 if (JJ413d==.|JJ413d>9900000); 

gen penwDC7curr=JJW002a+JJW002b+JJW002c+JJW002d+JJ339a+JJ339b+JJ339c+JJ339d+JJ413a+JJ413b+JJ413c+JJ413d;
replace penwDC7curr=0 if penwDC7curr==.;


***********last;
*User's note from Codebook: "up to three responses allowed";
replace JKW009a=0 if (JKW009a==.| JKW009a>9900000); *COMBO amount in accout NOW;
replace JKW009b=0 if (JKW009b==.| JKW009b>9900000); 
replace JKW009c=0 if (JKW009c==.| JKW009c>9900000);

replace JKW009a=0 if JKW006a1~=3 & JKW006a2~=3; 
replace JKW009b=0 if JKW006b1~=3 & JKW006b2~=3;
replace JKW009c=0 if JKW006c1~=3;


gen penwDC7last=JKW009a+JKW009b+JKW009c;
replace penwDC7last=0 if penwDC7last==.;
replace penwDC7last=penwDC6last if (penwDC7last==0 & penwDC6last~=.);



**********prev;

replace JLW009a=0 if (JLW009a==.| JLW009a>990000); *COMBO - amount in accout NOW;
replace JLW009b=0 if (JLW009b==.| JLW009b>990000); 
replace JLW009c=0 if (JLW009c==.| JLW009c>990000); 
replace JLW009d=0 if (JLW009d==.| JLW009d>990000); 
replace JLW009e=0 if (JLW009e==.| JLW009e>990000); 
replace JLW009f=0 if (JLW009f==.| JLW009f>990000); 
replace JLW009a=0 if JLW006a1~=3 & JLW006a2~=3;
replace JLW009b=0 if JLW006b1~=3 & JLW006b2~=3;
replace JLW009c=0 if JLW006c1~=3;
replace JLW009d=0 if JLW006d1~=3;
replace JLW009e=0 if JLW006e1~=3;
replace JLW009f=0 if JLW006f1~=3 & JLW006f2~=3;


gen penwDC7prev=JLW009a+JLW009b+JLW009c+JLW009d+JLW009e+JLW009f;
replace penwDC7prev=0 if penwDC7prev==.;
replace penwDC7prev=penwDC6prev if (penwDC7prev==0 & penwDC6prev~=.);


gen penwDC7=penwDC7curr+penwDC7last+penwDC7prev;


***************tenure******************;
replace JK004=0 if JK004==9998|JK004==9999;  *DK, RF;
replace JK022=0 if JK022==9998|JK022==9999;  *DK, RF;
gen tenurelast7=JK004-JK022 if JK004>JK022 & JK022~=0 ;  *year last worked - year started working;

replace JL016=0 if JL016==9998|JL016==9999;  *DK, RF;
replace JL009=0 if JL009==9998|JL009==9999;  *DK, RF;
gen tenureprev7=JL016-JL009 if JL016>JL009 & JL009~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast7= JK015 if JK016==6; *how much earning, if salary is per year;
replace earnlast7=JK015*(JK014/4) if JK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast7=JK015*(JK014/2) if JK016==3|JK016==5; * salary is bi-weekly;
replace earnlast7=JK015*(JK014) if JK016==2; *salary is weekly;
replace earnlast7=(JK015*JK014*JK011) if JK016==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast7=. if JK011>997;
replace earnlast7=. if JK014>97;
replace earnlast7=. if JK015>9999999990;
************* hourly wages******************;
gen wagelast7=earnlast7/(JK011*JK014); *earn/(hrs a week*weeks worked);


****************yearly earnings on prev job**************;
gen earnprev7= JL022 if JL023==6;
replace earnprev7=JL022*(JL021/4)     if JL023==4;
replace earnprev7=JL022*(JL021/2)     if JL023==3|JL023==5;                     //added a change here as well
replace earnprev7=JL022*(JL021)       if JL023==2;
replace earnprev7=(JL022*JL021*JL020) if JL023==1;
                                                                                //K - edit top codes needed here 
replace earnprev7=.  if JL020>997;                                              //drop top codes for hours worked per week  
replace earnprev7=.  if JL021>97;                                               //drop top codes for weeks worked per year
replace earnprev7=.  if JL022>999999000;                                        //drop top codes for earnings
summ earnprev7       if HHID==500355;                                           // 
replace earnprev7=.  if HHID==500355;                                           //drop someome that reported that he makes 10m per week - he alone increases mean of 1400obs by 300% or something like that
************* hourly wages******************;
gen wageprev7=earnprev7/(JL020*JL021); *earn/(hrs a week*weeks worked);



*************** earliest age to still receive benefits ************;

* for pension plan 1;
gen peneage7=JJ383a;
replace peneage7=35 if JJ383a==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
replace peneage7=. if peneage7>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage7=JJ383b if peneage7~=. & JJ383b~=. & peneage7>JJ383b; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage7=JJ383b if peneage7==.;
replace peneage7=. if peneage7>95; 
replace peneage7=35 if JJ383b==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage7=JJ383c if peneage7~=. & JJ383c~=. & peneage7>JJ383c; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace peneage7=JJ383c if peneage7==.;
replace peneage7=. if peneage7>95; 
replace peneage7=35 if JJ383c==95; * access pension benefits anytime;

* for pension plan 4;
replace peneage7=JJ383d if peneage7~=. & JJ383d~=. & peneage7>JJ383d; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace peneage7=JJ383d if peneage7==.;
replace peneage7=. if peneage7>95; 
replace peneage7=35 if JJ383d==95; * access pension benefits anytime;


************************************ age to receive full benefits *****************************;


* for pension plan 1;
gen pennage7=JJ367a;
replace pennage7=35 if pennage7==95;* access pension benefits anytime;
replace pennage7=. if pennage7>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage7=JJ367b if pennage7~=. & JJ367b~=. & pennage7>JJ367b; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage7=JJ367b if pennage7==.;
replace pennage7=. if pennage7>95; 
replace pennage7=35 if JJ367b==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage7=JJ367c if pennage7~=. & JJ367c~=. & pennage7>JJ367c; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace pennage7=JJ367c if pennage7==.;
replace pennage7=. if pennage7>95; 
replace pennage7=35 if JJ367c==95; * access pension benefits anytime;

* for pension plan 4;
replace pennage7=JJ367d if pennage7~=. & JJ367d~=. & pennage7>JJ367d; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace pennage7=JJ367d if pennage7==.;
replace pennage7=. if pennage7>95; 
replace pennage7=35 if JJ367d==95; * access pension benefits anytime;

******************************************************************;
******GOVT WORKERS************************************************;

replace JL078=. if JL078>2006;
replace JL079=. if JL079>2006;
replace JL080=. if JL080>2006;
replace JL081=. if JL081>2006;

gen Govt7=0;
replace Govt7=JL077 if (JL077==1|JL077==5);
tab JL077;
tab Govt7;
gen GovtYears7=0;
* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin7=JL078;
replace GovtBegin7=1984 if JL078==. & Govt7==1;
gen GovtEnd7=JL079 ;
replace GovtEnd7=2004 if JL079==. & Govt7==1;
replace GovtYears7=GovtEnd7-GovtBegin7;
gen ExYears7=JL081-JL080; *2nd spell for the govt;
replace GovtYears7=GovtYears7+(ExYears7) if (ExYears7>0 & ExYears7~=.);
replace GovtEnd7=JL081 if JL081~=.;
replace GovtYears7=1 if GovtYears7<1 & GovtYears7~=.;
sort Govt7;
by Govt7: sum Govt* Ex*;

*Jobs covered by SS?;

gen SScov7=0;
replace SScov7=JL087 if (JL087==1|JL087==5); 
replace JL088=. if JL088>2006;
replace JL089=. if JL089>2006;
replace JL090=. if JL090>2006;
replace JL091=. if JL091>2006;

* years in job not covered by SS;

gen SSYears7=0;
gen SSBegin7=JL088;
replace SSBegin7=1984 if JL088==. & SScov7==1;
gen SSEnd7=JL089 ;
replace SSEnd7=2004 if JL089==. & SScov7==1;
replace SSYears7=SSEnd7-SSBegin7;
gen ExSSYears7=JL091-JL090; 
replace SSYears7=SSYears7+(ExSSYears7) if (ExSSYears7>0 & ExSSYears7~=.);
replace SSEnd7=JL091 if JL091~=.;
replace SSYears7=1 if SSYears7<1 & SSYears7~=.;
sort SScov7;
by SScov7: sum SS* Ex*;

*proxy w/ GovtYears

replace SScov7=1 if (SScov7==0|SScov7==.) & Govt7==1;
sort SScov7;
by SScov7: sum SSYears7 SScov7;
replace SSYears7=GovtYears7 if SScov7==1 & (SSYears7==.|SSYears7==0) & GovtYears7~=.; 
sort SScov7;
by SScov7: sum SSYears7 SScov7;
replace SSEnd7=GovtEnd7 if SScov7==1 & Govt7==1 & SSEnd7==.;



keep pen* ten* peneage7 pennage7 HHID PN same_pen7 earn* wage* Govt* SS*; 
sort HHID PN;
merge HHID PN using `saved'pension; 

drop _merge; 
summ pentypeDB7* pentypeDC7* peneage7 pennage7;
sort pentypeDB7curr;
by pentypeDB7curr: summ pennage7 peneage7 pentypeDB7curr;

replace pentypeDB7curr=pentypeDB6curr if same_pen7==1 & pentypeDB6curr~=. & pentypeDB7curr==0;
replace pentypeDC7curr=pentypeDC6curr if same_pen7==1 & pentypeDC6curr~=. & pentypeDC7curr==0 ;
replace peneage7=peneage6 if same_pen7==1 & peneage6~=. & peneage7==.;
replace pennage7=pennage6 if same_pen7==1 & pennage6~=. & pennage7==.;

summ pentypeDB7curr pentypeDC7curr peneage7 pennage7;
sort pentypeDB7curr;
by pentypeDB7curr: summ pennage7 peneage7 pentypeDB7curr;



sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 


*************************************************************************************;
************************************************************* WAVE 8   **************;

clear;
*set mem 400m;
use `wave7d'H04J_R;***to know whether or not a person worked in wave7***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave8d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave7;
sort HHID PN; 
merge HHID PN using `wave8d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave8d'temp, replace;
clear;


*set mem 400m;
use `wave8d'H06J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave8d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave8d'temp, replace;
clear;

*set mem 400m;
use `wave8d'H06K_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave8d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave8d'temp, replace;
clear;

*set mem 400m;
use `wave8d'H06L_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave8d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave8d'temp, replace;



*********** variable same_pen8 ***********;

gen same_pen8=0;
replace same_pen8=1 if KJ268==5|KJ268==8; * No changes from the last way. * KJ268==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen8;



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB8curr=.;
gen pentypeDB8last=.;
gen pentypeDB8prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB8curr=0  if KJ020==5|KJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDB8curr=0 if KJ268==7; * deny being covered by a pension;

******************* 1B: retired, last job--DB*******;
replace pentypeDB8last=0  if KK003==5|KK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB8prev=0  if KL005==5|KL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB8curr=0 if (KJ324==5|KJ324==8);  *those who change jobs from previous wave,;
replace pentypeDB8curr=0 if (KJ084==5|KJ084==8); *same job as last wave;



*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDB8curr=1 if KJW001A==1|KJW001A==3;
replace pentypeDB8curr=0 if KJW001A==2; 

*  for plan 2;
replace pentypeDB8curr=1 if KJW001B==1|KJW001B==3;
replace pentypeDB8curr=0 if KJW001B==2; 

*  for plan 3;
replace pentypeDB8curr=1 if KJW001C==1|KJW001C==3;
replace pentypeDB8curr=0 if KJW001C==2;

*  for plan 4;
replace pentypeDB8curr=1 if KJW001D==1|KJW001D==3;
replace pentypeDB8curr=0 if KJW001D==2;


****those who did not change jobs from prev. wave;
*  for plan 1;
replace pentypeDB8curr=1 if KJ272A==1|KJ272A==3;
replace pentypeDB8curr=0 if KJ272A==2; 

*  for plan 2;
replace pentypeDB8curr=1 if KJ272B==1|KJ272B==3;
replace pentypeDB8curr=0 if KJ272B==2; 

*  for plan 3;
replace pentypeDB8curr=1 if KJ272C==1|KJ272C==3;
replace pentypeDB8curr=0 if KJ272C==2; 

*  for plan 4;
replace pentypeDB8curr=1 if KJ272D==1|KJ272D==3;
replace pentypeDB8curr=0 if KJ272D==2;



*****this is for people who changed employers b/w last two waves;
replace pentypeDB8curr=1 if KJ327==1|KJ327==3; 
replace pentypeDB8curr=0 if KJ327==2;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDB8curr=1 if KJ338A==1|KJ338A==3;
replace pentypeDB8curr=0 if KJ338A==2; 

*  for plan 2;
replace pentypeDB8curr=1 if KJ338B==1|KJ338B==3;
replace pentypeDB8curr=0 if KJ338B==2; 

*  for plan 3;
replace pentypeDB8curr=1 if KJ338C==1|KJ338C==3;
replace pentypeDB8curr=0 if KJ338C==2; 

*  for plan 4;
replace pentypeDB8curr=1 if KJ338D==1|KJ338D==3;
replace pentypeDB8curr=0 if KJ338D==2;




******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB8last=0 if (KK031==5|KK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB8last=1 if KKW001A==1|KKW001A==3; 
replace pentypeDB8last=0 if KKW001A==2;

*  for plan 2;
replace pentypeDB8last=1 if KKW001B==1|KKW001B==3; 
replace pentypeDB8last=0 if KKW001B==2;



***imputed last job pension plans: JJ005M1/2/3- wave7 working, KJ005M1/2/3 - Wave 8 retired;
replace pentypeDB8last=1 if (JJ005M1==1|JJ005M2==1|JJ005M3==1) & (KJ005M1==5|KJ005M2==5|KJ005M3==5) & pentypeDB7curr==1;



******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB8prev=0 if (KL027==5|KL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB8prev=0 if (KL031==5|KL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB8prev=1 if KLW001A==1|KLW001A==3; 
replace pentypeDB8prev=0 if KLW001A==2;

* plan 2;
replace pentypeDB8prev=1 if KLW001B==1|KLW001B==3; 
replace pentypeDB8prev=0 if KLW001B==2;

* plan 3;
replace pentypeDB8prev=1 if KLW001C==1|KLW001C==3; 
replace pentypeDB8prev=0 if KLW001C==2;

* plan 4;
replace pentypeDB8prev=1 if KLW001E==1|KLW001E==3; 
replace pentypeDB8prev=0 if KLW001E==2;

* plan 5;
replace pentypeDB8prev=1 if KLW001F==1|KLW001F==3; 
replace pentypeDB8prev=0 if KLW001F==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC8curr=.;
gen pentypeDC8last=.;
gen pentypeDC8prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC8curr=0  if KJ020==5|KJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDC8curr=0 if KJ268==7; * deny being covered by a pension;

******************* 1B: retired, last job--DC*******;
replace pentypeDC8last=0  if KK003==5|KK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC8prev=0  if KL005==5|KL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC8curr=0 if (KJ324==5|KJ324==8);  *those who change jobs from previous wave; 
replace pentypeDC8curr=0 if (KJ084==5|KJ084==8); 


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDC8curr=1 if KJW001A==2|KJW001A==3;
replace pentypeDC8curr=0 if KJW001A==1; 

*  for plan 2;
replace pentypeDC8curr=1 if KJW001B==2|KJW001B==3;
replace pentypeDC8curr=0 if KJW001B==1; 

*  for plan 3;
replace pentypeDC8curr=1 if KJW001C==2|KJW001C==3;
replace pentypeDC8curr=0 if KJW001C==1;

*  for plan 4;
replace pentypeDC8curr=1 if KJW001D==2|KJW001D==3;
replace pentypeDC8curr=0 if KJW001D==1;


****those who did not change jobs from prev. wave;
*  for plan 1;
replace pentypeDC8curr=1 if KJ272A==2|KJ272A==3;
replace pentypeDC8curr=0 if KJ272A==1; 

*  for plan 2;
replace pentypeDC8curr=1 if KJ272B==2|KJ272B==3;
replace pentypeDC8curr=0 if KJ272B==1; 

*  for plan 3;
replace pentypeDC8curr=1 if KJ272C==2|KJ272C==3;
replace pentypeDC8curr=0 if KJ272C==1; 

*  for plan 4;
replace pentypeDC8curr=1 if KJ272D==2|KJ272D==3;
replace pentypeDC8curr=0 if KJ272D==1;



*****this is for people who changed employers b/w last two waves;
replace pentypeDC8curr=1 if KJ327==2|KJ327==3; 
replace pentypeDC8curr=0 if KJ327==1;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDC8curr=1 if KJ338A==2|KJ338A==3;
replace pentypeDC8curr=0 if KJ338A==1; 

*  for plan 2;
replace pentypeDC8curr=1 if KJ338B==2|KJ338B==3;
replace pentypeDC8curr=0 if KJ338B==1; 

*  for plan 3;
replace pentypeDC8curr=1 if KJ338C==2|KJ338C==3;
replace pentypeDC8curr=0 if KJ338C==1; 

*  for plan 4;
replace pentypeDC8curr=1 if KJ338D==2|KJ338D==3;
replace pentypeDC8curr=0 if KJ338D==1;




******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC8last=0 if (KK031==5|KK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC8last=1 if KKW001A==2|KKW001A==3; 
replace pentypeDC8last=0 if KKW001A==1;

*  for plan 2;
replace pentypeDC8last=1 if KKW001B==2|KKW001B==3; 
replace pentypeDC8last=0 if KKW001B==1;



***imputed last job pension plans: JJ005M1/2/3- wave7 working, KJ005M1/2/3 - Wave 6 retired;
replace pentypeDC8last=1 if (JJ005M1==1|JJ005M2==1|JJ005M3==1) & (KJ005M1==5|KJ005M2==5|KJ005M3==5) & pentypeDC7curr==1;





******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC8prev=0 if (KL027==5|KL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC8prev=0 if (KL031==5|KL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC8prev=1 if KLW001A==2|KLW001A==3; 
replace pentypeDC8prev=0 if KLW001A==1;

* plan 2;
replace pentypeDC8prev=1 if KLW001B==2|KLW001B==3; 
replace pentypeDC8prev=0 if KLW001B==1;

* plan 3;
replace pentypeDC8prev=1 if KLW001C==2|KLW001C==3; 
replace pentypeDC8prev=0 if KLW001C==1;

* plan 4;
replace pentypeDC8prev=1 if KLW001E==2|KLW001E==3; 
replace pentypeDC8prev=0 if KLW001E==1;

* plan 5;
replace pentypeDC8prev=1 if KLW001F==2|KLW001F==3; 
replace pentypeDC8prev=0 if KLW001F==1;




************************************************************************************;
****************************now calculate pension wealth;

*current;

replace KJW002A=0 if (KJW002A==.|KJW002A>9900000|KJW002A<0); *amount in accout presently;
replace KJW002B=0 if (KJW002B==.|KJW002B>9900000|KJW002B<0); 
replace KJW002C=0 if (KJW002C==.|KJW002C>9900000|KJW002C<0); 
replace KJW002D=0 if (KJW002D==.|KJW002D>9900000|KJW002D<0); 

replace KJ273A=0 if (KJ273A==.| KJ273A>9900000|KJ273A<0); *amount in accout presently;
replace KJ273B=0 if (KJ273B==.| KJ273B>9900000|KJ273B<0); 
replace KJ273C=0 if (KJ273C==.| KJ273C>9900000|KJ273C<0); 
replace KJ273D=0 if (KJ273D==.| KJ273D>9900000|KJ273D<0); 

replace KJ307A=0 if (KJ307A==.| KJ307A>9900000|KJ307A<0); *amount in accout presently;
replace KJ307B=0 if (KJ307B==.| KJ307B>9900000|KJ307B<0); 
replace KJ307C=0 if (KJ307C==.| KJ307C>9900000|KJ307C<0); 
replace KJ307D=0 if (KJ307D==.| KJ307D>9900000|KJ307D<0); 

replace KJ339A=0 if (KJ339A==.| KJ339A>9900000|KJ339A<0); *amount in accout presently;
replace KJ339B=0 if (KJ339B==.| KJ339B>9900000|KJ339B<0); 
replace KJ339C=0 if (KJ339C==.| KJ339C>9900000|KJ339C<0); 
replace KJ339D=0 if (KJ339D==.| KJ339D>9900000|KJ339D<0); 

replace KJ413A=0 if (KJ413A==.| KJ413A>9900000|KJ413A<0); *amount in accout presently;
replace KJ413B=0 if (KJ413B==.| KJ413B>9900000|KJ413B<0); 
replace KJ413C=0 if (KJ413C==.| KJ413C>9900000|KJ413C<0); 
replace KJ413D=0 if (KJ413D==.| KJ413D>9900000|KJ413D<0); 


gen penwDC8curr=KJW002A+KJW002B+KJW002C+KJW002D+KJ273A+KJ273B+KJ273C+KJ273D+KJ307A+KJ307B+KJ307C+KJ307D+KJ339A+KJ339B+KJ339C+KJ339D+KJ413A+KJ413B+KJ413C+KJ413D;
replace penwDC8curr=0 if penwDC8curr==.;


***********last;
*User's note from Codebook: "up to three responses allowed";
replace KKW009A=0 if (KKW009A==.| KKW009A>9900000); *COMBO amount in accout NOW;
replace KKW009B=0 if (KKW009B==.| KKW009B>9900000); 

replace KKW009A=0 if KKW006A1~=3; 
replace KKW009B=0 if KKW006B~=3;


gen penwDC8last=KKW009A+KKW009B;
replace penwDC8last=0 if penwDC8last==.;
replace penwDC8last=penwDC7last if (penwDC8last==0 & penwDC7last~=.);



**********prev;

replace KLW009A=0 if (KLW009A==.| KLW009A>9900000); *COMBO - amount in accout NOW;
replace KLW009B=0 if (KLW009B==.| KLW009B>9900000);
replace KLW009C=0 if (KLW009C==.| KLW009C>9900000);
replace KLW009E=0 if (KLW009E==.| KLW009E>9900000);
replace KLW009F=0 if (KLW009F==.| KLW009F>9900000);
replace KLW009A=0 if KLW006A1~=3;
replace KLW009B=0 if KLW006B1~=3;
replace KLW009C=0 if KLW006C1~=3;
replace KLW009E=0 if KLW006E1~=3;
replace KLW009F=0 if KLW006F1~=3;

gen penwDC8prev=KLW009A+KLW009B+KLW009C+KLW009E+KLW009F;
replace penwDC8prev=0 if penwDC8prev==.;
replace penwDC8prev=penwDC7prev if (penwDC8prev==0 & penwDC7prev~=.);



gen penwDC8=penwDC8curr+penwDC8last+penwDC8prev;



***************tenure******************;
replace KK004=0 if KK004==9998|KK004==9999;  *DK, RF;
replace KK022=0 if KK022==9998|KK022==9999;  *DK, RF;
gen tenurelast8=KK004-KK022 if KK004>KK022 & KK022~=0 ;  *year last worked - year started working;

replace KL016=0 if KL016==9998|KL016==9999;  *DK, RF;
replace KL009=0 if KL009==9998|KL009==9999;  *DK, RF;
gen tenureprev8=KL016-KL009 if KL016>KL009 & KL009~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast8= KK015 if KK016==6; *how much earning, if salary is per year;
replace earnlast8=KK015*(KK014/4) if KK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast8=KK015*(KK014/2) if KK016==3|KK016==5; * salary is bi-weekly;
replace earnlast8=KK015*(KK014) if KK016==2; *salary is weekly;
replace earnlast8=(KK015*KK014*KK011) if KK016==1; *earn*weeks worked*hrs a week if hourly;

replace earnlast8=. if KK011>997;
replace earnlast8=. if KK014>97;
replace earnlast8=. if  KK015>99999999000;
************* hourly wages******************;
gen wagelast8=earnlast8/(KK011*KK014); *earn/(hrs a week*weeks worked);


****************yearly earnings on prev job**************;
gen earnprev8= KL022 if KL023==6;
replace earnprev8=KL022*(KL021/4) if KL023==4;
replace earnprev8=KL022*(KL021/2) if KL023==3|KL023==5;                         //made a change here as well
replace earnprev8=KL022*(KL021) if KL023==2;
replace earnprev8=(KL022*KL021*KL020) if KL023==1;


replace earnprev8=.  if KL020>997;                                              //drop top codes for hours worked per week  
replace earnprev8=.  if KL021>97;                                               //drop top codes for weeks worked per year
replace earnprev8=.  if KL022>999999000;                                        //drop top codes for earnings
************* hourly wages******************;
gen wageprev8=earnprev8/(KL020*KL021); *earn/(hrs a week*weeks worked);


*************** earliest age to still receive benefits ************;

* for pension plan 1;
gen peneage8=KJ383A;
replace peneage8=35 if KJ383A==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
replace peneage8=. if peneage8>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage8=KJ383B if peneage8~=. & KJ383B~=. & peneage8>KJ383B; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage8=KJ383B if peneage8==.;
replace peneage8=. if peneage8>95; 
replace peneage8=35 if KJ383B==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage8=KJ383C if peneage8~=. & KJ383C~=. & peneage8>KJ383C; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace peneage8=KJ383C if peneage8==.;
replace peneage8=. if peneage8>95; 
replace peneage8=35 if KJ383C==95; * access pension benefits anytime;

* for pension plan 4;
replace peneage8=KJ383D if peneage8~=. & KJ383D~=. & peneage8>KJ383D; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace peneage8=KJ383D if peneage8==.;
replace peneage8=. if peneage8>95; 
replace peneage8=35 if KJ383D==95; * access pension benefits anytime;


************************************ age to receive full benefits *****************************;


* for pension plan 1;
gen pennage8=KJ367A;
replace pennage8=35 if pennage8==95;* access pension benefits anytime;
replace pennage8=. if pennage8>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage8=KJ367B if pennage8~=. & KJ367B~=. & pennage8>KJ367B; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage8=KJ367B if pennage8==.;
replace pennage8=. if pennage8>95; 
replace pennage8=35 if KJ367B==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage8=KJ367C if pennage8~=. & KJ367C~=. & pennage8>KJ367C; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace pennage8=KJ367C if pennage8==.;
replace pennage8=. if pennage8>95; 
replace pennage8=35 if KJ367C==95; * access pension benefits anytime;

* for pension plan 4;
replace pennage8=KJ367D if pennage8~=. & KJ367D~=. & pennage8>KJ367D; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace pennage8=KJ367D if pennage8==.;
replace pennage8=. if pennage8>95; 
replace pennage8=35 if KJ367D==95; * access pension benefits anytime;


keep pen* ten* peneage8 pennage8 HHID PN same_pen8 earn* wage*; 
sort HHID PN;
merge HHID PN using `saved'pension; 

drop _merge; 
summ pentypeDB8* pentypeDC8* peneage8 pennage8;
sort pentypeDB8curr;
by pentypeDB8curr: summ pennage8 peneage8 pentypeDB8curr;

replace pentypeDB8curr=pentypeDB7curr if same_pen8==1 & pentypeDB7curr~=. & pentypeDB8curr==0;
replace pentypeDC8curr=pentypeDC7curr if same_pen8==1 & pentypeDC7curr~=. & pentypeDC8curr==0 ;
replace peneage8=peneage7 if same_pen8==1 & peneage7~=. & peneage8==.;
replace pennage8=pennage7 if same_pen8==1 & pennage7~=. & pennage8==.;

summ pentypeDB8curr pentypeDC8curr peneage8 pennage8;
sort pentypeDB8curr;
by pentypeDB8curr: summ pennage8 peneage8 pentypeDB8curr;

sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 

*************************************************************************************;
************************************************************* WAVE 9   **************;

clear;
*set mem 400m;
use `wave8d'H06J_R;***to know whether or not a person worked in wave8***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave9d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave8;
sort HHID PN; 
merge HHID PN using `wave9d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave9d'temp, replace;
clear;


*set mem 400m;
use `wave9d'H08J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave9d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave9d'temp, replace;
clear;

*set mem 400m;
use `wave9d'H08K_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave9d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave9d'temp, replace;
clear;

*set mem 400m;
use `wave9d'H08L_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave9d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave9d'temp, replace;



*********** variable same_pen9 ***********;

gen same_pen9=0;
replace same_pen9=1 if LJ945_1==5|LJ945_1==8|LJ945_2==5|LJ945_2==8|LJ945_3==5|LJ945_3==8|LJ945_4==5|LJ945_4==8; * No changes from the last way. * LJ945_1==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen9;



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB9curr=.;
gen pentypeDB9last=.;
gen pentypeDB9prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB9curr=0  if LJ020==5|LJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDB9curr=0 if LJ945_1==7|LJ945_2==7|LJ945_3==7|LJ945_4==7; * deny being covered by a pension;

******************* 1B: retired, last job--DB*******;
replace pentypeDB9last=0  if LK003==5|LK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB9prev=0  if LL005==5|LL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB9curr=0 if (LJ324==5|LJ324==8);  *those who change jobs from previous wave,;
replace pentypeDB9curr=0 if (LJ084==5|LJ084==8); *same job as last wave;



*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDB9curr=1 if LJW001A==1|LJW001A==3;
replace pentypeDB9curr=0 if LJW001A==2; 

*  for plan 2;
replace pentypeDB9curr=1 if LJW001B==1|LJW001B==3;
replace pentypeDB9curr=0 if LJW001B==2; 

*  for plan 3;
replace pentypeDB9curr=1 if LJW001C==1|LJW001C==3;
replace pentypeDB9curr=0 if LJW001C==2;

*  for plan 4;
replace pentypeDB9curr=1 if LJW001D==1|LJW001D==3;
replace pentypeDB9curr=0 if LJW001D==2;





*****this is for people who changed employers b/w last two waves;
replace pentypeDB9curr=1 if LJ327==1|LJ327==3; 
replace pentypeDB9curr=0 if LJ327==2;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDB9curr=1 if LJ338_1==1|LJ338_1==3;
replace pentypeDB9curr=0 if LJ338_1==2; 

*  for plan 2;
replace pentypeDB9curr=1 if LJ338_2==1|LJ338_2==3;
replace pentypeDB9curr=0 if LJ338_2==2; 

*  for plan 3;
replace pentypeDB9curr=1 if LJ338_3==1|LJ338_3==3;
replace pentypeDB9curr=0 if LJ338_3==2; 

*  for plan 4;
replace pentypeDB9curr=1 if LJ338_4==1|LJ338_4==3;
replace pentypeDB9curr=0 if LJ338_4==2;




******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB9last=0 if (LK031==5|LK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB9last=1 if LKW001a==1|LKW001a==3; 
replace pentypeDB9last=0 if LKW001a==2;

*  for plan 2;
replace pentypeDB9last=1 if LKW001b==1|LKW001b==3; 
replace pentypeDB9last=0 if LKW001b==2;

*  for plan 3;
replace pentypeDB9last=1 if LKW001c==1|LKW001c==3; 
replace pentypeDB9last=0 if LKW001c==2;

*  for plan 4;
replace pentypeDB9last=1 if LKW001d==1|LKW001d==3; 
replace pentypeDB9last=0 if LKW001d==2;

***imputed last job pension plans: KJ005M1/2/3- wave8 working, LJ005M1/2/3 - Wave 9 retired;
replace pentypeDB9last=1 if (KJ005M1==1|KJ005M2==1|KJ005M3==1) & (LJ005M1==5|LJ005M2==5|LJ005M3==5) & pentypeDB8curr==1;



******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB9prev=0 if (LL027==5|LL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB9prev=0 if (LL031==5|LL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB9prev=1 if LLW001A==1|LLW001A==3; 
replace pentypeDB9prev=0 if LLW001A==2;

* plan 2;
replace pentypeDB9prev=1 if LLW001B==1|LLW001B==3; 
replace pentypeDB9prev=0 if LLW001B==2;

* plan 3;
replace pentypeDB9prev=1 if LLW001C==1|LLW001C==3; 
replace pentypeDB9prev=0 if LLW001C==2;

* plan 4;
replace pentypeDB9prev=1 if LLW001D==1|LLW001D==3; 
replace pentypeDB9prev=0 if LLW001D==2;

* plan 5;
replace pentypeDB9prev=1 if LLW001E==1|LLW001E==3; 
replace pentypeDB9prev=0 if LLW001E==2;

* plan 6;
replace pentypeDB9prev=1 if LLW001F==1|LLW001F==3; 
replace pentypeDB9prev=0 if LLW001F==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC9curr=.;
gen pentypeDC9last=.;
gen pentypeDC9prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC9curr=0  if LJ020==5|LJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDC9curr=0 if LJ945_1==7|LJ945_2==7|LJ945_3==7|LJ945_4==7; * deny being covered by a pension;

******************* 1B: retired, last job--DC*******;
replace pentypeDC9last=0  if LK003==5|LK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC9prev=0  if LL005==5|LL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC9curr=0 if (LJ324==5|LJ324==8);  *those who change jobs from previous wave; 
replace pentypeDC9curr=0 if (LJ084==5|LJ084==8); 


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDC9curr=1 if LJW001A==2|LJW001A==3;
replace pentypeDC9curr=0 if LJW001A==1; 

*  for plan 2;
replace pentypeDC9curr=1 if LJW001B==2|LJW001B==3;
replace pentypeDC9curr=0 if LJW001B==1; 

*  for plan 3;
replace pentypeDC9curr=1 if LJW001C==2|LJW001C==3;
replace pentypeDC9curr=0 if LJW001C==1;

*  for plan 4;
replace pentypeDC9curr=1 if LJW001D==2|LJW001D==3;
replace pentypeDC9curr=0 if LJW001D==1;



*****this is for people who changed employers b/w last two waves;
replace pentypeDC9curr=1 if LJ327==2|LJ327==3; 
replace pentypeDC9curr=0 if LJ327==1;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDC9curr=1 if LJ338_1==2|LJ338_1==3;
replace pentypeDC9curr=0 if LJ338_1==1; 

*  for plan 2;
replace pentypeDC9curr=1 if LJ338_2==2|LJ338_2==3;
replace pentypeDC9curr=0 if LJ338_2==1; 

*  for plan 3;
replace pentypeDC9curr=1 if LJ338_3==2|LJ338_3==3;
replace pentypeDC9curr=0 if LJ338_3==1; 

*  for plan 4;
replace pentypeDC9curr=1 if LJ338_4==2|LJ338_4==3;
replace pentypeDC9curr=0 if LJ338_4==1;




******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC9last=0 if (LK031==5|LK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC9last=1 if LKW001a==2|LKW001a==3; 
replace pentypeDC9last=0 if LKW001a==1;

*  for plan 2;
replace pentypeDC9last=1 if LKW001b==2|LKW001b==3; 
replace pentypeDC9last=0 if LKW001b==1;

*  for plan 3;
replace pentypeDC9last=1 if LKW001c==2|LKW001c==3; 
replace pentypeDC9last=0 if LKW001c==1;

*  for plan 3;
replace pentypeDC9last=1 if LKW001d==2|LKW001d==3; 
replace pentypeDC9last=0 if LKW001d==1;



***imputed last job pension plans: KJ005M1/2/3- wave8 working, LJ005M1/2/3 - Wave 6 retired;
replace pentypeDC9last=1 if (KJ005M1==1|KJ005M2==1|KJ005M3==1) & (LJ005M1==5|LJ005M2==5|LJ005M3==5) & pentypeDC8curr==1;





******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC9prev=0 if (LL027==5|LL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC9prev=0 if (LL031==5|LL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC9prev=1 if LLW001A==2|LLW001A==3; 
replace pentypeDC9prev=0 if LLW001A==1;

* plan 2;
replace pentypeDC9prev=1 if LLW001B==2|LLW001B==3; 
replace pentypeDC9prev=0 if LLW001B==1;

* plan 3;
replace pentypeDC9prev=1 if LLW001C==2|LLW001C==3; 
replace pentypeDC9prev=0 if LLW001C==1;

* plan 4;
replace pentypeDC9prev=1 if LLW001D==2|LLW001D==3; 
replace pentypeDC9prev=0 if LLW001D==1;

* plan 5;
replace pentypeDC9prev=1 if LLW001E==2|LLW001E==3; 
replace pentypeDC9prev=0 if LLW001E==1;

* plan 6;
replace pentypeDC9prev=1 if LLW001F==2|LLW001F==3; 
replace pentypeDC9prev=0 if LLW001F==1;




************************************************************************************;
****************************now calculate pension wealth;

*current;

replace LJW002A=0 if (LJW002A==.|LJW002A>9900000); *amount in accout presently;
replace LJW002B=0 if (LJW002B==.|LJW002B>9900000); 
replace LJW002C=0 if (LJW002C==.|LJW002C>9900000); 
replace LJW002D=0 if (LJW002D==.|LJW002D>9900000); 


replace LJ413_1=0 if (LJ413_1==.| LJ413_1>9900000); *amount in accout presently;
replace LJ413_2=0 if (LJ413_2==.| LJ413_2>9900000); 
replace LJ413_3=0 if (LJ413_3==.| LJ413_3>9900000); 
replace LJ413_4=0 if (LJ413_4==.|LJ413_4>9900000); 

gen penwDC9curr=LJW002A+LJW002B+LJW002C+LJW002D+LJ413_1+LJ413_2+LJ413_3+LJ413_4;
replace penwDC9curr=0 if penwDC9curr==.;


***********last;
*User's note from Codebook: "up to three responses allowed";
replace LKW009a=0 if (LKW009a==.| LKW009a>9900000); *COMBO amount in accout NOW;
replace LKW009b=0 if (LKW009b==.| LKW009b>9900000); 
replace LKW009c=0 if (LKW009c==.| LKW009c>9900000);
replace LKW009d=0 if (LKW009d==.| LKW009d>9900000);

replace LKW009a=0 if LKW097a1~=3; 
replace LKW009b=0 if LKW097b1~=3;
replace LKW009c=0 if LKW097c1~=3; 
replace LKW009d=0 if LKW097d1~=3;

gen penwDC9last=LKW009a+LKW009b+LKW009c+LKW009d;
replace penwDC9last=0 if penwDC9last==.;
replace penwDC9last=penwDC8last if (penwDC9last==0 & penwDC8last~=.);



**********prev;

replace LLW009A=0 if (LLW009A==.| LLW009A>9900000); *COMBO - amount in accout NOW;
replace LLW009B=0 if (LLW009B==.| LLW009B>9900000);
replace LLW009C=0 if (LLW009C==.| LLW009C>9900000);
replace LLW009D=0 if (LLW009D==.| LLW009D>9900000);
replace LLW009E=0 if (LLW009E==.| LLW009E>9900000);
replace LLW009F=0 if (LLW009F==.| LLW009F>9900000);
replace LLW009A=0 if LLW097AM1~=3;
replace LLW009B=0 if LLW097BM1~=3;
replace LLW009C=0 if LLW097CM1~=3;
replace LLW009D=0 if LLW097CM1~=3;
replace LLW009E=0 if LLW097EM1~=3;
replace LLW009F=0 if LLW097FM1~=3;

gen penwDC9prev=LLW009A+LLW009B+LLW009C+LLW009D+LLW009E+LLW009F;
replace penwDC9prev=0 if penwDC9prev==.;
replace penwDC9prev=penwDC8prev if (penwDC9prev==0 & penwDC8prev~=.);



gen penwDC9=penwDC9curr+penwDC9last+penwDC9prev;



***************tenure******************;
replace LK004=0 if LK004==9998|LK004==9999;  *DK, RF;
replace LK022=0 if LK022==9998|LK022==9999;  *DK, RF;
gen tenurelast9=LK004-LK022 if LK004>LK022 & LK022~=0 ;  *year last worked - year started working;

replace LL016=0 if LL016==9998|LL016==9999;  *DK, RF;
replace LL009=0 if LL009==9998|LL009==9999;  *DK, RF;
gen tenureprev9=LL016-LL009 if LL016>LL009 & LL009~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast9= LK015 if LK016==6; *how much earning, if salary is per year;
replace earnlast9=LK015*(LK014/4) if LK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast9=LK015*(LK014/2) if LK016==3|LK016==5; * salary is bi-weeLLy;
replace earnlast9=LK015*(LK014) if LK016==2; *salary is weeLLy;
replace earnlast9=(LK015*LK014*LK011) if LK016==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast9=. if LK011>997;
replace earnlast9=. if LK014>97;
replace earnlast9=. if LK015>9999000;
************* hourly wages******************;
gen wagelast9=earnlast9/(LK011*LK014); *earn/(hrs a week*weeks worked);




****************yearly earnings on prev job**************;
gen earnprev9= LL022 if LL023==6;
replace earnprev9=LL022*(LL021/4) if LL023==4;
replace earnprev9=LL022*(LL021/2) if LL023==3|LL023==5;                         //changed this as well
replace earnprev9=LL022*(LL021) if LL023==2;
replace earnprev9=(LL022*LL021*LL020) if LL023==1;

replace earnprev9=.  if LL020>997;                                              //drop top codes for hours worked per week  
replace earnprev9=.  if LL021>97;                                               //drop top codes for weeks worked per year
replace earnprev9=.  if LL022>999999000;                                        //drop top codes for earnings
************* hourly wages******************;
gen wageprev9=earnprev9/(LL020*LL021); *earn/(hrs a week*weeks worked);



*************** earliest age to still receive benefits ************;

* for pension plan 1;
gen peneage9=LJ383_1;
replace peneage9=35 if LJ383_1==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
replace peneage9=. if peneage9>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage9=LJ383_2 if peneage9~=. & LJ383_2~=. & peneage9>LJ383_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage9=LJ383_2 if peneage9==.;
replace peneage9=. if peneage9>95; 
replace peneage9=35 if LJ383_2==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage9=LJ383_3 if peneage9~=. & LJ383_3~=. & peneage9>LJ383_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace peneage9=LJ383_3 if peneage9==.;
replace peneage9=. if peneage9>95; 
replace peneage9=35 if LJ383_3==95; * access pension benefits anytime;

* for pension plan 4;
replace peneage9=LJ383_4 if peneage9~=. & LJ383_4~=. & peneage9>LJ383_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace peneage9=LJ383_4 if peneage9==.;
replace peneage9=. if peneage9>95; 
replace peneage9=35 if LJ383_4==95; * access pension benefits anytime;


************************************ age to receive full benefits *****************************;


* for pension plan 1;
gen pennage9=LJ367_1;
replace pennage9=35 if pennage9==95;* access pension benefits anytime;
replace pennage9=. if pennage9>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage9=LJ367_2 if pennage9~=. & LJ367_2~=. & pennage9>LJ367_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage9=LJ367_2 if pennage9==.;
replace pennage9=. if pennage9>95; 
replace pennage9=35 if LJ367_2==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage9=LJ367_3 if pennage9~=. & LJ367_3~=. & pennage9>LJ367_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace pennage9=LJ367_3 if pennage9==.;
replace pennage9=. if pennage9>95; 
replace pennage9=35 if LJ367_3==95; * access pension benefits anytime;

* for pension plan 4;
replace pennage9=LJ367_4 if pennage9~=. & LJ367_4~=. & pennage9>LJ367_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace pennage9=LJ367_4 if pennage9==.;
replace pennage9=. if pennage9>95; 
replace pennage9=35 if LJ367_4==95; * access pension benefits anytime;


keep pen* ten* peneage9 pennage9 HHID PN same_pen9 earn* wage*; 
sort HHID PN;
merge HHID PN using `saved'pension; 

drop _merge; 
summ pentypeDB9* pentypeDC9* peneage9 pennage9;
sort pentypeDB9curr;
by pentypeDB9curr: summ pennage9 peneage9 pentypeDB9curr;

replace pentypeDB9curr=pentypeDB8curr if same_pen9==1 & pentypeDB8curr~=. & pentypeDB9curr==0;
replace pentypeDC9curr=pentypeDC8curr if same_pen9==1 & pentypeDC8curr~=. & pentypeDC9curr==0 ;
replace peneage9=peneage8 if same_pen9==1 & peneage8~=. & peneage9==.;
replace pennage9=pennage8 if same_pen9==1 & pennage8~=. & pennage9==.;

summ pentypeDB9curr pentypeDC9curr peneage9 pennage9;
sort pentypeDB9curr;
by pentypeDB9curr: summ pennage9 peneage9 pentypeDB9curr;

sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 



*************************************************************************************;
************************************************************* WAVE 10   **************;

clear;
*set mem 400m;
use `wave9d'H08J_R;***to know whether or not a person worked in wave9***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave10d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave9;
sort HHID PN; 
merge HHID PN using `wave10d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave10d'temp, replace;
clear;


*set mem 400m;
use `wave10d'H10J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave10d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave10d'temp, replace;
clear;

*set mem 400m;
use `wave10d'H10K_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave10d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave10d'temp, replace;
clear;

*set mem 400m;
use `wave10d'H10L_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave10d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave10d'temp, replace;



*********** variable same_pen10 ***********;

gen same_pen10=0;
replace same_pen10=1 if MJ945_1==5|MJ945_1==8|MJ945_2==5|MJ945_2==8|MJ945_3==5|MJ945_3==8|MJ945_4==5|MJ945_4==8; * No changes from the last way. * MJ945_1==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen10;



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB10curr=.;
gen pentypeDB10last=.;
gen pentypeDB10prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB10curr=0  if MJ020==5|MJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDB10curr=0 if MJ945_1==7|MJ945_2==7|MJ945_3==7|MJ945_4==7; * deny being covered by a pension;

******************* 1B: retired, last job--DB*******;
replace pentypeDB10last=0  if MK003==5|MK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB10prev=0  if ML005==5|ML005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB10curr=0 if (MJ848==5|MJ848==8|MJ849==5|MJ849==8);  *those who change jobs from previous wave,; //replace with MJ848&849?;
replace pentypeDB10curr=0 if (MJ084==5|MJ084==8); *same job as last wave;



*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDB10curr=1 if MJW001A==1|MJW001A==3;
replace pentypeDB10curr=0 if MJW001A==2; 

*  for plan 2;
replace pentypeDB10curr=1 if MJW001B==1|MJW001B==3;
replace pentypeDB10curr=0 if MJW001B==2; 

*  for plan 3;
replace pentypeDB10curr=1 if MJW001C==1|MJW001C==3;
replace pentypeDB10curr=0 if MJW001C==2;

*  for plan 4;
replace pentypeDB10curr=1 if MJW001D==1|MJW001D==3;
replace pentypeDB10curr=0 if MJW001D==2;





*****this is for people who changed employers b/w last two waves;
replace pentypeDB10curr=1 if MJ327==1|MJ327==3; 
replace pentypeDB10curr=0 if MJ327==2;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDB10curr=1 if MJ338_1==1|MJ338_1==3;
replace pentypeDB10curr=0 if MJ338_1==2; 

*  for plan 2;
replace pentypeDB10curr=1 if MJ338_2==1|MJ338_2==3;
replace pentypeDB10curr=0 if MJ338_2==2; 

*  for plan 3;
replace pentypeDB10curr=1 if MJ338_3==1|MJ338_3==3;
replace pentypeDB10curr=0 if MJ338_3==2; 

*  for plan 4;
replace pentypeDB10curr=1 if MJ338_4==1|MJ338_4==3;
replace pentypeDB10curr=0 if MJ338_4==2;




******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB10last=0 if (MK031==5|MK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB10last=1 if MKW001A==1|MKW001A==3; 
replace pentypeDB10last=0 if MKW001A==2;

*  for plan 2;
replace pentypeDB10last=1 if MKW001B==1|MKW001B==3; 
replace pentypeDB10last=0 if MKW001B==2;

*  for plan 3;
replace pentypeDB10last=1 if MKW001C==1|MKW001C==3; 
replace pentypeDB10last=0 if MKW001C==2;

*  for plan 4;
replace pentypeDB10last=1 if MKW001D==1|MKW001D==3; 
replace pentypeDB10last=0 if MKW001D==2;

***imputed last job pension plans: LJ005M1/2/3/4- wave9 working, MJ005M1/2/3/4 - Wave 10 retired;
replace pentypeDB10last=1 if (LJ005M1==1|LJ005M2==1|LJ005M3==1|LJ005M4==1) & (MJ005M1==5|MJ005M2==5|MJ005M3==5|MJ005M4==5) & pentypeDB9curr==1;



******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB10prev=0 if (ML027==5|ML027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB10prev=0 if (ML031==5|ML031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB10prev=1 if MLW001A==1|MLW001A==3; 
replace pentypeDB10prev=0 if MLW001A==2;

* plan 2;
replace pentypeDB10prev=1 if MLW001B==1|MLW001B==3; 
replace pentypeDB10prev=0 if MLW001B==2;

* plan 3;
replace pentypeDB10prev=1 if MLW001C==1|MLW001C==3; 
replace pentypeDB10prev=0 if MLW001C==2;

* plan 4;
replace pentypeDB10prev=1 if MLW001D==1|MLW001D==3; 
replace pentypeDB10prev=0 if MLW001D==2;

* plan 5;
replace pentypeDB10prev=1 if MLW001E==1|MLW001E==3; 
replace pentypeDB10prev=0 if MLW001E==2;

* plan 6;
replace pentypeDB10prev=1 if MLW001F==1|MLW001F==3; 
replace pentypeDB10prev=0 if MLW001F==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC10curr=.;
gen pentypeDC10last=.;
gen pentypeDC10prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC10curr=0  if MJ020==5|MJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
replace pentypeDC10curr=0 if MJ945_1==7|MJ945_2==7|MJ945_3==7|MJ945_4==7; * deny being covered by a pension;

******************* 1B: retired, last job--DC*******;
replace pentypeDC10last=0  if MK003==5|MK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC10prev=0  if ML005==5|ML005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC10curr=0 if (MJ848==5|MJ848==8|MJ849==5|MJ849==8);  *those who change jobs from previous wave; 
replace pentypeDC10curr=0 if (MJ084==5|MJ084==8); 


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
replace pentypeDC10curr=1 if MJW001A==2|MJW001A==3;
replace pentypeDC10curr=0 if MJW001A==1; 

*  for plan 2;
replace pentypeDC10curr=1 if MJW001B==2|MJW001B==3;
replace pentypeDC10curr=0 if MJW001B==1; 

*  for plan 3;
replace pentypeDC10curr=1 if MJW001C==2|MJW001C==3;
replace pentypeDC10curr=0 if MJW001C==1;

*  for plan 4;
replace pentypeDC10curr=1 if MJW001D==2|MJW001D==3;
replace pentypeDC10curr=0 if MJW001D==1;



*****this is for people who changed employers b/w last two waves;
replace pentypeDC10curr=1 if MJ327==2|MJ327==3; 
replace pentypeDC10curr=0 if MJ327==1;


*****pension plans have been changed, or YES to Are you included in any pen.plan?;
*  for plan 1;
replace pentypeDC10curr=1 if MJ338_1==2|MJ338_1==3;
replace pentypeDC10curr=0 if MJ338_1==1; 

*  for plan 2;
replace pentypeDC10curr=1 if MJ338_2==2|MJ338_2==3;
replace pentypeDC10curr=0 if MJ338_2==1; 

*  for plan 3;
replace pentypeDC10curr=1 if MJ338_3==2|MJ338_3==3;
replace pentypeDC10curr=0 if MJ338_3==1; 

*  for plan 4;
replace pentypeDC10curr=1 if MJ338_4==2|MJ338_4==3;
replace pentypeDC10curr=0 if MJ338_4==1;




******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC10last=0 if (MK031==5|MK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC10last=1 if MKW001A==2|MKW001A==3; 
replace pentypeDC10last=0 if MKW001A==1;

*  for plan 2;
replace pentypeDC10last=1 if MKW001B==2|MKW001B==3; 
replace pentypeDC10last=0 if MKW001B==1;

*  for plan 3;
replace pentypeDC10last=1 if MKW001C==2|MKW001C==3; 
replace pentypeDC10last=0 if MKW001C==1;

*  for plan 3;
replace pentypeDC10last=1 if MKW001D==2|MKW001D==3; 
replace pentypeDC10last=0 if MKW001D==1;



***imputed last job pension plans: KJ005M1/2/3- wave9 working, LJ005M1/2/3 - Wave 10 retired;
replace pentypeDC10last=1 if (LJ005M1==1|LJ005M2==1|LJ005M3==1|LJ005M4==1) & (MJ005M1==5|MJ005M2==5|MJ005M3==5|MJ005M4==5) & pentypeDC9curr==1;





******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC10prev=0 if (ML027==5|ML027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC10prev=0 if (ML031==5|ML031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC10prev=1 if MLW001A==2|MLW001A==3; 
replace pentypeDC10prev=0 if MLW001A==1;

* plan 2;
replace pentypeDC10prev=1 if MLW001B==2|MLW001B==3; 
replace pentypeDC10prev=0 if MLW001B==1;

* plan 3;
replace pentypeDC10prev=1 if MLW001C==2|MLW001C==3; 
replace pentypeDC10prev=0 if MLW001C==1;

* plan 4;
replace pentypeDC10prev=1 if MLW001D==2|MLW001D==3; 
replace pentypeDC10prev=0 if MLW001D==1;

* plan 5;
replace pentypeDC10prev=1 if MLW001E==2|MLW001E==3; 
replace pentypeDC10prev=0 if MLW001E==1;

* plan 6;
replace pentypeDC10prev=1 if MLW001F==2|MLW001F==3; 
replace pentypeDC10prev=0 if MLW001F==1;




************************************************************************************;
****************************now calculate pension wealth;

*current;

replace MJW002A=0 if (MJW002A==.|MJW002A>9900000); *amount in account presently;
replace MJW002B=0 if (MJW002B==.|MJW002B>9900000); 
replace MJW002C=0 if (MJW002C==.|MJW002C>9900000); 
replace MJW002D=0 if (MJW002D==.|MJW002D>9900000); 


replace MJ413_1=0 if (MJ413_1==.| MJ413_1>9900000); *amount in account presently;
replace MJ413_2=0 if (MJ413_2==.| MJ413_2>9900000); 
replace MJ413_3=0 if (MJ413_3==.| MJ413_3>9900000); 
replace MJ413_4=0 if (MJ413_4==.| MJ413_4>9900000); 

gen penwDC10curr=MJW002A+MJW002B+MJW002C+MJW002D+MJ413_1+MJ413_2+MJ413_3+MJ413_4;
replace penwDC10curr=0 if penwDC10curr==.;


***********last;
*User's note from Codebook: "up to three responses allowed";
replace MKW009A=0 if (MKW009A==.| MKW009A>990000); *COMBO amount in accout NOW; //check error codes;
replace MKW009B=0 if (MKW009B==.| MKW009B>990000); 
replace MKW009C=0 if (MKW009C==.| MKW009C>990000);
replace MKW009D=0 if (MKW009D==.| MKW009D>990000);

replace MKW009A=0 if MKW097AM1~=3 & MKW097AM2~=3 & MKW097AM3~=3; //check number of W097 Qs for A-D;
replace MKW009B=0 if MKW097BM1~=3 & MKW097BM2~=3;
replace MKW009C=0 if MKW097CM1~=3 & MKW097CM2~=3; 
replace MKW009D=0 if MKW097DM1~=3 & MKW097DM2~=3;

gen penwDC10last=MKW009A+MKW009B+MKW009C+MKW009D;
replace penwDC10last=0 if penwDC10last==.;
replace penwDC10last=penwDC9last if (penwDC10last==0 & penwDC9last~=.);




**********prev;

replace MLW009A=0 if (MLW009A==.| MLW009A>9900000); *COMBO - amount in accout NOW;
replace MLW009B=0 if (MLW009B==.| MLW009B>9900000);
replace MLW009C=0 if (MLW009C==.| MLW009C>9900000);
replace MLW009D=0 if (MLW009D==.| MLW009D>9900000);
replace MLW009E=0 if (MLW009E==.| MLW009E>9900000);
replace MLW009F=0 if (MLW009F==.| MLW009F>9900000);
replace MLW009A=0 if MLW097AM1~=3 & MLW097AM2~=3 & MLW097AM3~=3; //check number of W097 Q's for A-F
replace MLW009B=0 if MLW097BM1~=3 & MLW097BM2~=3 & MLW097BM3~=3;
replace MLW009C=0 if MLW097CM1~=3 & MLW097CM2~=3 & MLW097CM3~=3;
replace MLW009D=0 if MLW097DM1~=3;
replace MLW009E=0 if MLW097EM1~=3 & MLW097EM2~=3;
replace MLW009F=0 if MLW097FM1~=3 & MLW097FM2~=3;

gen penwDC10prev=MLW009A+MLW009B+MLW009C+MLW009D+MLW009E+MLW009F;
replace penwDC10prev=0 if penwDC10prev==.;
replace penwDC10prev=penwDC9prev if (penwDC10prev==0 & penwDC9prev~=.);



gen penwDC10=penwDC10curr+penwDC10last+penwDC10prev;



***************tenure******************;
replace MK004=0 if MK004==9998|MK004==9999;  *DK, RF;
replace MK022=0 if MK022==9998|MK022==9999;  *DK, RF;
gen tenurelast10=MK004-MK022 if MK004>MK022 & MK022~=0 ;  *year last worked - year started working;

replace ML016=0 if ML016==9998|ML016==9999;  *DK, RF;
replace ML009=0 if ML009==9998|ML009==9999;  *DK, RF;
gen tenureprev10=ML016-ML009 if ML016>ML009 & ML009~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast10= MK015 if MK016==6; *how much earning, if salary is per year;
replace earnlast10=MK015*(MK014/4) if MK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast10=MK015*(MK014/2) if MK016==3|MK016==5; * salary is bi-weeLLy;
replace earnlast10=MK015*(MK014) if MK016==2; *salary is weeLLy;
replace earnlast10=(MK015*MK014*MK011) if MK016==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast10=. if MK011> 997;
replace earnlast10=. if MK014> 97;
replace earnlast10=. if MK015> 999999000;
************* hourly wages******************;
gen wagelast10=earnlast10/(MK011*MK014); *earn/(hrs a week*weeks worked);




****************yearly earnings on prev job**************;
gen earnprev10= ML022 if ML023==6;
replace earnprev10=ML022*(ML021/4) if ML023==4;
replace earnprev10=ML022*(ML021/2) if ML023==3|ML023==5;
replace earnprev10=ML022*(ML021) if ML023==2;
replace earnprev10=(ML022*ML021*ML020) if ML023==1;


replace earnprev10=.  if ML020>997;                                              //drop top codes for hours worked per week  
replace earnprev10=.  if ML021>97;                                               //drop top codes for weeks worked per year
replace earnprev10=.  if ML022>999999000;                                        //drop top codes for earnings
************* hourly wages******************;
gen wageprev10=earnprev10/(ML020*ML021); *earn/(hrs a week*weeks worked);




*************** earliest age to still receive benefits ************;

* for pension plan 1;
gen peneage10=MJ383_1;
replace peneage10=35 if MJ383_1==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
replace peneage10=. if peneage10>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage10=MJ383_2 if peneage10~=. & MJ383_2~=. & peneage10>MJ383_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage10=MJ383_2 if peneage10==.;
replace peneage10=. if peneage10>95; 
replace peneage10=35 if MJ383_2==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage10=MJ383_3 if peneage10~=. & MJ383_3~=. & peneage10>MJ383_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace peneage10=MJ383_3 if peneage10==.;
replace peneage10=. if peneage10>95; 
replace peneage10=35 if MJ383_3==95; * access pension benefits anytime;

* for pension plan 4;
replace peneage10=MJ383_4 if peneage10~=. & MJ383_4~=. & peneage10>MJ383_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace peneage10=MJ383_4 if peneage10==.;
replace peneage10=. if peneage10>95; 
replace peneage10=35 if MJ383_4==95; * access pension benefits anytime;


************************************ age to receive full benefits *****************************;


* for pension plan 1;
gen pennage10=MJ367_1;
replace pennage10=35 if pennage10==95;* access pension benefits anytime;
replace pennage10=. if pennage10>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage10=MJ367_2 if pennage10~=. & MJ367_2~=. & pennage10>MJ367_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage10=MJ367_2 if pennage10==.;
replace pennage10=. if pennage10>95; 
replace pennage10=35 if MJ367_2==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage10=MJ367_3 if pennage10~=. & MJ367_3~=. & pennage10>MJ367_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
replace pennage10=MJ367_3 if pennage10==.;
replace pennage10=. if pennage10>95; 
replace pennage10=35 if MJ367_3==95; * access pension benefits anytime;

* for pension plan 4;
replace pennage10=MJ367_4 if pennage10~=. & MJ367_4~=. & pennage10>MJ367_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
replace pennage10=MJ367_4 if pennage10==.;
replace pennage10=. if pennage10>95; 
replace pennage10=35 if MJ367_4==95; * access pension benefits anytime;

******************************************************************;
******GOVT WORKERS************************************************;

replace ML078=. if ML078>2012;
replace ML079=. if ML079>2012;
replace ML080=. if ML080>2012;
replace ML081=. if ML081>2012;

gen Govt10=0;
replace Govt10=1 if ML077==1;

tab ML077;
tab Govt10;
gen GovtYears10=0;
* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin10=ML078;
replace GovtBegin10=1990 if ML078==.   & Govt10==1;
replace GovtBegin10=1990 if ML078>9000 & Govt10==1;
gen GovtEnd10=ML079 ;
replace GovtEnd10=2010 if ML079==.     & Govt10==1;
replace GovtEnd10=2010 if ML079>9000   & Govt10==1;
replace GovtYears10=GovtEnd10-GovtBegin10;
gen ExYears10=ML081-ML080; *2nd spell for the govt;
replace GovtYears10=GovtYears10+(ExYears10) if (ExYears10>0 & ExYears10~=.);
replace GovtEnd10=ML081 if ML081~=.;
replace GovtYears10=1 if GovtYears10<1 & GovtYears10~=.;
sort Govt10;
by Govt10: sum Govt* Ex*;

*Jobs covered by SS?;

gen SScov10=0;
replace SScov10=ML087 if (ML087==1|ML087==5); 
replace ML088=. if ML088>2012;
replace ML089=. if ML089>2012;
replace ML090=. if ML090>2012;
replace ML091=. if ML091>2012;

* years in job not covered by SS;

gen SSYears10=0;
gen SSBegin10=ML088;
replace SSBegin10=1990 if ML088==. & SScov10==1;
gen SSEnd10=ML089 ;
replace SSEnd10=2010 if ML089==. & SScov10==1;
replace SSYears10=SSEnd10-SSBegin10;
gen ExSSYears10=ML091-ML090; 
replace SSYears10=SSYears10+(ExSSYears10) if (ExSSYears10>0 & ExSSYears10~=.);
replace SSEnd10=ML091 if ML091~=.;
replace SSYears10=1 if SSYears10<1 & SSYears10~=.;
sort SScov10;
by SScov10: sum SS* Ex*;

*proxy w/ GovtYears

replace SScov10=1 if (SScov10==0|SScov10==.) & Govt10==1;
sort SScov10;
by SScov10: sum SSYears10 SScov10;
replace SSYears10=GovtYears10 if SScov10==1 & (SSYears10==.|SSYears10==0) & GovtYears10~=.; 
sort SScov10;
by SScov10: sum SSYears10 SScov10;
replace SSEnd10=GovtEnd10 if SScov10==1 & Govt10==1 & SSEnd10==.;


keep pen* ten* peneage10 pennage10 HHID PN same_pen10 earn* wage* SS* Govt*; 
sort HHID PN;

merge HHID PN using `saved'pension; 

drop _merge; 
summ pentypeDB10* pentypeDC10* peneage10 pennage10;
sort pentypeDB10curr;
by pentypeDB10curr: summ pennage10 peneage10 pentypeDB10curr;

replace pentypeDB10curr=pentypeDB9curr if same_pen10==1 & pentypeDB9curr~=. & pentypeDB10curr==0;
replace pentypeDC10curr=pentypeDC9curr if same_pen10==1 & pentypeDC9curr~=. & pentypeDC10curr==0 ;
replace peneage10=peneage9 if same_pen10==1 & peneage9~=. & peneage10==.;
replace pennage10=pennage9 if same_pen10==1 & pennage9~=. & pennage10==.;

summ pentypeDB10curr pentypeDC10curr peneage10 pennage10;
sort pentypeDB10curr;
by pentypeDB10curr: summ pennage10 peneage10 pentypeDB10curr;



sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 







*************************************************************************************;
****************************    WAVE 11     **********************************;
*************************************************************************************;


clear;
*set mem 400m;
use `wave10d'H10J_R;***to know whether or not a person worked in wave10***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave11d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave9;
sort HHID PN; 
merge HHID PN using `wave11d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave11d'temp, replace;
clear;


*set mem 400m;
use `wave11d'H12J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave11d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave11d'temp, replace;
clear;

*set mem 400m;
use `wave11d'H12J_P; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave11d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave11d'temp, replace;
clear;

*set mem 400m;
use `wave11d'H12K_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave11d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave11d'temp, replace;
clear;

*set mem 400m;
use `wave11d'H12L_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave11d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave11d'temp, replace;

*********** variable same_pen11 ***********;

gen same_pen11=0;
replace same_pen11=1 if NJ2945==5|NJ2945==8; * No changes from the last way. * NJ2945==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen11;                                                            // MJ945_1/2/3/4/ replaced by NJ2945



*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB11curr=.;
gen pentypeDB11last=.;
gen pentypeDB11prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB11curr=0  if NJ020==5|NJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
*replace pentypeDB11curr=0 if NJ2945==7;                                        // Does Not Exit Any More--------------------------------------------------------

******************* 1B: retired, last job--DB*******;
replace pentypeDB11last=0  if NK003==5|NK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB11prev=0  if NL005==5|NL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB11curr=0 if (NJ848==5|NJ848==8|NJ849==5|NJ849==8);  *those who change jobs from previous wave,; 
*replace pentypeDB11curr=0 if (NJ084==5|NJ084==8); *same job as last wave;      // Does Not Exit Any More--------------------------------------------------------

*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
*replace pentypeDB11curr=1 if NJW001A==1|NJW001A==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB11curr=0 if NJW001A==2;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 2;
*replace pentypeDB11curr=1 if NJW001B==1|NJW001B==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB11curr=0 if NJW001B==2;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 3;
*replace pentypeDB11curr=1 if NJW001C==1|NJW001C==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB11curr=0 if NJW001C==2;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 4;
*replace pentypeDB11curr=1 if NJW001D==1|NJW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB11curr=0 if NJW001D==2;                                       // Does Not Exit Any More--------------------------------------------------------





*****this is for people who changed employers b/w last two waves;
*replace pentypeDB11curr=1 if NJ327==1|NJ327==3;                                // Does Not Exit Any More-------------------------------------------------------- 
*replace pentypeDB11curr=0 if NJ327==2;                                         // Does Not Exit Any More--------------------------------------------------------
                                                                                // Maybe NJ2W407 can be used here and for the above code lines

*****pension plans have been changed, or YES to Are you included in any pen.plan?;

replace pentypeDB11curr=1 if NJ2338==1|NJ2338==3;
replace pentypeDB11curr=0 if NJ2338==2; 




******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB11last=0 if (NK031==5|NK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB11last=1 if NKW001A==1|NKW001A==3; 
replace pentypeDB11last=0 if NKW001A==2;

*  for plan 2;
replace pentypeDB11last=1 if NKW001B==1|NKW001B==3; 
replace pentypeDB11last=0 if NKW001B==2;

*  for plan 3;
replace pentypeDB11last=1 if NKW001C==1|NKW001C==3; 
replace pentypeDB11last=0 if NKW001C==2;

*  for plan 4;
*replace pentypeDB11last=1 if NKW001D==1|NKW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB11last=0 if NKW001D==2;                                       // Does Not Exit Any More--------------------------------------------------------

***imputed last job pension plans: MJ005M1/2/3/4/5- wave 10 working, NJ005M1/2/3/4/5 - Wave 11 retired;
replace pentypeDB11last=1 if (MJ005M1==1|MJ005M2==1|MJ005M3==1|MJ005M4==1|MJ005M5==1) & (NJ005M1==5|NJ005M2==5|NJ005M3==5|NJ005M4==5|NJ005M5==5) & pentypeDB10curr==1;
                                                                                // Question here


******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB11prev=0 if (NL027==5|NL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB11prev=0 if (NL031==5|NL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB11prev=1 if NLW001A==1|NLW001A==3; 
replace pentypeDB11prev=0 if NLW001A==2;

* plan 2;
replace pentypeDB11prev=1 if NLW001B==1|NLW001B==3; 
replace pentypeDB11prev=0 if NLW001B==2;

* plan 3;
replace pentypeDB11prev=1 if NLW001C==1|NLW001C==3; 
replace pentypeDB11prev=0 if NLW001C==2;

* plan 4;
replace pentypeDB11prev=1 if NLW001D==1|NLW001D==3; 
replace pentypeDB11prev=0 if NLW001D==2;

* plan 5;
replace pentypeDB11prev=1 if NLW001E==1|NLW001E==3; 
replace pentypeDB11prev=0 if NLW001E==2;

* plan 6;
replace pentypeDB11prev=1 if NLW001F==1|NLW001F==3; 
replace pentypeDB11prev=0 if NLW001F==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC11curr=.;
gen pentypeDC11last=.;
gen pentypeDC11prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC11curr=0  if NJ020==5|NJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
*replace pentypeDC11curr=0 if NJ2945==7; * deny being covered by a pension;     // Does Not Exit Any More--------------------------------------------------------

******************* 1B: retired, last job--DC*******;
replace pentypeDC11last=0  if NK003==5|NK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC11prev=0  if NL005==5|NL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC11curr=0 if (NJ848==5|NJ848==8|NJ849==5|NJ849==8);  *those who change jobs from previous wave; 
*replace pentypeDC11curr=0 if (NJ084==5|NJ084==8);                              // Does Not Exit Any More--------------------------------------------------------


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
*replace pentypeDC11curr=1 if NJW001A==2|NJW001A==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC11curr=0 if NJW001A==1;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 2;
*replace pentypeDC11curr=1 if NJW001B==2|NJW001B==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC11curr=0 if NJW001B==1;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 3;
*replace pentypeDC11curr=1 if NJW001C==2|NJW001C==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC11curr=0 if NJW001C==1;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 4;
*replace pentypeDC11curr=1 if NJW001D==2|NJW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC11curr=0 if NJW001D==1;                                       // Does Not Exit Any More--------------------------------------------------------



*****this is for people who changed employers b/w last two waves;
*replace pentypeDC11curr=1 if NJ327==2|NJ327==3;                                // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC11curr=0 if NJ327==1;                                         // Does Not Exit Any More--------------------------------------------------------


*****pension plans have been changed, or YES to Are you included in any pen.plan?;

replace pentypeDC11curr=1 if NJ2338==2|NJ2338==3;
replace pentypeDC11curr=0 if NJ2338==1; 




******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC11last=0 if (NK031==5|NK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC11last=1 if NKW001A==2|NKW001A==3; 
replace pentypeDC11last=0 if NKW001A==1;

*  for plan 2;
replace pentypeDC11last=1 if NKW001B==2|NKW001B==3; 
replace pentypeDC11last=0 if NKW001B==1;

*  for plan 3;
replace pentypeDC11last=1 if NKW001C==2|NKW001C==3; 
replace pentypeDC11last=0 if NKW001C==1;

*  for plan 3;
*replace pentypeDC11last=1 if NKW001D==2|NKW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC11last=0 if NKW001D==1;                                       // Does Not Exit Any More--------------------------------------------------------



***imputed last job pension plans: MJ005M1/2/3/4/5- wave10 working, NJ005M1/2/3/4/5 - Wave 11 retired;
replace pentypeDC11last=1 if (MJ005M1==1|MJ005M2==1|MJ005M3==1|MJ005M4==1|MJ005M5==1) & (NJ005M1==5|NJ005M2==5|NJ005M3==5|NJ005M4==5|NJ005M5==5) & pentypeDC10curr==1;
                                                                                // Question Here




******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC11prev=0 if (NL027==5|NL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC11prev=0 if (NL031==5|NL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC11prev=1 if NLW001A==2|NLW001A==3; 
replace pentypeDC11prev=0 if NLW001A==1;

* plan 2;
replace pentypeDC11prev=1 if NLW001B==2|NLW001B==3; 
replace pentypeDC11prev=0 if NLW001B==1;

* plan 3;
replace pentypeDC11prev=1 if NLW001C==2|NLW001C==3; 
replace pentypeDC11prev=0 if NLW001C==1;

* plan 4;
replace pentypeDC11prev=1 if NLW001D==2|NLW001D==3; 
replace pentypeDC11prev=0 if NLW001D==1;

* plan 5;
replace pentypeDC11prev=1 if NLW001E==2|NLW001E==3; 
replace pentypeDC11prev=0 if NLW001E==1;

* plan 6;
replace pentypeDC11prev=1 if NLW001F==2|NLW001F==3; 
replace pentypeDC11prev=0 if NLW001F==1;




************************************************************************************;
****************************now calculate pension wealth;

*current;

replace NJ2W002=0 if (NJ2W002==.|NJ2W002>99000000); *amount in account presently;
                                                                                //Still working for this employer and I set it to zero - also min max available

*replace NJ413_1=0 if (NJ413_1==.| NJ413_1>9900000); *amount in account presently;
*replace NJ413_2=0 if (NJ413_2==.| NJ413_2>9900000); 
*replace NJ413_3=0 if (NJ413_3==.| NJ413_3>9900000); 
*replace NJ413_4=0 if (NJ413_4==.| NJ413_4>9900000);                            //Maybe NJ2W009 can replace these variables  

gen penwDC11curr=NJ2W002; //+ MJ413_1+MJ413_2+MJ413_3+MJ413_4                    //NJ2W009
replace penwDC11curr=0 if penwDC11curr==.;


***********last;
*User's note from Codebook: "up to three responses allowed";
replace NKW009A=0 if (NKW009A==.| NKW009A>990000); *COMBO amount in accout NOW; //check error codes;
replace NKW009B=0 if (NKW009B==.| NKW009B>990000); 
replace NKW009C=0 if (NKW009C==.| NKW009C>990000);
*replace MKW009D=0 if (MKW009D==.| MKW009D>990000);

replace NKW009A=0 if NKW097AM1~=3 & NKW097AM2~=3 & NKW097AM3~=3; //check number of W097 Qs for A-D;
replace NKW009B=0 if NKW097BM1~=3 & NKW097BM2~=3;                               //NKW097BM3  also exists ( same for wave 10 )
replace NKW009C=0 if NKW097CM1~=3;                                              //NKW097CM2 does not exist any more 
*replace MKW009D=0 if MKW097DM1~=3 & MKW097DM2~=3;

gen penwDC11last=NKW009A+NKW009B+NKW009C;
replace penwDC11last=0 if penwDC11last==.;
replace penwDC11last=penwDC10last if (penwDC11last==0 & penwDC10last~=.);




**********prev;

replace NLW009A=0 if (NLW009A==.| NLW009A>9900000); *COMBO - amount in accout NOW;
replace NLW009B=0 if (NLW009B==.| NLW009B>9900000);
replace NLW009C=0 if (NLW009C==.| NLW009C>9900000);
replace NLW009D=0 if (NLW009D==.| NLW009D>9900000);
replace NLW009E=0 if (NLW009E==.| NLW009E>9900000);
replace NLW009F=0 if (NLW009F==.| NLW009F>9900000);

replace NLW009A=0 if NLW097AM1~=3 & NLW097AM2~=3 & NLW097AM3~=3; //check number of W097 Q's for A-F
replace NLW009B=0 if NLW097BM1~=3 & NLW097BM2~=3 & NLW097BM3~=3;
replace NLW009C=0 if NLW097CM1~=3 & NLW097CM2~=3;                               //NLW097CM3 does not exist any more
replace NLW009D=0 if NLW097DM1~=3;
replace NLW009E=0 if NLW097EM1~=3 & NLW097EM2~=3;                               //NLW097EM3 exists
replace NLW009F=0 if NLW097FM1~=3 & NLW097FM2~=3;

gen penwDC11prev=NLW009A+NLW009B+NLW009C+NLW009D+NLW009E+NLW009F;
replace penwDC11prev=0 if penwDC11prev==.;
replace penwDC11prev=penwDC10prev if (penwDC11prev==0 & penwDC10prev~=.);



gen penwDC11=penwDC11curr+penwDC11last+penwDC11prev;



***************tenure******************;
replace NK004=0 if NK004==9998|NK004==9999;  *DK, RF;
replace NK022=0 if NK022==9998|NK022==9999;  *DK, RF;
gen tenurelast11=NK004-NK022 if NK004>NK022 & NK022~=0 ;  *year last worked - year started working;

replace NL016=0 if NL016==9998|NL016==9999;  *DK, RF;
replace NL009=0 if NL009==9998|NL009==9999;  *DK, RF;
gen tenureprev11=NL016-NL009 if NL016>NL009 & NL009~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast11=NK015 if NK016==6; *how much earning, if salary is per year;
replace earnlast11=NK015*(NK014/4) if NK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast11=NK015*(NK014/2) if NK016==3|NK016==5; * salary is bi-weeLLy;
replace earnlast11=NK015*(NK014) if NK016==2; *salary is weeLLy;                // NK015=11 is per day, 4 observations - could add this here
replace earnlast11=(NK015*NK014*NK011) if NK016==1; *earn*weeks worked*hrs a week if hourly;

replace earnlast11=.  if NK011>997;                                             //drop top codes for hours worked per week  
replace earnlast11=.  if NK014>97;                                              //drop top codes for weeks worked per year
replace earnlast11=.  if NK015>999996;                                          //drop top codes for earnings
************* hourly wages******************;
gen wagelast11=earnlast11/(NK011*NK014); *earn/(hrs a week*weeks worked);       


****************yearly earnings on prev job**************;
gen earnprev11= NL022 if NL023==6;
replace earnprev11=NL022*(NL021/4) if NL023==4;
replace earnprev11=NL022*(NL021/2) if NL023==3|NL023==5;
replace earnprev11=NL022*(NL021) if NL023==2;
replace earnprev11=(NL022*NL021*NL020) if NL023==1;

replace earnprev11=.  if NL020>997;                                             //drop top codes for hours worked per week  
replace earnprev11=.  if NL021>97;                                              //drop top codes for weeks worked per year
replace earnprev11=.  if NL022>999996;                                          //drop top codes for earnings
************* hourly wages******************;
gen wageprev11=earnprev11/(NL020*NL021); *earn/(hrs a week*weeks worked);       


*************** earliest age to still receive benefits ************;            // This does noe exist any more. Possibly new variable can be used - didn't find it so far

* for pension plan 1;
*gen peneage11=MJ383_1;
*replace peneage11=35 if MJ383_1==95; * access pension benefits any time. I re-coded it as age 35, because it is the lowest age except for one case;
*replace peneage11=. if peneage11>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
*replace peneage11=MJ383_2 if peneage11~=. & MJ383_2~=. & peneage11>MJ383_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
*replace peneage11=MJ383_2 if peneage11==.;
*replace peneage11=. if peneage11>95; 
*replace peneage11=35 if MJ383_2==95; * access pension benefits anytime;

* for pension plan 3;
*replace peneage11=MJ383_3 if peneage11~=. & MJ383_3~=. & peneage11>MJ383_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
*replace peneage11=MJ383_3 if peneage11==.;
*replace peneage11=. if peneage11>95; 
*replace peneage11=35 if MJ383_3==95; * access pension benefits anytime;

* for pension plan 4;
*replace peneage11=MJ383_4 if peneage11~=. & MJ383_4~=. & peneage11>MJ383_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
*replace peneage11=MJ383_4 if peneage11==.;
*replace peneage11=. if peneage11>95; 
*replace peneage11=35 if MJ383_4==95; * access pension benefits anytime;
gen peneage11=.;

************************************ age to receive full benefits *****************************;
                            
                                                                                // This does noe exist any more. Possibly new variable can be used - didn't find it so far
* for pension plan 1;
*gen pennage11=MJ367_1;
*replace pennage11=35 if pennage11==95;* access pension benefits anytime;
*replace pennage11=. if pennage11>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
*replace pennage11=MJ367_2 if pennage11~=. & MJ367_2~=. & pennage11>MJ367_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
*replace pennage11=MJ367_2 if pennage11==.;
*replace pennage11=. if pennage11>95; 
*replace pennage11=35 if MJ367_2==95; * access pension benefits anytime;

* for pension plan 3;
*replace pennage11=MJ367_3 if pennage11~=. & MJ367_3~=. & pennage11>MJ367_3; * age of accessing pension benefits for pension plan 3 is younger than those of pension plan 1 and 2;
*replace pennage11=MJ367_3 if pennage11==.;
*replace pennage11=. if pennage11>95; 
*replace pennage11=35 if MJ367_3==95; * access pension benefits anytime;

* for pension plan 4;
*replace pennage11=MJ367_4 if pennage11~=. & MJ367_4~=. & pennage11>MJ367_4; * age of accessing pension benefits for pension plan 4 is younger than those of pension plan 1, 2 and 3;
*replace pennage11=MJ367_4 if pennage11==.;
*replace pennage11=. if pennage11>95; 
*replace pennage11=35 if MJ367_4==95; * access pension benefits anytime;
gen pennage11=.;

******************************************************************;
******GOVT WORKERS************************************************;

replace NL078=. if NL078>2014;
replace NL079=. if NL079>2014;
replace NL080=. if NL080>2014;
replace NL081=. if NL081>2014;

gen Govt11=0;
replace Govt11=1 if NL077==1;                                                   //I changed code and dropped missing values etc
tab NL077;
tab Govt11;
gen GovtYears11=0;
* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin11=NL078;
replace GovtBegin11=1992 if NL078==.   & Govt11==1;
replace GovtBegin11=1992 if NL078>9000 & Govt11==1;                             //Added code for missing values
gen GovtEnd11=NL079 ;
replace GovtEnd11=2012 if NL079==.     & Govt10==1;
replace GovtEnd11=2012 if NL079>9000.  & Govt10==1;                             //Added code for missing values
replace GovtYears11=GovtEnd11-GovtBegin11;
gen ExYears11=NL081-NL080; *2nd spell for the govt;
replace GovtYears11=GovtYears11+(ExYears11) if (ExYears11>0 & ExYears11~=.);
replace GovtEnd11=NL081 if NL081~=.;
replace GovtYears11=1 if GovtYears11<1 & GovtYears11~=.;
sort Govt11;
by Govt11: sum Govt* Ex*;

*Jobs covered by SS?;

gen SScov11=0;
replace SScov11=1 if NL087==1; 
replace NL088=. if NL088>2014;
replace NL089=. if NL089>2014;
replace NL090=. if NL090>2014;
replace NL091=. if NL091>2014;

* years in job not covered by SS;

gen SSYears11=0;
gen SSBegin11=NL088;
replace SSBegin11=1990 if NL088==. & SScov11==1;
replace SSBegin11=1990 if NL088>9000 & SScov11==1;
gen SSEnd11=NL089 ;
replace SSEnd11=2012 if NL089==. & SScov11==1;
replace SSEnd11=2012 if NL089>9000 & SScov11==1;
replace SSYears11=SSEnd11-SSBegin11;
gen ExSSYears11=NL091-NL090; 
replace SSYears11=SSYears11+(ExSSYears11) if (ExSSYears11>0 & ExSSYears11~=.);
replace SSEnd11=NL091 if NL091~=.;
replace SSYears11=1 if SSYears11<1 & SSYears11~=.;
sort SScov11;
by SScov11: sum SS* Ex*;

*proxy w/ GovtYears

replace SScov11=1 if (SScov11==0|SScov11==.) & Govt11==1;
sort SScov11;
by SScov11: sum SSYears11 SScov11;
replace SSYears11=GovtYears11 if SScov11==1 & (SSYears11==.|SSYears11==0) & GovtYears11~=.; 
sort SScov11;
by SScov11: sum SSYears11 SScov11;
replace SSEnd11=GovtEnd11 if SScov11==1 & Govt11==1 & SSEnd11==.;

keep pen* ten* HHID PN same_pen11 peneage11 pennage11 earn* wage* SS* Govt*;
sort HHID PN;
merge HHID PN using `saved'pension; 

drop _merge; 
summ peneage11 pennage11 pentypeDB11* pentypeDC11*;
sort pentypeDB11curr;
by pentypeDB11curr: summ pennage11 peneage11 pentypeDB11curr;

replace pentypeDB11curr=pentypeDB10curr if same_pen11==1 & pentypeDB10curr~=. & pentypeDB11curr==0;
replace pentypeDC11curr=pentypeDC10curr if same_pen11==1 & pentypeDC10curr~=. & pentypeDC11curr==0;
replace peneage11=peneage10 if same_pen11==1 & peneage10~=. & peneage11==.;
replace pennage11=pennage10 if same_pen11==1 & pennage10~=. & pennage11==.;

summ pentypeDB11curr pentypeDC11curr peneage11 pennage11;
sort pentypeDB11curr;
by pentypeDB11curr: summ pentypeDB11curr pennage11 peneage11;


sort HHID PN; 
summ;

sleep 1000;  save `saved'pension, replace;
drop _all; 

*************************************************************************************;
****************************    WAVE 12    **********************************;
*************************************************************************************;


clear;
*set mem 400m;
use `wave11d'H12J_R;***to know whether or not a person worked in wave10***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave12d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave9;
sort HHID PN; 
merge HHID PN using `wave12d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave12d'temp, replace;
clear;


*set mem 400m;
use `wave12d'H14J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave12d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave12d'temp, replace;
clear;

*set mem 400m;
use `wave12d'H14J_P; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave12d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave12d'temp, replace;
clear;

*set mem 400m;
use `wave12d'H14K_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave12d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave12d'temp, replace;
clear;

*set mem 400m;
use `wave12d'H14L_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave12d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave12d'temp, replace;



*********** variable same_pen12 ***********;

gen same_pen12=0;
replace same_pen12=1 if OJ2945==5|OJ2945==8; * No changes from the last way. * OJ2945==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen12;




*******************************************************************************;
****pension type - DB plan (type A), those whose pension plans don't change ***; 

gen pentypeDB12curr=.;
gen pentypeDB12last=.;
gen pentypeDB12prev=.;



******************* 1A: current job--DB*************;
replace pentypeDB12curr=0  if OJ020==5|OJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
*replace pentypeDB11curr=0 if OJ2945==7;                                        // Does Not Exit Any More--------------------------------------------------------

******************* 1B: retired, last job--DB*******;
replace pentypeDB12last=0  if OK003==5|OK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DB**;
replace pentypeDB12prev=0  if OL005==5|OL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;




******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB12curr=0 if (OJ848==5|OJ848==8|OJ849==5|OJ849==8);  *those who change jobs from previous wave,; //replace with MJ848&849?;
*replace pentypeDB11curr=0 if (OJ084==5|OJ084==8); *same job as last wave;      // Does Not Exit Any More--------------------------------------------------------



*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
*replace pentypeDB12curr=1 if OJW001A==1|OJW001A==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB12curr=0 if OJW001A==2;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 2;
*replace pentypeDB12curr=1 if OJW001B==1|OJW001B==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB12curr=0 if OJW001B==2;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 3;
*replace pentypeDB12curr=1 if OJW001C==1|OJW001C==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB12curr=0 if OJW001C==2;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 4;
*replace pentypeDB12curr=1 if OJW001D==1|OJW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB12curr=0 if OJW001D==2;                                       // Does Not Exit Any More--------------------------------------------------------





*****this is for people who changed employers b/w last two waves;
*replace pentypeDB12curr=1 if OJ327==1|OJ327==3;                                // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB12curr=0 if OJ327==2;                                         // Does Not Exit Any More--------------------------------------------------------


*****pension plans have been changed, or YES to Are you included in any pen.plan?;

replace pentypeDB12curr=1 if OJ2338==1|OJ2338==3;
replace pentypeDB12curr=0 if OJ2338==2; 

******************* 2B: DB plans, Retired, Last job******;

replace pentypeDB12last=0 if (OK031==5|OK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDB12last=1 if OKW001A==1|OKW001A==3; 
replace pentypeDB12last=0 if OKW001A==2;

*  for plan 2;
replace pentypeDB12last=1 if OKW001B==1|OKW001B==3; 
replace pentypeDB12last=0 if OKW001B==2;

*  for plan 3;
replace pentypeDB12last=1 if OKW001C==1|OKW001C==3; 
replace pentypeDB12last=0 if OKW001C==2;

*  for plan 4;
*replace pentypeDB12last=1 if OKW001D==1|OKW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDB12last=0 if OKW001D==2;                                       // Does Not Exit Any More--------------------------------------------------------
																				
																				
***imputed last job pension plans: NJ005M1/2/3/4/5 - wave 11 working, OJ005M1/2/3/4/5 - Wave 12 retired;
replace pentypeDB12last=1 if (NJ005M1==1|NJ005M2==1|NJ005M3==1|NJ005M4==1|NJ005M5==1) & (OJ005M1==5|OJ005M2==5|OJ005M3==5|OJ005M4==5|OJ005M5==5) & pentypeDB11curr==1;
                                                                                


******************* 2C: DB plans, Previous Jobs ******;

replace pentypeDB12prev=0 if (OL027==5|OL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB12prev=0 if (OL031==5|OL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDB12prev=1 if OLW001A==1|OLW001A==3; 
replace pentypeDB12prev=0 if OLW001A==2;

* plan 2;
replace pentypeDB12prev=1 if OLW001B==1|OLW001B==3; 
replace pentypeDB12prev=0 if OLW001B==2;

* plan 3;
*replace pentypeDB12prev=1 if OLW001C==1|OLW001C==3; 
*replace pentypeDB12prev=0 if OLW001C==2;

* plan 4;
*replace pentypeDB12prev=1 if OLW001D==1|OLW001D==3; 
*replace pentypeDB12prev=0 if OLW001D==2;

* plan 5;
replace pentypeDB12prev=1 if OLW001E==1|OLW001E==3; 
replace pentypeDB12prev=0 if OLW001E==2;

* plan 6;
replace pentypeDB12prev=1 if OLW001F==1|OLW001F==3; 
replace pentypeDB12prev=0 if OLW001F==2;




*******************************************************************************;
*******************************************************************************;
****pension type - DC plan (type B) ***; 

gen pentypeDC12curr=.;
gen pentypeDC12last=.;
gen pentypeDC12prev=.;

******************* 1A: current job--DC*************;
replace pentypeDC12curr=0  if OJ020==5|OJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
*replace pentypeDC12curr=0 if OJ2945==7; * deny being covered by a pension;     // Does Not Exit Any More--------------------------------------------------------

******************* 1B: retired, last job--DC*******;
replace pentypeDC12last=0  if OK003==5|OK003==8; * NO and DK for WORKING FOR PAY OR NOT;

******************* 1C: prev job (job history)--DC**;
replace pentypeDC12prev=0  if OL005==5|OL005==8; * NO and DK for WORKING FOR PAY for 5+ yrs;



******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC12curr=0 if (OJ848==5|OJ848==8|OJ849==5|OJ849==8);  *those who change jobs from previous wave; 
*replace pentypeDC12curr=0 if (OJ084==5|OJ084==8);                              // Does Not Exit Any More--------------------------------------------------------


*****current job same as prev wave, could be for self-empl, not sure;
*  for plan 1;
*replace pentypeDC12curr=1 if OJW001A==2|OJW001A==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC12curr=0 if OJW001A==1;                                       // Does Not Exit Any More--------------------------------------------------------
 
*  for plan 2;
*replace pentypeDC12curr=1 if OJW001B==2|OJW001B==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC12curr=0 if OJW001B==1;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 3;
*replace pentypeDC12curr=1 if OJW001C==2|OJW001C==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC12curr=0 if OJW001C==1;                                       // Does Not Exit Any More--------------------------------------------------------

*  for plan 4;
*replace pentypeDC12curr=1 if OJW001D==2|OJW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC12curr=0 if OJW001D==1;                                       // Does Not Exit Any More--------------------------------------------------------



*****this is for people who changed employers b/w last two waves;
*replace pentypeDC12curr=1 if OJ327==2|OJ327==3;                                // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC12curr=0 if OJ327==1;                                         // Does Not Exit Any More--------------------------------------------------------


*****pension plans have been changed, or YES to Are you included in any pen.plan?;

replace pentypeDC12curr=1 if OJ2338==2|OJ2338==3;
replace pentypeDC12curr=0 if OJ2338==1; 

******************* 2B: DC plans, Retired, Last job******;

replace pentypeDC12last=0 if (OK031==5|OK031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;

*  for plan 1;
replace pentypeDC12last=1 if OKW001A==2|OKW001A==3; 
replace pentypeDC12last=0 if OKW001A==1;

*  for plan 2;
replace pentypeDC12last=1 if OKW001B==2|OKW001B==3; 
replace pentypeDC12last=0 if OKW001B==1;

*  for plan 3;
replace pentypeDC12last=1 if OKW001C==2|OKW001C==3; 
replace pentypeDC12last=0 if OKW001C==1;

*  for plan 3;
*replace pentypeDC12last=1 if OKW001D==2|OKW001D==3;                            // Does Not Exit Any More--------------------------------------------------------
*replace pentypeDC12last=0 if OKW001D==1;                                       // Does Not Exit Any More--------------------------------------------------------



***imputed last job pension plans: NJ005M1/2/3/4/5 - wave11 working, OJ005M1/2/3/4/5 - Wave 12 retired;
replace pentypeDC12last=1 if (NJ005M1==1|NJ005M2==1|NJ005M3==1|NJ005M4==1|NJ005M5==1) & (OJ005M1==5|OJ005M2==5|OJ005M3==5|OJ005M4==5|OJ005M5==5) & pentypeDC11curr==1;





******************* 2C: DC plans, Previous Jobs ******;

replace pentypeDC10prev=0 if (OL027==5|OL027==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC10prev=0 if (OL031==5|OL031==8); *No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;


****plans for most recent and one other employer;

* plan 1;
replace pentypeDC12prev=1 if OLW001A==2|OLW001A==3; 
replace pentypeDC12prev=0 if OLW001A==1;

* plan 2;
replace pentypeDC12prev=1 if OLW001B==2|OLW001B==3; 
replace pentypeDC12prev=0 if OLW001B==1;

* plan 3;
*replace pentypeDC12prev=1 if OLW001C==2|OLW001C==3; 
*replace pentypeDC12prev=0 if OLW001C==1;

* plan 4;
*replace pentypeDC12prev=1 if OLW001D==2|OLW001D==3; 
*replace pentypeDC12prev=0 if OLW001D==1;

* plan 5;
replace pentypeDC12prev=1 if OLW001E==2|OLW001E==3; 
replace pentypeDC12prev=0 if OLW001E==1;

* plan 6;
replace pentypeDC12prev=1 if OLW001F==2|OLW001F==3; 
replace pentypeDC12prev=0 if OLW001F==1;




************************************************************************************;
****************************now calculate pension wealth;

*current;

replace OJ2W002=0 if (OJ2W002==.|OJ2W002>9900000); *amount in account presently;
                                                                                //Still working for this employer and I set it to zero - also min max available

*replace OJ413_1=0 if (OJ413_1==.| OJ413_1>9900000); *amount in account presently;
*replace OJ413_2=0 if (OJ413_2==.| OJ413_2>9900000); 
*replace OJ413_3=0 if (O413_3==. | OJ413_3>9900000); 
*replace OJ413_4=0 if (OJ413_4==.| OJ413_4>9900000);                            //Maybe OJ2W009 can replace these variables  

gen penwDC12curr=OJ2W002; //+MJ413_1+MJ413_2+MJ413_3+MJ413_4;
replace penwDC12curr=0 if penwDC12curr==.;


***********last;
*User's note from Codebook: "up to three responses allowed";
replace OKW009A=0 if (OKW009A==.| OKW009A>990000); *COMBO amount in accout NOW; //check error codes;
replace OKW009B=0 if (OKW009B==.| OKW009B>990000); 
replace OKW009C=0 if (OKW009C==.| OKW009C>990000);
*replace OKW009D=0 if (OKW009D==.| OKW009D>990000);

replace OKW009A=0 if OKW097AM1~=3 & OKW097AM2~=3; //check number of W097 Qs for A-D;
replace OKW009B=0 if OKW097BM1~=3 & OKW097BM2~=3;
replace OKW009C=0 if OKW097CM1~=3;// & OKW097CM2~=3;                            //check this 
*replace OKW009D=0 if OKW097DM1~=3 & OKW097DM2~=3;

gen penwDC12last=OKW009A+OKW009B+OKW009C;
replace penwDC12last=0 if penwDC12last==.;
replace penwDC12last=penwDC11last if (penwDC12last==0 & penwDC11last~=.);




**********prev;

replace OLW009A=0 if (OLW009A==.| OLW009A>999000); *COMBO - amount in accout NOW;
replace OLW009B=0 if (OLW009B==.| OLW009B>999000);
*replace OLW009C=0 if (OLW009C==.| OLW009C>9900000);
*eplace OLW009D=0 if (OLW009D==.| OLW009D>9900000);
replace OLW009E=0 if (OLW009E==.| OLW009E>999000);
replace OLW009F=0 if (OLW009F==.| OLW009F>9999000);

replace OLW009A=0 if OLW097AM1~=3 & OLW097AM2~=3 & OLW097AM3~=3; //check number of W097 Q's for A-F
replace OLW009B=0 if OLW097BM1~=3 & OLW097BM2~=3 & OLW097BM3~=3;
*replace OLW009C=0 if OLW097CM1~=3 & OLW097CM2~=3 & OLW097CM3~=3;
*replace OLW009D=0 if OLW097DM1~=3;
replace OLW009E=0 if OLW097EM1~=3 & OLW097EM2~=3;
replace OLW009F=0 if OLW097FM1~=3 & OLW097FM2~=3;

gen penwDC12prev=OLW009A+OLW009B+OLW009E+OLW009F;
replace penwDC12prev=0 if penwDC12prev==.;
replace penwDC12prev=penwDC11prev if (penwDC12prev==0 & penwDC11prev~=.);



gen penwDC12=penwDC12curr+penwDC12last+penwDC12prev;



***************tenure******************;
replace OK004=0 if OK004==9998|OK004==9999;  *DK, RF;
replace OK022=0 if OK022==9998|OK022==9999;  *DK, RF;
gen tenurelast12=OK004-OK022 if OK004>OK022 & OK022~=0 ;  *year last worked - year started working;

replace OL016=0 if OL016==9998|OL016==9999;  *DK, RF;
replace OL009=0 if OL009==9998|OL009==9999;  *DK, RF;
gen tenureprev12=OL016-OL009 if OL016>OL009 & OL009~=0 ;  *year last worked - year started working;





**************yearly earnings on last job****************;
gen earnlast12= OK015                  if OK016==6;                             *how much earning, if salary is per year;
replace earnlast12=OK015*(OK014/4)     if OK016==4;                             *earn*(weeks worked per year/4) if salary is in months;
replace earnlast12=OK015*(OK014/2)     if OK016==3|OK016==5;                    *salary is bi-weeLLy;
replace earnlast12=OK015*(OK014)       if OK016==2;                             *salary is weeLLy;
replace earnlast12=(OK015*OK014*OK011) if OK016==1;                             *earn*weeks worked*hrs a week if hourly;

replace earnlast12=.                   if OK011>97;
replace earnlast12=.                   if OK014>97;
replace earnlast12=.                   if OK015>999990;
************* hourly wages******************;
gen wagelast12=earnlast12/(OK011*OK014); *earn/(hrs a week*weeks worked);




****************yearly earnings on prev job**************;
gen earnprev12= OL022                  if OL023==6;
replace earnprev12=OL022*(OL021/4)     if OL023==4;
replace earnprev12=OL022*(OL021/2)     if OL023==3|OL023==5;
replace earnprev12=OL022*(OL021)       if OL023==2;
replace earnprev12=(OL022*OL021*OL020) if OL023==1;

replace earnprev12=.                   if OL020>997;    
replace earnprev12=.                   if OL021>97;   
replace earnprev12=.                   if OL022>999996;
************* hourly wages******************;
gen wageprev12=earnprev12/(OL020*OL021); *earn/(hrs a week*weeks worked);



*************** earliest age to still receive benefits ************;            // This does noe exist any more. Possibly new variable can be used - didn't find it so far

gen peneage12=.;

************************************ age to receive full benefits *****************************;

gen pennage12=.;

******************************************************************;
******GOVT WORKERS************************************************;

replace OL078=. if OL078>2016;
replace OL079=. if OL079>2016;
replace OL080=. if OL080>2016;
replace OL081=. if OL081>2016;

gen Govt12=0;
replace Govt12=1 if OL077==1;
tab OL077;
tab Govt12;
gen GovtYears12=0;
* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin12=OL078;
replace GovtBegin12=1994 if OL078==.   & Govt12==1;
replace GovtBegin12=1994 if OL078>9000 & Govt12==1;
gen GovtEnd12=OL079 ;
replace GovtEnd12=2014 if OL079==.     & Govt12==1;
replace GovtEnd12=2014 if OL079>9000   & Govt12==1;
replace GovtYears12=GovtEnd12-GovtBegin12;
gen ExYears12=OL081-OL080; *2nd spell for the govt;
replace GovtYears12=GovtYears12+(ExYears12) if (ExYears12>0 & ExYears12~=.);
replace GovtEnd12=OL081 if OL081~=.;
replace GovtYears12=1 if GovtYears12<1 & GovtYears12~=.;
sort Govt12;
by Govt12: sum Govt* Ex*;

*Jobs covered by SS;

gen SScov12=0;
replace SScov12=1 if OL087==1; 
replace OL088=.   if OL088>2016;
replace OL089=.   if OL089>2016;
replace OL090=.   if OL090>2016;
replace OL091=.   if OL091>2016;

* years in job not covered by SS;

gen SSYears12=0;
gen SSBegin12=OL088;
replace SSBegin12=1990 if OL088==.   & SScov12==1;
replace SSBegin12=1990 if OL088>9000 & SScov12==1;
gen SSEnd12=OL089;
replace SSEnd12=2014 if OL089==.     & SScov12==1;
replace SSEnd12=2014 if OL089>9000   & SScov12==1;
replace SSYears12=SSEnd12-SSBegin12;
gen ExSSYears12=OL091-OL090;                                                    //Q in this line
replace SSYears12=SSYears12+(ExSSYears12) if (ExSSYears12>0 & ExSSYears12~=.);
replace SSEnd12=OL091 if OL091~=.;
replace SSYears12=1 if SSYears12<1 & SSYears12~=.;
sort SScov12;
by SScov12: sum SS* Ex*;

*proxy w/ GovtYears

replace SScov12=1 if (SScov12==0|SScov12==.) & Govt12==1;
sort SScov12;
by SScov12: sum SSYears12 SScov12;
replace SSYears12=GovtYears12 if SScov12==1 & (SSYears12==.|SSYears12==0) & GovtYears12~=.; 
sort SScov12;
by SScov12: sum SSYears12 SScov12;
replace SSEnd12=GovtEnd12 if SScov12==1 & Govt12==1 & SSEnd12==.;



***********************************************************************************************************************************************************
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen12 peneage12 pennage12; 
drop NJ* OJ*;                                                                   //weird
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen12 peneage12 pennage12;                    
sort HHID PN;

merge HHID PN using `saved'pension; 
drop _merge; 
summ pentypeDB12* pentypeDC12* peneage12 pennage12;
sort pentypeDB12curr;
by pentypeDB12curr: summ pennage12 peneage12 pentypeDB12curr; 

replace pentypeDB12curr=pentypeDB11curr if same_pen12==1 & pentypeDB11curr~=. & pentypeDB12curr==0;
replace pentypeDC12curr=pentypeDC11curr if same_pen12==1 & pentypeDC11curr~=. & pentypeDC12curr==0 ;
replace peneage12=peneage11 if same_pen12==1 & peneage11~=. & peneage12==.;
replace pennage12=pennage11 if same_pen12==1 & pennage11~=. & pennage12==.;

summ pentypeDB12curr pentypeDC12curr peneage12 pennage12;
sort pentypeDB12curr;
by pentypeDB12curr: summ pennage12 peneage12 pentypeDB12curr;



sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 


*************************************************************************************;
****************************    WAVE 13    **********************************;
*************************************************************************************;


clear;
*set mem 400m;
use `wave12d'H14J_R;***to know whether or not a person worked in wave12***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 1000;  save `wave13d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave9;
sort HHID PN; 
merge HHID PN using `wave13d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave13d'temp, replace;
clear;


*set mem 400m;
use `wave13d'H16J_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave13d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave13d'temp, replace;
clear;

*set mem 400m;
use `wave13d'H16J2_P; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave13d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave13d'temp, replace;
clear;

*set mem 400m;
use `wave13d'H16J3_R; 
gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave13d'temp;
drop _merge;
sort HHID PN; 
sleep 1000;  save `wave13d'temp, replace;



*********** variable same_pen13 ***********;

gen same_pen13=0;
replace same_pen13=1 if PJ2945==5|PJ2945==8; * No changes from the last way. * PJ2945==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen13;


gen pentypeDB13curr=.;
gen pentypeDB13last=.;
gen pentypeDB13prev=.;
******************* 1A: current job--DB*************;
replace pentypeDB13curr=0  if PJ020==5|PJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB13curr=0 if (PJ848==5|PJ848==8|PJ849==5|PJ849==8);  *those who change jobs from previous wave,; 
*****pension plans have been changed, or YES to Are you included in any pen.plan?;
replace pentypeDB13curr=1 if PJ2338==1|PJ2338==3;
replace pentypeDB13curr=0 if PJ2338==2; 


gen pentypeDC13curr=.;
gen pentypeDC13last=.;
gen pentypeDC13prev=.;
******************* 1A: current job--DC*************;
replace pentypeDC13curr=0  if PJ020==5|PJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC13curr=0 if (PJ848==5|PJ848==8|PJ849==5|PJ849==8);  *those who change jobs from previous wave; 
*****pension plans have been changed, or YES to Are you included in any pen.plan?;
replace pentypeDC13curr=1 if PJ2338==2|PJ2338==3;
replace pentypeDC13curr=0 if PJ2338==1; 





gen penwDC13last=.;
gen penwDC13prev=.;
gen penwDC13=.;

************************************************************************************;
****************************now calculate pension wealth;

*current;

replace PJ2W002=0 if (PJ2W002==.|PJ2W002>9999990); *amount in account presently;
                                                                                //Still working for this employer and I set it to zero - also min max available

gen penwDC13curr=PJ2W002; 
replace penwDC13curr=0 if penwDC13curr==.;



***************tenure******************;
replace PJK004=0 if PJK004==9998|PJK004==9999;  *DK, RF;
replace PJK022=0 if PJK022==9998|PJK022==9999;  *DK, RF;
gen tenurelast13=PJK004-PJK022 if PJK004>PJK022 & PJK022~=0 ;  *year last worked - year started working;

replace PJL016_1=0 if PJL016_1==9998|PJL016_1==9999;  *DK, RF;
replace PJL009_1=0 if PJL009_1==9998|PJL009_1==9999;  *DK, RF;
gen tenureprev13=PJL016_1-PJL009_1 if PJL016_1>PJL009_1 & PJL009_1~=0 ;  *year last worked - year started working;




**************yearly earnings on last job****************;
gen earnlast13= PJK015 if PJK016==6; *how much earning, if salary is per year;
replace earnlast13=PJK015*(PJK014/4) if PJK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast13=PJK015*(PJK014/2) if PJK016==3|PJK016==5; * salary is bi-weeLLy;
replace earnlast13=PJK015*(PJK014) if PJK016==2; *salary is weeLLy;
replace earnlast13=(PJK015*PJK014*PJK011) if PJK016==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast13=. if PJK011> 997;
replace earnlast13=. if PJK014> 97;
replace earnlast13=. if PJK015> 999997;
************* hourly wages******************;
gen wagelast13=earnlast13/(PJK011*PJK014); *earn/(hrs a week*weeks worked);


****************yearly earnings on prev job**************;
gen earnprev13= PJL022_1 if PJL023_1==6;
replace earnprev13=PJL022_1*(PJL021_1/4) if PJL023_1==4;
replace earnprev13=PJL022_1*(PJL021_1/2) if PJL023_1==3|PJL023_1==5;
replace earnprev13=PJL022_1*(PJL021_1) if PJL023_1==2;
replace earnprev13=(PJL022_1*PJL021_1*PJL020_1) if PJL023_1==1;

replace earnprev13=. if earnprev13>16000000 & PJL023_1==1; //this might be a bug - have a look when final version of wave 13 is out

replace earnprev13=.  if PJL020_1>997;                                           //drop top codes for hours worked per week  
replace earnprev13=.  if PJL021_1>97;                                            //drop top codes for weeks worked per year
replace earnprev13=.  if PJL022_1>999990;                                        //drop top codes for earnings
************* hourly wages******************;
gen wageprev13=earnprev13/(PJL020_1*PJL021_1); *earn/(hrs a week*weeks worked);



gen peneage13=.;
gen pennage13=.;



******GOVT WORKERS************************************************;


gen Govt13=0;
replace Govt13=1 if PJ720==1;
tab PJ720;
tab Govt13;

* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin13=1996;
gen GovtEnd13=2016;
gen GovtYears13=GovtEnd13-GovtBegin13;
sort Govt13;
by Govt13: sum Govt*;

*Jobs covered by SS;

gen SScov13=0;
replace SScov13=1 if PJ676==1; 

* years in job not covered by SS;

gen SSBegin13=.;
gen SSEnd13=.;
gen ExSSYears13=.;


gen SSYears13=.;
replace SSYears13= PJL3111 if PJL3111<97;
replace SSYears13=1 if SSYears13<1 & SSYears13~=.;

sort SScov13;
by SScov13: sum SS*;

*proxy w/ GovtYears

replace SScov13=1 if (SScov13==0|SScov13==.) & Govt13==1;
sort SScov13;
by SScov13: sum SSYears13 SScov13;
replace SSYears13=GovtYears13 if SScov13==1 & (SSYears13==.|SSYears13==0) & GovtYears13~=.; 
sort SScov13;
by SScov13: sum SSYears13 SScov13;
replace SSEnd13=GovtEnd13 if SScov13==1 & Govt13==1 & SSEnd13==.;



***********************************************************************************************************************************************************
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen13 peneage13 pennage13; 
drop OJ* PJ*;                                                                 
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen13 peneage13 pennage13;                    
sort HHID PN;

merge HHID PN using `saved'pension; 
drop _merge; 
summ pentypeDB13* pentypeDC13* peneage13 pennage13;
sort pentypeDB13curr;
by pentypeDB13curr: summ pennage13 peneage13 pentypeDB13curr; 

replace pentypeDB13curr=pentypeDB12curr if same_pen13==1 & pentypeDB12curr~=. & pentypeDB13curr==0;
replace pentypeDC13curr=pentypeDC12curr if same_pen13==1 & pentypeDC12curr~=. & pentypeDC13curr==0 ;
replace peneage13=peneage12 if same_pen13==1 & peneage12~=. & peneage13==.;
replace pennage13=pennage12 if same_pen13==1 & pennage12~=. & pennage13==.;

summ pentypeDB13curr pentypeDC13curr peneage13 pennage13;
sort pentypeDB13curr;
by pentypeDB13curr: summ pennage13 peneage13 pentypeDB13curr;



sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 

*************************************************************************************;
************************************    WAVE 14    **********************************;
**************** logic added to handle -8.  Web non-responses    ********************;
*************************************************************************************;
clear;
*set mem 400m;
use `wave13d'H16J_R;***to know whether or not a person worked in wave13***;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 2000;  save `wave14d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave13;
sort HHID PN; 
merge HHID PN using `wave14d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave14d'temp, replace;
clear;


*set mem 400m;
use `wave14d'H18J_R; 
gen temp=real(hhid); 
drop hhid;
rename temp HHID; 
gen temp=real(pn); 
drop pn; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave14d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave14d'temp, replace;
clear;

*set mem 400m;
use `wave14d'H18J2_P; 
gen temp=real(hhid); 
drop hhid;
rename temp HHID; 
gen temp=real(pn); 
drop pn; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave14d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave14d'temp, replace;
clear;

*set mem 400m;
use `wave14d'H18J3_R; 
gen temp=real(hhid); 
drop hhid;
rename temp HHID; 
gen temp=real(pn); 
drop pn; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave14d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave14d'temp, replace;



*********** variable same_pen14 ***********;

gen same_pen14=0;
replace same_pen14=1 if QJ2945==5|QJ2945==8; * No changes from the last way. * QJ2945==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen14;


gen pentypeDB14curr=.;
gen pentypeDB14last=.;
gen pentypeDB14prev=.;
******************* 1A: current job--DB*************;
replace pentypeDB14curr=0  if QJ020==5|QJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB14curr=0 if (QJ848==5|QJ848==8|QJ849==5|QJ849==8);  *those who change jobs from previous wave,; 
*****pension plans have been changed, or YES to Are you included in any pen.plan?;
replace pentypeDB14curr=1 if QJ2338==1|QJ2338==3;
replace pentypeDB14curr=0 if QJ2338==2; 


gen pentypeDC14curr=.;
gen pentypeDC14last=.;
gen pentypeDC14prev=.;
******************* 1A: current job--DC*************;
replace pentypeDC14curr=0  if QJ020==5|QJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC14curr=0 if (QJ848==5|QJ848==8|QJ849==5|QJ849==8);  *those who change jobs from previous wave; 
*****pension plans have been changed, or YES to Are you included in any pen.plan?;
replace pentypeDC14curr=1 if QJ2338==2|QJ2338==3;
replace pentypeDC14curr=0 if QJ2338==1; 





gen penwDC14last=.;
gen penwDC14prev=.;
gen penwDC14=.;

************************************************************************************;
****************************now calculate pension wealth;

*current;

replace QJ2W002=0 if (QJ2W002==.|QJ2W002>9999990); *amount in account presently;
                                                                                //Still working for this employer and I set it to zero - also min max available

gen penwDC14curr=QJ2W002; 
replace penwDC14curr=0 if penwDC14curr==.;



***************tenure******************;
replace QJK004=0 if QJK004==9998|QJK004==9999|QJK004==-8;  *DK, RF;
replace QJK022=0 if QJK022==9998|QJK022==9999|QJK022==-8;  *DK, RF;
gen tenurelast14=QJK004-QJK022 if QJK004>QJK022 & QJK022~=0 ;  *year last worked - year started working;

replace QJL016_1=0 if QJL016_1==9998|QJL016_1==9999|QJL016_1==-8;  *DK, RF;
replace QJL009_1=0 if QJL009_1==9998|QJL009_1==9999|QJL009_1==-8;  *DK, RF;
gen tenureprev14=QJL016_1-QJL009_1 if QJL016_1>QJL009_1 & QJL009_1~=0 ;  *year last worked - year started working;




**************yearly earnings on last job****************;
gen earnlast14= QJK015 if QJK016==6; *how much earning, if salary is per year;
replace earnlast14=QJK015*(QJK014/4) if QJK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast14=QJK015*(QJK014/2) if QJK016==3|QJK016==5; * salary is bi-weeLLy;
replace earnlast14=QJK015*(QJK014) if QJK016==2; *salary is weeLLy;
replace earnlast14=(QJK015*QJK014*QJK011) if QJK016==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast14=. if QJK011> 997 | QJK011==-8;
replace earnlast14=. if QJK014> 97 | QJK014==-8;
replace earnlast14=. if QJK015> 999997 | QJK015==-8 ;
************* hourly wages******************;
gen wagelast14=earnlast14/(QJK011*QJK014); *earn/(hrs a week*weeks worked);


****************yearly earnings on prev job**************;
gen earnprev14= QJL022_1 if QJL023_1==6;
replace earnprev14=QJL022_1*(QJL021_1/4) if QJL023_1==4;
replace earnprev14=QJL022_1*(QJL021_1/2) if QJL023_1==3|QJL023_1==5;
replace earnprev14=QJL022_1*(QJL021_1) if QJL023_1==2;
replace earnprev14=(QJL022_1*QJL021_1*QJL020_1) if QJL023_1==1;

replace earnprev14=. if earnprev14>16000000 & QJL023_1==1; //this might be a bug - have a look when final version of wave 14 is out

replace earnprev14=.  if QJL020_1>997 | QJL020_1==-8 ;                                           //drop top codes for hours worked per week  
replace earnprev14=.  if QJL021_1>97 | QJL021_1==-8;                                            //drop top codes for weeks worked per year
replace earnprev14=.  if QJL022_1>999990 | QJL022_1==-8;                                        //drop top codes for earnings
************* hourly wages******************;
gen wageprev14=earnprev14/(QJL020_1*QJL021_1); *earn/(hrs a week*weeks worked);



gen peneage14=.;
gen pennage14=.;



******GOVT WORKERS************************************************;


gen Govt14=0;
replace Govt14=1 if QJ720==1;
tab QJ720;
tab Govt14;

* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin14=1996;
gen GovtEnd14=2016;
gen GovtYears14=GovtEnd14-GovtBegin14;
sort Govt14;
by Govt14: sum Govt*;

*Jobs covered by SS;

gen SScov14=0;
replace SScov14=1 if QJ676==1; 

* years in job not covered by SS;

gen SSBegin14=.;
gen SSEnd14=.;
gen ExSSYears14=.;


gen SSYears14=.;
replace SSYears14= QJL3111 if QJL3111<97;
replace SSYears14=1 if SSYears14<1 & SSYears14~=.;

sort SScov14;
by SScov14: sum SS*;

*proxy w/ GovtYears

replace SScov14=1 if (SScov14==0|SScov14==.) & Govt14==1;
sort SScov14;
by SScov14: sum SSYears14 SScov14;
replace SSYears14=GovtYears14 if SScov14==1 & (SSYears14==.|SSYears14==0) & GovtYears14~=.; 
sort SScov14;
by SScov14: sum SSYears14 SScov14;
replace SSEnd14=GovtEnd14 if SScov14==1 & Govt14==1 & SSEnd14==.;



***********************************************************************************************************************************************************
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen14 peneage14 pennage14; 
drop PJ* QJ*;                                                                 
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen14 peneage14 pennage14;                    
sort HHID PN;

merge HHID PN using `saved'pension; 
drop _merge; 
summ pentypeDB14* pentypeDC14* peneage14 pennage14;
sort pentypeDB14curr;
by pentypeDB14curr: summ pennage14 peneage14 pentypeDB14curr; 

replace pentypeDB14curr=pentypeDB12curr if same_pen14==1 & pentypeDB12curr~=. & pentypeDB14curr==0;
replace pentypeDC14curr=pentypeDC12curr if same_pen14==1 & pentypeDC12curr~=. & pentypeDC14curr==0 ;
replace peneage14=peneage12 if same_pen14==1 & peneage12~=. & peneage14==.;
replace pennage14=pennage12 if same_pen14==1 & pennage12~=. & pennage14==.;

summ pentypeDB14curr pentypeDC14curr peneage14 pennage14;
sort pentypeDB14curr;
by pentypeDB14curr: summ pennage14 peneage14 pentypeDB14curr;



sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 

*************************************************************************************;
************************************    WAVE 15    **********************************;
**************** logic added to handle -8.  Web non-responses    ********************;
*************************************************************************************;
if $INCLUDE2020 {; 
clear;
*set mem 400m;
use `wave14d'H18J_R;***to know whether or not a person worked in wave14***;
gen temp=real(hhid);
drop hhid;
gen HHID=temp;
drop temp;
gen temp=real(pn);
drop pn;
gen PN=temp;
drop temp;
sort HHID PN; 
sleep 2000;  save `wave15d'temp, replace;
clear;

*set mem 400m;
use `saved'pension;   ***to know whether or not a person had a DB or DC pension plan in wave13;
sort HHID PN; 
merge HHID PN using `wave15d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave15d'temp, replace;
clear;


*set mem 400m;
use `wave15d'H20J_R; 
gen temp=real(hhid); 
drop hhid;
rename temp HHID; 
gen temp=real(pn); 
drop pn; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave15d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave15d'temp, replace;
clear;

*set mem 400m;
use `wave15d'H20J2_P; 
gen temp=real(hhid); 
drop hhid;
rename temp HHID; 
gen temp=real(pn); 
drop pn; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave15d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave15d'temp, replace;
clear;

*set mem 400m;
use `wave15d'H20J3_R; 
gen temp=real(hhid); 
drop hhid;
rename temp HHID; 
gen temp=real(pn); 
drop pn; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `wave15d'temp;
drop _merge;
sort HHID PN; 
sleep 2000;  save `wave15d'temp, replace;



*********** variable same_pen15 ***********;

gen same_pen15=0;
replace same_pen15=1 if RJ2945==5|RJ2945==8; * No changes from the last way. * RJ2945==8 is "DK", which is interpreted as "no changes" noticed;
tabulate same_pen15;


gen pentypeDB15curr=.;
gen pentypeDB15last=.;
gen pentypeDB15prev=.;
******************* 1A: current job--DB*************;
replace pentypeDB15curr=0  if RJ020==5|RJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
******************* 2A: DB plans on current job******;
*****No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDB15curr=0 if (RJ848==5|RJ848==8|RJ849==5|RJ849==8);  *those who change jobs from previous wave,; 
*****pension plans have been changed, or YES to Are you included in any pen.plan?;
replace pentypeDB15curr=1 if RJ2338==1|RJ2338==3;
replace pentypeDB15curr=0 if RJ2338==2; 


gen pentypeDC15curr=.;
gen pentypeDC15last=.;
gen pentypeDC15prev=.;
******************* 1A: current job--DC*************;
replace pentypeDC15curr=0  if RJ020==5|RJ020==8; * NO and DK for WORKING FOR PAY OR NOT;
******************* 2A: DC plans on current job******;
*No and DK for ARE YOU INCLUDED IN ANY PENSION PLAN;
replace pentypeDC15curr=0 if (RJ848==5|RJ848==8|RJ849==5|RJ849==8);  *those who change jobs from previous wave; 
*****pension plans have been changed, or YES to Are you included in any pen.plan?;
replace pentypeDC15curr=1 if RJ2338==2|RJ2338==3;
replace pentypeDC15curr=0 if RJ2338==1; 





gen penwDC15last=.;
gen penwDC15prev=.;
gen penwDC15=.;

************************************************************************************;
****************************now calculate pension wealth;

*current;

replace RJ2W002=0 if (RJ2W002==.|RJ2W002>9999990); *amount in account presently;
                                                                                //Still working for this employer and I set it to zero - also min max available

gen penwDC15curr=RJ2W002; 
replace penwDC15curr=0 if penwDC15curr==.;



***************tenure******************;
replace RJK004=0 if RJK004==9998|RJK004==9999|RJK004==-8;  *DK, RF;
replace RJK022=0 if RJK022==9998|RJK022==9999|RJK022==-8;  *DK, RF;
gen tenurelast15=RJK004-RJK022 if RJK004>RJK022 & RJK022~=0 ;  *year last worked - year started working;

replace RJL016_1=0 if RJL016_1==9998|RJL016_1==9999|RJL016_1==-8;  *DK, RF;
replace RJL009_1=0 if RJL009_1==9998|RJL009_1==9999|RJL009_1==-8;  *DK, RF;
gen tenureprev15=RJL016_1-RJL009_1 if RJL016_1>RJL009_1 & RJL009_1~=0 ;  *year last worked - year started working;




**************yearly earnings on last job****************;
gen earnlast15= RJK015 if RJK016==6; *how much earning, if salary is per year;
replace earnlast15=RJK015*(RJK014/4) if RJK016==4; *(earn*(weeks worked per year/4)) if salary is in months;
replace earnlast15=RJK015*(RJK014/2) if RJK016==3|RJK016==5; * salary is bi-weeLLy;
replace earnlast15=RJK015*(RJK014) if RJK016==2; *salary is weeLLy;
replace earnlast15=(RJK015*RJK014*RJK011) if RJK016==1; *earn*weeks worked*hrs a week if hourly;


replace earnlast15=. if RJK011> 997 | RJK011==-8;
replace earnlast15=. if RJK014> 97 | RJK014==-8;
replace earnlast15=. if RJK015> 999997 | RJK015==-8 ;
************* hourly wages******************;
gen wagelast15=earnlast15/(RJK011*RJK014); *earn/(hrs a week*weeks worked);


****************yearly earnings on prev job**************;
gen earnprev15= RJL022_1 if RJL023_1==6;
replace earnprev15=RJL022_1*(RJL021_1/4) if RJL023_1==4;
replace earnprev15=RJL022_1*(RJL021_1/2) if RJL023_1==3|RJL023_1==5;
replace earnprev15=RJL022_1*(RJL021_1) if RJL023_1==2;
replace earnprev15=(RJL022_1*RJL021_1*RJL020_1) if RJL023_1==1;

replace earnprev15=. if earnprev15>16000000 & RJL023_1==1; //this might be a bug - have a look when final version of wave 15 is out

replace earnprev15=.  if RJL020_1>997 | RJL020_1==-8 ;                                           //drop top codes for hours worked per week  
replace earnprev15=.  if RJL021_1>97 | RJL021_1==-8;                                            //drop top codes for weeks worked per year
replace earnprev15=.  if RJL022_1>999990 | RJL022_1==-8;                                        //drop top codes for earnings
************* hourly wages******************;
gen wageprev15=earnprev15/(RJL020_1*RJL021_1); *earn/(hrs a week*weeks worked);



gen peneage15=.;
gen pennage15=.;



******GOVT WORKERS************************************************;


gen Govt15=0;
replace Govt15=1 if RJ720==1;
tab RJ720;
tab Govt15;

* if someone does not report the years they worked for govt, assume the last 20;
gen GovtBegin15=1996;
gen GovtEnd15=2016;
gen GovtYears15=GovtEnd15-GovtBegin15;
sort Govt15;
by Govt15: sum Govt*;

*Jobs covered by SS;

gen SScov15=0;
replace SScov15=1 if RJ676==1; 

* years in job not covered by SS;

gen SSBegin15=.;
gen SSEnd15=.;
gen ExSSYears15=.;


gen SSYears15=.;
replace SSYears15= RJL3111 if RJL3111<97;
replace SSYears15=1 if SSYears15<1 & SSYears15~=.;

sort SScov15;
by SScov15: sum SS*;

*proxy w/ GovtYears

replace SScov15=1 if (SScov15==0|SScov15==.) & Govt15==1;
sort SScov15;
by SScov15: sum SSYears15 SScov15;
replace SSYears15=GovtYears15 if SScov15==1 & (SSYears15==.|SSYears15==0) & GovtYears15~=.; 
sort SScov15;
by SScov15: sum SSYears15 SScov15;
replace SSEnd15=GovtEnd15 if SScov15==1 & Govt15==1 & SSEnd15==.;



***********************************************************************************************************************************************************
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen15 peneage15 pennage15; 
drop QJ* RJ*;                                                                 
keep pen* ten* HHID PN earn* wage* SS* Govt* same_pen15 peneage15 pennage15;                    
sort HHID PN;

merge HHID PN using `saved'pension; 
drop _merge; 
summ pentypeDB15* pentypeDC15* peneage15 pennage15;
sort pentypeDB15curr;
by pentypeDB15curr: summ pennage15 peneage15 pentypeDB15curr; 

replace pentypeDB15curr=pentypeDB12curr if same_pen15==1 & pentypeDB12curr~=. & pentypeDB15curr==0;
replace pentypeDC15curr=pentypeDC12curr if same_pen15==1 & pentypeDC12curr~=. & pentypeDC15curr==0 ;
replace peneage15=peneage12 if same_pen15==1 & peneage12~=. & peneage15==.;
replace pennage15=pennage12 if same_pen15==1 & pennage12~=. & pennage15==.;

summ pentypeDB15curr pentypeDC15curr peneage15 pennage15;
sort pentypeDB15curr;
by pentypeDB15curr: summ pennage15 peneage15 pentypeDB15curr;



sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 

};



*********************Generate SScov, SSYears, Govt, Govtyears variables*********************;

*Will need to be updated whenever a new cohort is brought in, likely next in round 13;

*   When updating, confirm that new Govt and SS variables are reasonably mutually exclusive from 
*   previous ones, so that taking the max will not lead to any suspicious numbers;


use `saved'pension;
gen Govt = max(Govt1, Govt4, Govt7, Govt10, Govt13);
gen GovtYears= max(GovtYears1, GovtYears4, GovtYears7, GovtYears10, GovtYears13);
gen SScov = max(SScov3, SScov4, SScov7, SScov10, SScov13);
gen SSYears= max(SSYears3, SSYears4, SSYears7, SSYears10, SSYears13);
replace GovtYears=0 if GovtYears==.;
replace SSYears=0 if SSYears==.;


sort HHID PN; 
summ;
sleep 1000;  save `saved'pension, replace;
drop _all; 

**********************************AHEAD WAVE2-1995*******************************************;


use `aheadw2'A95PR_R; *  we need to use this updated file;
keep HHID PN D150;
sort HHID PN;
save `aheadw2'temp, replace;

clear;
*set mem 200m;
use `aheadw2'A95CS_R; * we need to use this updated file;
keep HHID PN D370 D373;
sort HHID PN;
merge HHID PN using `aheadw2'temp;
drop _merge;
sort HHID PN;
save `aheadw2'temp, replace;

clear;
*set mem 200m;
use `aheadw2'A95G_R; * we need to use this updated file;
sort HHID PN;
merge HHID PN using `aheadw2'temp;
drop _merge;

gen temp=real(HHID); 
drop HHID;
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 



******************** variable same_penA *********************;
gen same_pen2A=0;
replace same_pen2A=1 if D2928==5;* THERE ARE HUGE# OF BLANKS, AND D2928 HAS ONLY 2 VALUES(==5,==7);
tabulate same_pen2A;


*******************************************************************************;
********************pension type - DB plan (type A) ***************************; 

gen pentypeDB2Acurr=.;
gen pentypeDB2Alast=.;
gen pentypeDB2Aprev=.;

replace pentypeDB2Acurr=0 if D2643==9995; *never worked for pay;
replace pentypeDB2Acurr=0 if (D373>1920|D2651==5|D2651==8); *, born after 1920,doing any work for pay at present?-No, DK;
replace pentypeDB2Acurr=0 if D2652==5|D2652==8; *retired, any work since wave1? - No, DK;


************************* for non self-employed *********************;

replace pentypeDB2Acurr=0 if D2847<520|D2847==520; * hours per year year<520. In this case, we think it is too little time for a job, so there should not be any pension for this worker;
replace pentypeDB2Acurr=0 if D2928==7; *denies being covered by a pension;
replace pentypeDB2Acurr=0 if D2956==5|D2955==8; *employer offers pension? - No, DK;
replace pentypeDB2Acurr=0 if D2957==6|D2957==8; *are you eligible to be included in plan, 6=elig if worked full time; 
replace pentypeDB2Acurr=0 if D2959==1|D2959==5|D2959==8; *do you intend to participate in any plans in the future; 

replace pentypeDB2Acurr=0 if D2960==3|D2960==5; *will you be eligible if you continue to work for this employer--Depends,No;

replace pentypeDB2Acurr=1 if D2685==1|D2685==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D2685==2;

replace pentypeDB2Acurr=1 if D2776==1|D2776==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D2776==2;

* for pension plan 1;
replace pentypeDB2Acurr=1 if D2969_1==1|D2969_1==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D2969_1==2;

 * for pension plan 2;
replace pentypeDB2Acurr=1 if D2969_2==1|D2969_2==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D2969_2==2;

* for pension plan 3;
replace pentypeDB2Acurr=1 if D2969_3==1|D2969_3==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D2969_3==2;


************** for self-employed persons **************;

replace pentypeDB2Acurr=0 if D2653==2 & (D3277<520|D3277==520); *self-employed and works <520 hrs/yr;
replace pentypeDB2Acurr=0 if D2653==2 & (D3287==5|D3287==8); *included in a pension plan? - No, Dk;


replace pentypeDB2Acurr=1 if D3209==1|D3209==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D3209==2;

replace pentypeDB2Acurr=1 if D3330_1==1|D3330_1==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D3330_1==2;

replace pentypeDB2Acurr=1 if D3574==1|D3574==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D3574==2;

replace pentypeDB2Acurr=1 if D3657==1|D3657==3;
replace pentypeDB2Acurr=0 if pentypeDB2Acurr~=1 & D3657==2;



**************************************** pension type B ***********************;
*******************************************************************************;
* pentypeDC2Acurr is created to reflect pension type b, account based;

************************* for non self-employed *********************;

gen pentypeDC2Acurr=.;
gen pentypeDC2Alast=.;
gen pentypeDC2Aprev=.;



replace pentypeDC2Acurr=0 if D2643==9995; *never worked for pay;
replace pentypeDC2Acurr=0 if (D373>1920|D2651==5|D2651==8); *born after 1920,doing any work for pay at present?-No, DK;
replace pentypeDC2Acurr=0 if D2652==5|D2652==8; *retired, any work since wave1? - No, DK;

************************* for non self-employed *********************;

replace pentypeDC2Acurr=0 if D2847<520|D2847==520; * hours per year year<520. In this case, we think it is too little time for a job, so there should not be any pension for this worker;
replace pentypeDC2Acurr=0 if D2928==7; *denies being covered by a pension;
replace pentypeDC2Acurr=0 if D2956==5|D2955==8; *employer offers pension? - No, DK;
replace pentypeDC2Acurr=0 if D2957==6|D2957==8; *are you eligible to be included in plan, 6=elig if worked full time; 
replace pentypeDC2Acurr=0 if D2959==1|D2959==5|D2959==8; *do you intend to participate in any plans in the future; 

replace pentypeDC2Acurr=0 if D2960==3|D2960==5; *will you be eligible if you continue to work for this employer--Depends,No;


replace pentypeDC2Acurr=1 if D2685==2|D2685==3;
replace pentypeDC2Acurr=0 if D2685==1;

replace pentypeDC2Acurr=1 if D2776==2|D2776==3;
replace pentypeDC2Acurr=0 if D2776==1;

* for pension plan 1;
replace pentypeDC2Acurr=1 if D2969_1==2|D2969_1==3;
replace pentypeDC2Acurr=0 if D2969_1==1;


 * for pension plan 2;
replace pentypeDC2Acurr=1 if D2969_2==2|D2969_2==3;
replace pentypeDC2Acurr=0 if D2969_2==1;

* for pension plan 3;
replace pentypeDC2Acurr=1 if D2969_3==2|D2969_3==3;
replace pentypeDC2Acurr=0 if D2969_3==1;


************** for self-employed persons **************;

replace pentypeDC2Acurr=0 if D2653==2 & (D3277<520|D3277==520);*self-employed and works <520 hrs/yr;
replace pentypeDC2Acurr=0 if D2653==2 & (D3287==5|D3287==8);*included in a pension plan? - No, Dk;

replace pentypeDC2Acurr=1 if D3209==1|D3209==3;
replace pentypeDC2Acurr=0 if D3209==2;

replace pentypeDC2Acurr=1 if D3330_1==2|D3330_1==3;
replace pentypeDC2Acurr=0 if D3330_1==1;

replace pentypeDC2Acurr=1 if D3574==1|D3574==3;
replace pentypeDC2Acurr=0 if D3574==2;

replace pentypeDC2Acurr=1 if D3657==1|D3657==3;
replace pentypeDC2Acurr=0 if D3657==2;





******************************************************************;
******************* age to receive full benefits *****************; 

************************ for not self-employed **********************;
* for pension plan 1;

gen pennage2A=.;
replace pennage2A=D2992_1 if D2992_1~=. & D2992_1<95;
replace pennage2A=35 if D2992_1==95;* access pension benefits anytime;
replace pennage2A=. if D2992_1>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace pennage2A=D2992_2 if pennage2A~=. & D2992_2~=. & pennage2A>D2992_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace pennage2A=D2992_2 if pennage2A==. & D2992_2~=. & D2992_2<95;
replace pennage2A=35 if D2992_2==95; * access pension benefits anytime;

* for pension plan 3;
replace pennage2A=D2992_3 if pennage2A~=. & D2992_3~=. & pennage2A>D2992_3; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace pennage2A=D2992_3 if pennage2A==. & D2992_3~=. & D2992_3<95; 
replace pennage2A=35 if D2992_3==95; * access pension benefits anytime;

***************************** for self-employed **********************;

replace pennage2A=D3354_1 if D3354_1~=. & D3354_1<95;
replace pennage2A=35 if D3354_1==95;





**** the following re-coding may not be logically thorough enough;
* replace D2992_1=96 if D2992_1==.| D2992_1==0;
* replace D2992_2=96 if D2992_2==.| D2992_2==0;
* replace D2992_3=96 if D2992_3==.| D2992_3==0;
* gen pennage2A=min(D2992_1, D2992_2, D2992_3);
* replace pennage2A=30 if pennage2A==95;
* replace pennage2A=. if pennage2A==0|pennage2A>95;

****************   earliest age to still receive benefits ********************;
******************************************************************************;

***************** for not self-employed ********************;
gen peneage2A=.;

* for pension plan 1;
replace peneage2A=D3008_2 if D3008_1~=. & D3008_1<95;
replace peneage2A=35 if D3008_1==95; * access pension benefits any time. I re-coded it as age 35;
replace peneage2A=. if peneage2A>95; * "no job" or "no pension" or "NA" or "DK", or "other";

* for pension plan 2;
replace peneage2A=D3008_2 if peneage2A~=. & D3008_2~=. & peneage2A>D3008_2; * age of accessing pension benefits for pension plan 2 is younger than that of pension plan 1;
replace peneage2A=D3008_2 if peneage2A==. & D3008_2<95;
replace peneage2A=35 if D3008_2==95; * access pension benefits anytime;

* for pension plan 3;
replace peneage2A=D3008_3 if peneage2A~=. & D3008_3~=. & peneage2A>D3008_3; * age of accessing pension benefits for pension plan 3 is younger than that of pension plan 1 and 2;
replace peneage2A=D3008_3 if peneage2A==. & D3008_3~=. & D3008_3<95;
replace peneage2A=35 if D3008_3==95; * access pension benefits anytime;

*****************  for self-employed ******************;
replace peneage2A=D3370_1 if D3370_1~=. & D3370_1<95;
replace peneage2A=35 if D3370_1==95;


***** the following re-coding may not be logically thorough enough;
* replace D3008_1=96 if D3008_1==.| D3008_1==0;
* replace D3008_2=96 if D3008_2==.| D3008_2==0;
* replace D3008_3=96 if D3008_3==.| D3008_3==0;
* gen peneage2A=min(D3008_1, D3008_2, D3008_3);
* replace peneage2A=30 if peneage2A==95;
* replace peneage2A=. if peneage2A==0|peneage2A>95;
*D3008 What is the earliest age at which you could leave this employer and start to receive pension benefits?;



*******************************************************************;
*************************now calculate pension wealth********;

gen penwDC2A=.;

replace D2740=0 if (D2740==.|D2740>9900000);

replace D2813=0 if (D2813==.|D2813>9900000);

replace D2970_1=0 if (D2970_1==.|D2970_1>9900000); 
replace D2970_2=0 if (D2970_2==.|D2970_2>9900000); 
replace D2970_3=0 if (D2970_3==.|D2970_3>9900000); 

replace D3037_1=0 if (D3037_1==.| D3037_1>9900000); 
replace D3037_2=0 if (D3037_2==.| D3037_2>9900000); 
replace D3037_3=0 if (D3037_3==.| D3037_3>9900000); 
 
replace D3245=0 if (D3245==.| D3245>9900000); 

replace D3331_1=0 if (D3331_1==.| D3331_1>9900000); 
 
replace D3690=0 if (D3690==.| D3690>9900000); 

replace penwDC2A=D2740+D2813+D2970_1+D2970_2+D2970_3+D3037_1+D3037_2+D3037_3+D3245+D3331_1+D3690;
sum penwDC2A;
gen penwDC2currA=penwDC2A;
gen penwDC2lastA=0;
gen penwDC2prevA=0;

sort pentypeDB2Acurr;
by pentypeDB2Acurr: summ pennage2A;

keep pen* peneage2A same_pen* HHID PN;
sort HHID PN; 
* save `aheadw2'PENSION,replace; 

merge HHID PN using `saved'pension; 
drop _merge; 
replace pentypeDB2Acurr=pentypeDB1 if same_pen2A==1 & pentypeDB1~=.;
replace pentypeDC2Acurr=pentypeDC1 if same_pen2A==1 & pentypeDC1~=.;
replace peneage2A=peneage1 if same_pen2A==1 & peneage1~=.;
replace pennage2A=pennage1 if same_pen2A==1 & pennage1~=.;

sort pentypeDB2Acurr;
by pentypeDB2Acurr: summ pennage2A;
replace pentypeDB2curr=pentypeDB2Acurr if pentypeDB2curr==. & pentypeDB2Acurr~=.;
replace pentypeDC2curr=pentypeDC2Acurr if pentypeDC2curr==. & pentypeDC2Acurr~=.;
replace peneage2=peneage2A if peneage2==. & peneage2A~=.;
replace pennage2=pennage2A if pennage2==. & pennage2A~=.;
* no info on last or other pension;
replace penwDC2= penwDC2A if penwDC2==. & penwDC2A~=.;
replace penwDC2curr= penwDC2currA if penwDC2curr==. & penwDC2currA~=.;
replace penwDC2prev= penwDC2prevA if penwDC2prev==. & penwDC2prevA~=.;
replace penwDC2last= penwDC2lastA if penwDC2last==. & penwDC2lastA~=.;

drop pentypeDB2Acurr pentypeDC2Acurr peneage2A pennage2A ;
drop pentypeDB2Alast pentypeDB2Aprev 
pentypeDC2Alast pentypeDC2Aprev  penwDC2A same_pen2A pentypeDB1 pentypeDC1 ;

/*gen wagelast2=.;
gen wagelast3=.;
gen wagelast4=.;
gen wagelast5=.;

gen earnlast2=.;
gen earnlast3=.;
gen earnlast4=.;
gen earnlast5=.;

gen earnprev2=.;
gen earnprev3=.;
gen earnprev4=.;
gen earnprev5=.;*/
summ wageprev*;
summ wagelast*;

drop same*;

sort HHID PN; 

summ pen* peneage*;
summ;
sleep 1000;  save `saved'pension, replace;

* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(pension.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'pension.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(pension.xlsx) sheetname(Old);



drop _all; 
cap log close;





